/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;

    ShowAutoImportPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project == null) {
            ShowAutoImportPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ShowAutoImportPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range2 = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range2.getStartOffset();
        this.myEndOffset = range2.getEndOffset();
        this.myFile = file2;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ShowAutoImportPass.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        TransactionGuard.submitTransaction((Disposable)this.myProject, this::addImports);
    }

    private void addImports() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!application.isHeadlessEnvironment() && !this.myEditor.getContentComponent().hasFocus()) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor);
        for (int i = visibleHighlights.size() - 1; i >= 0; --i) {
            HighlightInfo info = visibleHighlights.get(i);
            if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
            return;
        }
        for (HighlightInfo visibleHighlight : visibleHighlights) {
            if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
            return;
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return;
        }
        Document document = this.myEditor.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && info.getSeverity() == HighlightSeverity.ERROR && !info.getFixTextRange().containsOffset(caretOffset)) {
                infos.add(info);
            }
            return true;
        }));
        List importers = ReferenceImporter.EP_NAME.getExtensionList();
        for (HighlightInfo info2 : infos) {
            ReferenceImporter importer;
            HintAction action2;
            Iterator<Object> iterator = ShowAutoImportPass.extractHints(info2).iterator();
            while (!(!iterator.hasNext() || (action2 = iterator.next()).isAvailable(this.myProject, this.myEditor, this.myFile) && action2.fixSilently(this.myEditor))) {
            }
            iterator = importers.iterator();
            while (iterator.hasNext() && !(importer = (ReferenceImporter)iterator.next()).autoImportReferenceAt(this.myEditor, this.myFile, info2.getActualStartOffset())) {
            }
        }
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, @NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            ShowAutoImportPass.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ShowAutoImportPass.$$$reportNull$$$0(5);
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project, null, startOffset, endOffset, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        }));
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info) {
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(7);
        }
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile)) {
            return false;
        }
        PsiElement element = this.myFile.findElementAt(info.startOffset);
        if (element == null || !element.isValid()) {
            return false;
        }
        for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
            if (!action2.isAvailable(this.myProject, this.myEditor, this.myFile) || !action2.showHint(this.myEditor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<HintAction> extractHints(@NotNull HighlightInfo info) {
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2;
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(8);
        }
        if ((list2 = info.quickFixActionRanges) == null) {
            List<HintAction> list3 = Collections.emptyList();
            if (list3 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(9);
            }
            return list3;
        }
        SmartList hintActions = new SmartList();
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list2) {
            IntentionAction action2 = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action2 instanceof HintAction)) continue;
            hintActions.add((HintAction)action2);
        }
        SmartList smartList = hintActions;
        if (smartList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    @NotNull
    public static String getMessage(boolean multiple, @NotNull String name) {
        if (name == null) {
            ShowAutoImportPass.$$$reportNull$$$0(11);
        }
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        String string = hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (string == null) {
            ShowAutoImportPass.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleHighlights";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHints";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleHighlights";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showAddImportHint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractHints";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

