/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.Interpolable;
import com.intellij.ui.components.Interpolator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.MacScrollBarUI;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ScrollSource;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class JBScrollBar
extends JScrollBar
implements IdeGlassPane.TopComponent,
Interpolable {
    public static final Key<RegionPainter<Object>> TRACK = Key.create((String)"JB_SCROLL_BAR_TRACK");
    public static final String LEADING = "JB_SCROLL_BAR_LEADING_COMPONENT";
    public static final String TRAILING = "JB_SCROLL_BAR_TRAILING_COMPONENT";
    private static final double THRESHOLD = 1.00001;
    private final Interpolator myInterpolator = new Interpolator(this::getValue, this::setCurrentValue);
    private double myFractionalRemainder;
    private boolean wasPositiveDelta;
    private boolean isUnitIncrementSet;
    private boolean isBlockIncrementSet;

    public JBScrollBar() {
        this(1);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JBScrollBar(@JdkConstants.AdjustableOrientation int orientation, int value, int extent, int min, int max) {
        super(orientation, value, extent, min, max);
        this.setModel(new Model(value, extent, min, max));
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
    }

    @Override
    protected void addImpl(Component component, Object name, int index) {
        Key<Component> key;
        Object object = LEADING.equals(name) ? DefaultScrollBarUI.LEADING : (key = TRAILING.equals(name) ? DefaultScrollBarUI.TRAILING : null);
        if (key != null) {
            Component old = (Component)UIUtil.getClientProperty((Object)this, key);
            UIUtil.putClientProperty((JComponent)this, key, (Object)component);
            if (old != null) {
                this.remove(old);
            }
        }
        super.addImpl(component, name, index);
    }

    @Override
    public void updateUI() {
        ScrollBarUI ui = this.getUI();
        if (ui instanceof DefaultScrollBarUI) {
            return;
        }
        this.setUI(JBScrollBar.createUI(this));
    }

    public static ScrollBarUI createUI(JComponent c) {
        return SystemInfo.isMac ? new MacScrollBarUI() : new DefaultScrollBarUI();
    }

    @Override
    public int getUnitIncrement(int direction) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Font font;
            Scrollable scrollable = this.getScrollableViewToCalculateIncrement(viewport.getView());
            if (scrollable != null) {
                return scrollable.getScrollableUnitIncrement(viewport.getViewRect(), this.orientation, direction);
            }
            if (!this.isUnitIncrementSet && (font = JBScrollBar.getViewFont(viewport)) != null) {
                return font.getSize();
            }
        }
        return super.getUnitIncrement(direction);
    }

    @Override
    public void setUnitIncrement(int increment) {
        this.isUnitIncrementSet = true;
        super.setUnitIncrement(increment);
    }

    @Override
    public int getBlockIncrement(int direction) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Scrollable scrollable = this.getScrollableViewToCalculateIncrement(viewport.getView());
            if (scrollable != null) {
                return scrollable.getScrollableBlockIncrement(viewport.getViewRect(), this.orientation, direction);
            }
            if (!this.isBlockIncrementSet) {
                Dimension size = viewport.getExtentSize();
                return this.orientation == 0 ? size.width : size.height;
            }
        }
        return super.getBlockIncrement(direction);
    }

    @Override
    public void setBlockIncrement(int increment) {
        this.isBlockIncrementSet = true;
        super.setBlockIncrement(increment);
    }

    @Override
    public boolean canBePreprocessed(@NotNull MouseEvent event) {
        if (event == null) {
            JBScrollBar.$$$reportNull$$$0(0);
        }
        return JBScrollPane.canBePreprocessed(event, this);
    }

    @Override
    public void setValue(int value) {
        JBScrollPane pane;
        JViewport viewport;
        int delay = 0;
        Container parent = this.getParent();
        if (parent instanceof JBScrollPane && (viewport = (pane = (JBScrollPane)parent).getViewport()) != null && ScrollSettings.isEligibleFor(viewport.getView()) && ScrollSettings.isInterpolationEligibleFor(this)) {
            delay = pane.getInitialDelay(this.getValueIsAdjusting());
        }
        if (delay > 0) {
            this.myInterpolator.setTarget(value, delay);
        } else {
            super.setValue(value);
        }
    }

    @Override
    public void setCurrentValue(int value) {
        super.setValue(value);
        this.myFractionalRemainder = 0.0;
    }

    @Override
    public int getTargetValue() {
        return this.myInterpolator.getTarget();
    }

    public boolean handleMouseWheelEvent(MouseWheelEvent event) {
        double maxDelta;
        if (0 != event.getScrollType()) {
            return false;
        }
        if (event.isShiftDown() == (this.orientation == 1)) {
            return false;
        }
        if (!ScrollSettings.isEligibleFor(this)) {
            return false;
        }
        double delta = this.getPreciseDelta(event);
        if (!Double.isFinite(delta)) {
            return false;
        }
        int value = this.getTargetValue();
        double minDelta = this.getMinimum() - value;
        double deltaAdjusted = Math.max(minDelta, Math.min(maxDelta = (double)(this.getMaximum() - this.getVisibleAmount() - value), delta));
        if (deltaAdjusted != 0.0) {
            int valueAdjusted;
            boolean isPositiveDelta;
            boolean bl = isPositiveDelta = deltaAdjusted > 0.0;
            if (this.wasPositiveDelta != isPositiveDelta) {
                this.wasPositiveDelta = isPositiveDelta;
                this.myFractionalRemainder = 0.0;
            }
            if ((valueAdjusted = (int)(deltaAdjusted += this.myFractionalRemainder)) == 0) {
                this.myFractionalRemainder = deltaAdjusted;
            } else {
                this.myFractionalRemainder = deltaAdjusted - (double)valueAdjusted;
                this.setValue(value + valueAdjusted);
            }
        } else if (delta != 0.0) {
            return true;
        }
        event.consume();
        return true;
    }

    private JViewport getViewport() {
        Container parent = this.getParent();
        if (parent instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)parent;
            return pane.getViewport();
        }
        return null;
    }

    private static Font getViewFont(JViewport viewport) {
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        return view == null ? null : view.getFont();
    }

    private Scrollable getScrollableViewToCalculateIncrement(Component view) {
        return view instanceof JTable || view instanceof Scrollable && this.orientation == 1 ? (Scrollable)((Object)view) : null;
    }

    private static double boundDelta(double minDelta, double maxDelta, double delta) {
        return Math.max(minDelta, Math.min(maxDelta, delta));
    }

    private double getPreciseDelta(MouseWheelEvent event) {
        double rotation = event.getPreciseWheelRotation();
        if (ScrollSettings.isPixelPerfectEnabled()) {
            if (SystemInfo.isMac) {
                return 10.0 * rotation;
            }
            JViewport viewport = this.getViewport();
            Font font = viewport == null ? null : JBScrollBar.getViewFont(viewport);
            int size = font == null ? JBUIScale.scale((int)10) : font.getSize();
            return (double)size * rotation * (double)event.getScrollAmount();
        }
        if (ScrollSettings.isHighPrecisionEnabled()) {
            int direction = rotation < 0.0 ? -1 : 1;
            int unitIncrement = this.getUnitIncrement(direction);
            double delta = (double)unitIncrement * rotation * (double)event.getScrollAmount();
            if (-1.00001 > delta && delta > 1.00001) {
                return delta;
            }
            double blockIncrement = this.getBlockIncrement(direction);
            return JBScrollBar.boundDelta(-blockIncrement, blockIncrement, delta);
        }
        return Double.NaN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/components/JBScrollBar", "canBePreprocessed"));
    }

    private static final class Model
    extends DefaultBoundedRangeModel {
        private Model(int value, int extent, int min, int max) {
            super(value, extent, min, max);
        }

        @Override
        protected void fireStateChanged() {
            if (this.getValueIsAdjusting() && ScrollSource.SCROLLBAR.isInterpolationEnabled()) {
                Object[] listeners = this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    ChangeListener listener2;
                    if (listeners[i] != ChangeListener.class || (listener2 = (ChangeListener)listeners[i + 1]).getClass().getName().contains("ScrollBarUI")) continue;
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    listener2.stateChanged(this.changeEvent);
                }
            } else {
                super.fireStateChanged();
            }
        }
    }
}

