/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.CompletionPopupListener;
import com.intellij.stats.completion.CompletionUtil;
import com.intellij.stats.completion.DeferredLog;
import com.intellij.stats.experiment.WebServiceStatus;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J'\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/stats/completion/CompletionActionsTracker;", "Lcom/intellij/stats/completion/CompletionPopupListener;", "Lcom/intellij/codeInsight/lookup/impl/PrefixChangeListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "logger", "Lcom/intellij/stats/completion/CompletionLogger;", "experimentHelper", "Lcom/intellij/stats/experiment/WebServiceStatus;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/stats/completion/CompletionLogger;Lcom/intellij/stats/experiment/WebServiceStatus;)V", "completionStarted", "", "deferredLog", "Lcom/intellij/stats/completion/DeferredLog;", "selectedByDotTyping", "afterAppend", "", "c", "", "afterBackspacePressed", "beforeBackspacePressed", "beforeCharTyped", "beforeDownPressed", "beforeUpPressed", "currentItemChanged", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "downPressed", "isCompletionActive", "itemSelected", "logPerformance", "key", "", "measure", "", "timestamp", "(Ljava/lang/String;Ljava/lang/Long;J)V", "lookupCanceled", "upPressed", "Companion", "intellij.statsCollector"})
public final class CompletionActionsTracker
implements CompletionPopupListener,
PrefixChangeListener,
LookupListener {
    private boolean completionStarted;
    private boolean selectedByDotTyping;
    private final DeferredLog deferredLog;
    private final LookupImpl lookup;
    private final CompletionLogger logger;
    private final WebServiceStatus experimentHelper;
    @NotNull
    public static final String INITIAL_CONTRIBUTION_KEY = "ml.contribution.initial";
    @NotNull
    public static final String CURRENT_CONTRIBUTION_KEY = "ml.contribution.current";
    @NotNull
    public static final String TOTAL_CONTRIBUTION_KEY = "ml.contribution.total";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompletionActive() {
        if (this.completionStarted) {
            if (!this.lookup.isLookupDisposed()) return true;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        boolean wasTyped;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Long mlTimeContribution = CompletionUtil.INSTANCE.getMLTimeContribution(this.lookup);
        List items = this.lookup.getItems();
        LookupElement currentItem = this.lookup.getCurrentItem();
        if (currentItem == null) {
            this.deferredLog.clear();
            this.logPerformance(TOTAL_CONTRIBUTION_KEY, mlTimeContribution, timestamp - 1L);
            this.logger.completionCancelled(timestamp);
            return;
        }
        String string = this.lookup.itemPattern(currentItem);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lookup.itemPattern(currentItem)");
        String prefix = string;
        List list = items;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"items");
        Object object = (LookupElement)CollectionsKt.firstOrNull((List)list);
        boolean bl = object != null && (object = object.getLookupString()) != null ? ((String)object).equals(prefix) : (wasTyped = false);
        if (wasTyped || this.selectedByDotTyping) {
            this.deferredLog.log();
            this.logPerformance(TOTAL_CONTRIBUTION_KEY, mlTimeContribution, timestamp - 1L);
            this.logger.itemSelectedByTyping(this.lookup, timestamp);
        } else {
            this.deferredLog.clear();
            this.logPerformance(TOTAL_CONTRIBUTION_KEY, mlTimeContribution, timestamp - 1L);
            this.logger.completionCancelled(timestamp);
        }
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Long mlTimeContribution = CompletionUtil.INSTANCE.getMLTimeContribution(this.lookup);
        this.completionStarted = true;
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp, mlTimeContribution){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ Long $mlTimeContribution;

            public final void invoke() {
                boolean isPerformExperiment = CompletionActionsTracker.access$getExperimentHelper$p(this.this$0).isExperimentOnCurrentIDE();
                int experimentVersion = CompletionActionsTracker.access$getExperimentHelper$p(this.this$0).experimentVersion();
                Long l = this.$mlTimeContribution;
                CompletionActionsTracker.access$getLogger$p(this.this$0).completionStarted(CompletionActionsTracker.access$getLookup$p(this.this$0), isPerformExperiment, experimentVersion, this.$timestamp, l != null ? l : -1L);
                CompletionActionsTracker.access$Companion();
                CompletionActionsTracker.access$logPerformance(this.this$0, "ml.contribution.initial", this.$mlTimeContribution, this.$timestamp + 1L);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                this.$mlTimeContribution = l2;
                super(0);
            }
        }));
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.logPerformance(TOTAL_CONTRIBUTION_KEY, CompletionUtil.INSTANCE.getMLTimeContribution(this.lookup), timestamp - 1L);
        this.logger.itemSelectedCompletionFinished(this.lookup, timestamp);
    }

    @Override
    public void beforeDownPressed() {
        this.deferredLog.log();
    }

    @Override
    public void downPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).downPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeUpPressed() {
        this.deferredLog.log();
    }

    @Override
    public void upPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).upPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        this.deferredLog.log();
    }

    @Override
    public void afterBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterBackspacePressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeCharTyped(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        if (c == '.') {
            LookupElement item = this.lookup.getCurrentItem();
            if (item == null) {
                this.logger.customMessage("Before typed " + c + " lookup.currentItem is null; lookup size: " + this.lookup.getItems().size(), timestamp);
                return;
            }
            String string = this.lookup.itemPattern(item);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lookup.itemPattern(item)");
            String text = string;
            if (Intrinsics.areEqual((Object)item.getLookupString(), (Object)text)) {
                this.selectedByDotTyping = true;
            }
        }
    }

    public void afterAppend(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Long mlTimeContribution = CompletionUtil.INSTANCE.getMLTimeContribution(this.lookup);
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, c, timestamp, mlTimeContribution){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ char $c;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ Long $mlTimeContribution;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterCharTyped(this.$c, CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
                CompletionActionsTracker.access$Companion();
                CompletionActionsTracker.access$logPerformance(this.this$0, "ml.contribution.current", this.$mlTimeContribution, this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$c = c;
                this.$timestamp = l;
                this.$mlTimeContribution = l2;
                super(0);
            }
        }));
    }

    private final void logPerformance(String key, Long measure, long timestamp) {
        if (measure != null) {
            this.logger.performanceMessage(key, measure, timestamp);
        }
    }

    public CompletionActionsTracker(@NotNull LookupImpl lookup, @NotNull CompletionLogger logger, @NotNull WebServiceStatus experimentHelper) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)experimentHelper, (String)"experimentHelper");
        this.lookup = lookup;
        this.logger = logger;
        this.experimentHelper = experimentHelper;
        this.deferredLog = new DeferredLog();
    }

    public static final /* synthetic */ WebServiceStatus access$getExperimentHelper$p(CompletionActionsTracker $this) {
        return $this.experimentHelper;
    }

    public static final /* synthetic */ CompletionLogger access$getLogger$p(CompletionActionsTracker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ LookupImpl access$getLookup$p(CompletionActionsTracker $this) {
        return $this.lookup;
    }

    public static final /* synthetic */ void access$logPerformance(CompletionActionsTracker $this, String key, Long measure, long timestamp) {
        $this.logPerformance(key, measure, timestamp);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/stats/completion/CompletionActionsTracker$Companion;", "", "()V", "CURRENT_CONTRIBUTION_KEY", "", "INITIAL_CONTRIBUTION_KEY", "TOTAL_CONTRIBUTION_KEY", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

