/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import java.lang.reflect.Type;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0005\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/serialization/PolymorphicBinding;", "Lcom/intellij/serialization/Binding;", "superClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "deserialize", "", "context", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "doDeserialize", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class PolymorphicBinding
implements Binding {
    private final Class<?> superClass;

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Class<?> valueClass = obj2.getClass();
        IonWriter writer = context.getWriter();
        if (!context.getConfiguration().getAllowAnySubTypes()) {
            throw (Throwable)new SerializationException("Polymorphic type without specified allowed sub types is forbidden");
        }
        writer.addTypeAnnotation(valueClass.getName());
        context.getBindingProducer().getRootBinding(valueClass).serialize(obj2, context);
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkParameterIsNotNull((Object)hostObject, (String)"hostObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean $i$f$read = false;
        if (context.getReader().getType() == IonType.NULL) {
            property.set(hostObject, null);
        } else {
            IonReader ionReader = context.getReader();
            Object object = hostObject;
            MutableAccessor mutableAccessor = property;
            boolean bl = false;
            Object object2 = this.doDeserialize(context, hostObject);
            mutableAccessor.set(object, object2);
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = this.doDeserialize(context, hostObject);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    private final Object doDeserialize(ReadContext context, Object hostObject) {
        if (!context.getConfiguration().getAllowAnySubTypes()) {
            throw (Throwable)new SerializationException("Polymorphic type without specified allowed sub types is forbidden");
        }
        IonReader reader = context.getReader();
        Class beanClass = null;
        Iterator typeAnnotationIterator = reader.iterateTypeAnnotations();
        if (typeAnnotationIterator.hasNext()) {
            String className = (String)typeAnnotationIterator.next();
            Function2<String, Object, Class<?>> loadClass = context.getConfiguration().getLoadClass();
            if (loadClass == null || hostObject == null) {
                Class clazz = this.getClass().getClassLoader().loadClass(className);
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"javaClass.classLoader.loadClass(className)");
                beanClass = clazz;
            } else {
                String string = className;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                Class clazz = (Class)loadClass.invoke((Object)string, hostObject);
                if (clazz == null) {
                    return null;
                }
                beanClass = clazz;
            }
            if (!this.superClass.isAssignableFrom(beanClass)) {
                throw (Throwable)new SerializationException("Class \"" + className + "\" must be assignable to \"" + this.superClass.getName() + '\"');
            }
        } else {
            throw (Throwable)new SerializationException("Class name is not specified");
        }
        return context.getBindingProducer().getRootBinding(beanClass).deserialize(context, hostObject);
    }

    public PolymorphicBinding(@NotNull Class<?> superClass) {
        Intrinsics.checkParameterIsNotNull(superClass, (String)"superClass");
        this.superClass = superClass;
    }

    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull WriteContext context) {
        Intrinsics.checkParameterIsNotNull((Object)hostObject, (String)"hostObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Binding.DefaultImpls.serialize(this, hostObject, property, context);
    }

    @Override
    @NotNull
    public Type createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Binding.DefaultImpls.createCacheKey(this, aClass, type);
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)originalType, (String)"originalType");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Binding.DefaultImpls.init(this, originalType, context);
    }
}

