/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConvertTypeCommentToVariableAnnotationIntention
extends PyBaseIntentionAction {
    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiComment typeComment;
        if (project == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(0);
        }
        if ((typeComment = PyConvertTypeCommentToVariableAnnotationIntention.findCommentUnderCaret(editor2, file)) != null) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            SmartPsiElementPointer commentPointer = manager.createSmartPsiElementPointer((PsiElement)typeComment);
            Map<PyTargetExpression, String> map2 = PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(typeComment);
            if (!map2.isEmpty()) {
                if (typeComment.getParent() instanceof PyAssignmentStatement && map2.size() == 1) {
                    PyTargetExpression target = (PyTargetExpression)ContainerUtil.getFirstItem(map2.keySet());
                    assert (target != null);
                    PyTypeHintGenerationUtil.insertVariableAnnotation(target, null, new PyTypeHintGenerationUtil.AnnotationInfo(map2.get(target)), false);
                } else {
                    for (Map.Entry entry : new ArrayList<Map.Entry<PyTargetExpression, String>>(map2.entrySet())) {
                        PyTypeHintGenerationUtil.insertVariableAnnotation((PyTargetExpression)entry.getKey(), null, new PyTypeHintGenerationUtil.AnnotationInfo((String)entry.getValue()), false);
                    }
                }
                PsiComment staleComment = (PsiComment)commentPointer.getElement();
                if (staleComment != null) {
                    staleComment.delete();
                }
            }
        }
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.type.comment.to.variable.annotation.text", new Object[0]);
        if (string == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.type.comment.to.variable.annotation.family", new Object[0]);
        if (string == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(3);
        }
        if (file instanceof PyFile && LanguageLevel.forElement((PsiElement)file).isAtLeast(LanguageLevel.PYTHON36)) {
            PsiComment comment = PyConvertTypeCommentToVariableAnnotationIntention.findCommentUnderCaret(editor2, file);
            return comment != null && PyConvertTypeCommentToVariableAnnotationIntention.isSuitableTypeComment(comment);
        }
        return false;
    }

    @Nullable
    private static PsiComment findCommentUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(5);
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        return (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
    }

    private static boolean isSuitableTypeComment(@NotNull PsiComment comment) {
        String annotation;
        if (comment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(6);
        }
        return (annotation = PyTypingTypeProvider.getTypeCommentValue(comment.getText())) != null && !PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(comment).isEmpty();
    }

    @NotNull
    private static Map<PyTargetExpression, String> mapTargetsToAnnotations(@NotNull PsiComment typeComment) {
        PyExpression target;
        PyWithItem[] withItems;
        PsiElement parent;
        if (typeComment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(7);
        }
        if ((parent = typeComment.getParent()) instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignment = (PyAssignmentStatement)parent;
            PyExpression[] rawTargets = assignment.getRawTargets();
            if (rawTargets.length == 1) {
                Map<PyTargetExpression, String> map2 = PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(rawTargets[0], typeComment);
                if (map2 == null) {
                    PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(8);
                }
                return map2;
            }
        } else if (parent instanceof PyForPart) {
            PyForPart forPart = (PyForPart)parent;
            PyExpression target2 = forPart.getTarget();
            if (target2 != null) {
                Map<PyTargetExpression, String> map3 = PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(target2, typeComment);
                if (map3 == null) {
                    PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(9);
                }
                return map3;
            }
        } else if (parent instanceof PyWithStatement && (withItems = ((PyWithStatement)parent).getWithItems()).length == 1 && (target = withItems[0].getTarget()) != null) {
            Map<PyTargetExpression, String> map4 = PyConvertTypeCommentToVariableAnnotationIntention.mapTargetsToAnnotations(target, typeComment);
            if (map4 == null) {
                PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(10);
            }
            return map4;
        }
        Map<PyTargetExpression, String> map5 = Collections.emptyMap();
        if (map5 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(11);
        }
        return map5;
    }

    @NotNull
    private static Map<PyTargetExpression, String> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PsiComment typeComment) {
        PyTargetExpression firstTarget;
        if (targetExpr == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(12);
        }
        if (typeComment == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(13);
        }
        if ((firstTarget = (PyTargetExpression)PsiTreeUtil.findChildOfType((PsiElement)targetExpr, PyTargetExpression.class, (boolean)false)) == null || firstTarget.getTypeComment() != typeComment) {
            Map<PyTargetExpression, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(14);
            }
            return map2;
        }
        String annotation = PyTypingTypeProvider.getTypeCommentValue(typeComment.getText());
        if (annotation != null) {
            PyExpression parsed;
            if (targetExpr instanceof PyTargetExpression) {
                ImmutableMap immutableMap = ImmutableMap.of((Object)((PyTargetExpression)targetExpr), (Object)annotation);
                if (immutableMap == null) {
                    PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(15);
                }
                return immutableMap;
            }
            PyElementGenerator generator = PyElementGenerator.getInstance(targetExpr.getProject());
            try {
                parsed = generator.createExpressionFromText(LanguageLevel.PYTHON36, annotation);
            }
            catch (IncorrectOperationException e) {
                Map<PyTargetExpression, String> map3 = Collections.emptyMap();
                if (map3 == null) {
                    PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(16);
                }
                return map3;
            }
            Map<PyTargetExpression, PyExpression> targetToExpr = PyTypingTypeProvider.mapTargetsToAnnotations(targetExpr, parsed);
            Map map4 = EntryStream.of(targetToExpr).mapValues(PsiElement::getText).toCustomMap(LinkedHashMap::new);
            if (map4 == null) {
                PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(17);
            }
            return map4;
        }
        Map<PyTargetExpression, String> map5 = Collections.emptyMap();
        if (map5 == null) {
            PyConvertTypeCommentToVariableAnnotationIntention.$$$reportNull$$$0(18);
        }
        return map5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertTypeCommentToVariableAnnotationIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertTypeCommentToVariableAnnotationIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTargetsToAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommentUnderCaret";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableTypeComment";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

