/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.stubs.DomElementTypeHolder;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xmlb.JDOMXIncluder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XIncludeStub
extends ObjectStubBase<ElementStub> {
    private final String myHref;
    private final String myXpointer;
    private volatile CachedValue<DomElement> myCachedValue;

    public XIncludeStub(ElementStub parent, @Nullable String href, @Nullable String xpointer) {
        super((Stub)parent);
        this.myHref = href;
        this.myXpointer = xpointer;
        parent.addChild((Stub)this);
    }

    @NotNull
    public List<? extends Stub> getChildrenStubs() {
        List list = Collections.emptyList();
        if (list == null) {
            XIncludeStub.$$$reportNull$$$0(0);
        }
        return list;
    }

    public ObjectStubSerializer getStubType() {
        return DomElementTypeHolder.XIncludeStub;
    }

    public void resolve(DomInvocationHandler parent, List<DomElement> included, XmlName xmlName) {
        DomElement rootElement;
        XmlFile file = parent.getFile();
        if (this.myCachedValue == null) {
            this.myCachedValue = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                DomElement result = this.computeValue(parent);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            });
        }
        if ((rootElement = (DomElement)this.myCachedValue.getValue()) != null) {
            rootElement.acceptChildren(element -> {
                if (element.getXmlElementName().equals(xmlName.getLocalName())) {
                    included.add(element);
                }
            });
        }
    }

    @Nullable
    private DomElement computeValue(DomInvocationHandler parent) {
        Object result;
        DomFileElement element;
        if (StringUtil.isEmpty((String)this.myHref) || StringUtil.isEmpty((String)this.myXpointer)) {
            return null;
        }
        Matcher matcher = JDOMXIncluder.XPOINTER_PATTERN.matcher(this.myXpointer);
        if (!matcher.matches()) {
            return null;
        }
        String group = matcher.group(1);
        if (!(matcher = JDOMXIncluder.CHILDREN_PATTERN.matcher(group)).matches()) {
            return null;
        }
        String tagName = matcher.group(1);
        XmlFile file = parent.getFile();
        PsiFileImpl dummy = (PsiFileImpl)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText((Language)PlainTextLanguage.INSTANCE, (CharSequence)this.myHref);
        dummy.setOriginalFile((PsiFile)file);
        PsiFileSystemItem fileSystemItem = new FileReferenceSet((PsiElement)dummy).resolve();
        if (fileSystemItem instanceof XmlFile && (element = parent.getManager().getFileElement((XmlFile)fileSystemItem)) != null && (result = element.getRootElement()) != null && tagName.equals(result.getXmlElementName())) {
            return result;
        }
        return null;
    }

    public String toString() {
        return "href=" + this.myHref + " xpointer=" + this.myXpointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/XIncludeStub", "getChildrenStubs"));
    }

    static class XIncludeStubSerializer
    implements ObjectStubSerializer<XIncludeStub, ElementStub> {
        XIncludeStubSerializer() {
        }

        @NotNull
        public String getExternalId() {
            if ("xml.XIncludeStub" == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(0);
            }
            return "xml.XIncludeStub";
        }

        public void serialize(@NotNull XIncludeStub stub, @NotNull StubOutputStream dataStream) throws IOException {
            if (stub == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(1);
            }
            if (dataStream == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(2);
            }
            dataStream.writeUTFFast(StringUtil.notNullize((String)stub.myHref));
            dataStream.writeUTFFast(StringUtil.notNullize((String)stub.myXpointer));
        }

        @NotNull
        public XIncludeStub deserialize(@NotNull StubInputStream dataStream, ElementStub parentStub) throws IOException {
            if (dataStream == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(3);
            }
            XIncludeStub xIncludeStub = new XIncludeStub(parentStub, dataStream.readUTFFast(), dataStream.readUTFFast());
            if (xIncludeStub == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(4);
            }
            return xIncludeStub;
        }

        public void indexStub(@NotNull XIncludeStub stub, @NotNull IndexSink sink) {
            if (stub == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(5);
            }
            if (sink == null) {
                XIncludeStubSerializer.$$$reportNull$$$0(6);
            }
        }

        public String toString() {
            return "XInclide";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/stubs/XIncludeStub$XIncludeStubSerializer";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stub";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataStream";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExternalId";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/stubs/XIncludeStub$XIncludeStubSerializer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deserialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deserialize";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "indexStub";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

