/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.collapsing.EdgeStorage;
import com.intellij.vcs.log.graph.collapsing.EdgeStorageWrapper;
import com.intellij.vcs.log.graph.collapsing.GraphNodesVisibility;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.ListIntToIntMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapsedGraph {
    @NotNull
    private final LinearGraph myDelegatedGraph;
    @NotNull
    private final UnsignedBitSet myMatchedNodeId;
    @NotNull
    private final GraphNodesVisibility myDelegateNodesVisibility;
    @NotNull
    private final UpdatableIntToIntMap myNodesMap;
    @NotNull
    private final EdgeStorage myEdgeStorage;
    @NotNull
    private final CompiledGraph myCompiledGraph;
    @NotNull
    private final AtomicReference<Modification> myCurrentModification;

    public static CollapsedGraph newInstance(@NotNull LinearGraph delegateGraph, @NotNull UnsignedBitSet matchedNodeId) {
        if (delegateGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(0);
        }
        if (matchedNodeId == null) {
            CollapsedGraph.$$$reportNull$$$0(1);
        }
        return new CollapsedGraph(delegateGraph, matchedNodeId, matchedNodeId.clone(), new EdgeStorage());
    }

    public static CollapsedGraph updateInstance(@NotNull CollapsedGraph prevCollapsedGraph, @NotNull LinearGraph newDelegateGraph) {
        if (prevCollapsedGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(2);
        }
        if (newDelegateGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(3);
        }
        UnsignedBitSet visibleNodesId = prevCollapsedGraph.myDelegateNodesVisibility.getNodeVisibilityById();
        return new CollapsedGraph(newDelegateGraph, prevCollapsedGraph.myMatchedNodeId, visibleNodesId, prevCollapsedGraph.myEdgeStorage);
    }

    private CollapsedGraph(@NotNull LinearGraph delegatedGraph, @NotNull UnsignedBitSet matchedNodeId, @NotNull UnsignedBitSet visibleNodesId, @NotNull EdgeStorage edgeStorage) {
        if (delegatedGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(4);
        }
        if (matchedNodeId == null) {
            CollapsedGraph.$$$reportNull$$$0(5);
        }
        if (visibleNodesId == null) {
            CollapsedGraph.$$$reportNull$$$0(6);
        }
        if (edgeStorage == null) {
            CollapsedGraph.$$$reportNull$$$0(7);
        }
        this.myCurrentModification = new AtomicReference<Object>(null);
        this.myDelegatedGraph = delegatedGraph;
        this.myMatchedNodeId = matchedNodeId;
        this.myDelegateNodesVisibility = new GraphNodesVisibility(delegatedGraph, visibleNodesId);
        this.myNodesMap = ListIntToIntMap.newInstance(this.myDelegateNodesVisibility.asFlags());
        this.myEdgeStorage = edgeStorage;
        this.myCompiledGraph = new CompiledGraph();
    }

    @NotNull
    public LinearGraph getDelegatedGraph() {
        LinearGraph linearGraph = this.myDelegatedGraph;
        if (linearGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(8);
        }
        return linearGraph;
    }

    public boolean isNodeVisible(int delegateNodeIndex) {
        return this.myDelegateNodesVisibility.isVisible(delegateNodeIndex);
    }

    @NotNull
    public Modification startModification() {
        Modification modification = new Modification();
        if (this.myCurrentModification.compareAndSet(null, modification)) {
            Modification modification2 = modification;
            if (modification2 == null) {
                CollapsedGraph.$$$reportNull$$$0(9);
            }
            return modification2;
        }
        throw new RuntimeException("Can not start a new modification while the other one is still running.");
    }

    @NotNull
    public LinearGraph getCompiledGraph() {
        this.assertNotUnderModification();
        CompiledGraph compiledGraph = this.myCompiledGraph;
        if (compiledGraph == null) {
            CollapsedGraph.$$$reportNull$$$0(10);
        }
        return compiledGraph;
    }

    public int convertToDelegateNodeIndex(int compiledNodeIndex) {
        this.assertNotUnderModification();
        return this.myNodesMap.getLongIndex(compiledNodeIndex);
    }

    @NotNull
    public UnsignedBitSet getMatchedNodeId() {
        UnsignedBitSet unsignedBitSet = this.myMatchedNodeId;
        if (unsignedBitSet == null) {
            CollapsedGraph.$$$reportNull$$$0(11);
        }
        return unsignedBitSet;
    }

    public boolean isMyCollapsedEdge(int upNodeIndex, int downNodeIndex) {
        return new EdgeStorageWrapper(this.myEdgeStorage, this.myDelegatedGraph).hasEdge(upNodeIndex, downNodeIndex);
    }

    private void assertNotUnderModification() {
        Modification modification = this.myCurrentModification.get();
        if (modification != null && modification.myProgress == 1) {
            throw new IllegalStateException("CompiledGraph is under modification");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateGraph";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNodeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevCollapsedGraph";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDelegateGraph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegatedGraph";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleNodesId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeStorage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegatedGraph";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startModification";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiledGraph";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompiledGraph
    implements LinearGraph {
        @NotNull
        private final EdgeStorageWrapper myEdgeStorageWrapper;

        private CompiledGraph() {
            this.myEdgeStorageWrapper = new EdgeStorageWrapper(CollapsedGraph.this.myEdgeStorage, this);
        }

        @Override
        public int nodesCount() {
            CollapsedGraph.this.assertNotUnderModification();
            return CollapsedGraph.this.myNodesMap.shortSize();
        }

        @NotNull
        private GraphEdge createEdge(@NotNull GraphEdge delegateEdge, @Nullable Integer upNodeIndex, @Nullable Integer downNodeIndex) {
            if (delegateEdge == null) {
                CompiledGraph.$$$reportNull$$$0(0);
            }
            GraphEdge graphEdge = new GraphEdge(upNodeIndex, downNodeIndex, delegateEdge.getTargetId(), delegateEdge.getType());
            if (graphEdge == null) {
                CompiledGraph.$$$reportNull$$$0(1);
            }
            return graphEdge;
        }

        @Nullable
        private Integer compiledNodeIndex(@Nullable Integer delegateNodeIndex) {
            if (delegateNodeIndex == null) {
                return null;
            }
            if (CollapsedGraph.this.myDelegateNodesVisibility.isVisible(delegateNodeIndex)) {
                return CollapsedGraph.this.myNodesMap.getShortIndex(delegateNodeIndex);
            }
            return -1;
        }

        private boolean isVisibleEdge(@Nullable Integer compiledUpNode, @Nullable Integer compiledDownNode) {
            if (compiledUpNode != null && compiledUpNode == -1) {
                return false;
            }
            return compiledDownNode == null || compiledDownNode != -1;
        }

        @Override
        @NotNull
        public List<GraphEdge> getAdjacentEdges(int nodeIndex, @NotNull EdgeFilter filter) {
            if (filter == null) {
                CompiledGraph.$$$reportNull$$$0(2);
            }
            CollapsedGraph.this.assertNotUnderModification();
            List result2 = ContainerUtil.newSmartList();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            for (GraphEdge delegateEdge : CollapsedGraph.this.myDelegatedGraph.getAdjacentEdges(delegateIndex, filter)) {
                Integer compiledDownIndex;
                Integer compiledUpIndex = this.compiledNodeIndex(delegateEdge.getUpNodeIndex());
                if (!this.isVisibleEdge(compiledUpIndex, compiledDownIndex = this.compiledNodeIndex(delegateEdge.getDownNodeIndex()))) continue;
                result2.add(this.createEdge(delegateEdge, compiledUpIndex, compiledDownIndex));
            }
            result2.addAll(this.myEdgeStorageWrapper.getAdjacentEdges(nodeIndex, filter));
            List list = result2;
            if (list == null) {
                CompiledGraph.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public GraphNode getGraphNode(int nodeIndex) {
            CollapsedGraph.this.assertNotUnderModification();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            GraphNode graphNode = CollapsedGraph.this.myDelegatedGraph.getGraphNode(delegateIndex);
            GraphNode graphNode2 = new GraphNode(nodeIndex, graphNode.getType());
            if (graphNode2 == null) {
                CompiledGraph.$$$reportNull$$$0(4);
            }
            return graphNode2;
        }

        @Override
        public int getNodeId(int nodeIndex) {
            CollapsedGraph.this.assertNotUnderModification();
            int delegateIndex = CollapsedGraph.this.myNodesMap.getLongIndex(nodeIndex);
            return CollapsedGraph.this.myDelegatedGraph.getNodeId(delegateIndex);
        }

        @Override
        @Nullable
        public Integer getNodeIndex(int nodeId) {
            CollapsedGraph.this.assertNotUnderModification();
            Integer delegateIndex = CollapsedGraph.this.myDelegatedGraph.getNodeIndex(nodeId);
            if (delegateIndex == null) {
                return null;
            }
            if (CollapsedGraph.this.myDelegateNodesVisibility.isVisible(delegateIndex)) {
                return CollapsedGraph.this.myNodesMap.getShortIndex(delegateIndex);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateEdge";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph$CompiledGraph";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph$CompiledGraph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEdge";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdjacentEdges";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGraphNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdjacentEdges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class Modification {
        private static final int COLLECTING = 0;
        private static final int APPLYING = 1;
        private static final int DONE = 2;
        @NotNull
        private final EdgeStorageWrapper myEdgesToAdd = EdgeStorageWrapper.createSimpleEdgeStorage();
        @NotNull
        private final EdgeStorageWrapper myEdgesToRemove = EdgeStorageWrapper.createSimpleEdgeStorage();
        @NotNull
        private final TIntHashSet myNodesToHide = new TIntHashSet();
        @NotNull
        private final TIntHashSet myNodesToShow = new TIntHashSet();
        private boolean myClearEdges = false;
        private boolean myClearVisibility = false;
        private volatile int myProgress = 0;
        private int minAffectedNodeIndex = Integer.MAX_VALUE;
        private int maxAffectedNodeIndex = Integer.MIN_VALUE;

        private void touchIndex(int nodeIndex) {
            assert (this.myProgress == 0);
            this.minAffectedNodeIndex = Math.min(this.minAffectedNodeIndex, nodeIndex);
            this.maxAffectedNodeIndex = Math.max(this.maxAffectedNodeIndex, nodeIndex);
        }

        private void touchAll() {
            assert (this.myProgress == 0);
            this.minAffectedNodeIndex = 0;
            this.maxAffectedNodeIndex = CollapsedGraph.this.getDelegatedGraph().nodesCount() - 1;
        }

        private void touchEdge(@NotNull GraphEdge edge) {
            if (edge == null) {
                Modification.$$$reportNull$$$0(0);
            }
            assert (this.myProgress == 0);
            if (edge.getUpNodeIndex() != null) {
                this.touchIndex(edge.getUpNodeIndex());
            }
            if (edge.getDownNodeIndex() != null) {
                this.touchIndex(edge.getDownNodeIndex());
            }
        }

        public void showNode(int nodeIndex) {
            assert (this.myProgress == 0);
            this.myNodesToShow.add(nodeIndex);
            this.touchIndex(nodeIndex);
        }

        public void hideNode(int nodeIndex) {
            assert (this.myProgress == 0);
            this.myNodesToHide.add(nodeIndex);
            this.touchIndex(nodeIndex);
        }

        public void createEdge(@NotNull GraphEdge edge) {
            if (edge == null) {
                Modification.$$$reportNull$$$0(1);
            }
            assert (this.myProgress == 0);
            this.myEdgesToAdd.createEdge(edge);
            this.touchEdge(edge);
        }

        public void removeEdge(@NotNull GraphEdge edge) {
            if (edge == null) {
                Modification.$$$reportNull$$$0(2);
            }
            assert (this.myProgress == 0);
            this.myEdgesToRemove.createEdge(edge);
            this.touchEdge(edge);
        }

        public void removeAdditionalEdges() {
            assert (this.myProgress == 0);
            this.myClearEdges = true;
            this.touchAll();
        }

        public void resetNodesVisibility() {
            assert (this.myProgress == 0);
            this.myClearVisibility = true;
            this.touchAll();
        }

        @NotNull
        EdgeStorageWrapper getEdgesToAdd() {
            assert (this.myProgress == 0);
            EdgeStorageWrapper edgeStorageWrapper = this.myEdgesToAdd;
            if (edgeStorageWrapper == null) {
                Modification.$$$reportNull$$$0(3);
            }
            return edgeStorageWrapper;
        }

        boolean isNodeHidden(int nodeIndex) {
            assert (this.myProgress == 0);
            return this.myNodesToHide.contains(nodeIndex);
        }

        boolean isNodeShown(int nodeIndex) {
            assert (this.myProgress == 0);
            return this.myNodesToShow.contains(nodeIndex);
        }

        public int convertToDelegateNodeIndex(int nodeIndex) {
            return CollapsedGraph.this.convertToDelegateNodeIndex(nodeIndex);
        }

        public void apply() {
            assert (CollapsedGraph.this.myCurrentModification.get() == this);
            this.myProgress = 1;
            if (this.myClearVisibility) {
                CollapsedGraph.this.myDelegateNodesVisibility.setNodeVisibilityById(CollapsedGraph.this.myMatchedNodeId.clone());
            }
            if (this.myClearEdges) {
                CollapsedGraph.this.myEdgeStorage.removeAll();
            }
            TIntIterator toShow = this.myNodesToShow.iterator();
            while (toShow.hasNext()) {
                CollapsedGraph.this.myDelegateNodesVisibility.show(toShow.next());
            }
            TIntIterator toHide = this.myNodesToHide.iterator();
            while (toHide.hasNext()) {
                CollapsedGraph.this.myDelegateNodesVisibility.hide(toHide.next());
            }
            EdgeStorageWrapper edgeStorageWrapper = new EdgeStorageWrapper(CollapsedGraph.this.myEdgeStorage, CollapsedGraph.this.getDelegatedGraph());
            for (GraphEdge edge : this.myEdgesToAdd.getEdges()) {
                edgeStorageWrapper.createEdge(edge);
            }
            for (GraphEdge edge : this.myEdgesToRemove.getEdges()) {
                edgeStorageWrapper.removeEdge(edge);
            }
            if (this.minAffectedNodeIndex != Integer.MAX_VALUE && this.maxAffectedNodeIndex != Integer.MIN_VALUE) {
                CollapsedGraph.this.myNodesMap.update(this.minAffectedNodeIndex, this.maxAffectedNodeIndex);
            }
            this.myProgress = 2;
            CollapsedGraph.this.myCurrentModification.set(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph$Modification";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedGraph$Modification";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgesToAdd";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "touchEdge";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEdge";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

