/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsToRoots {
    private final NewMappings myMappings;
    private final Project myProject;

    public MappingsToRoots(@NotNull NewMappings mappings, @NotNull Project project) {
        if (mappings == null) {
            MappingsToRoots.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MappingsToRoots.$$$reportNull$$$0(1);
        }
        this.myMappings = mappings;
        this.myProject = project;
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        ArrayList<VirtualFile> result2;
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> mappings = new ArrayList<VirtualFile>(this.myMappings.getMappingsAsFilesUnderVcs(vcs));
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        List<Object> list = result2 = convertor != null ? convertor.convertRoots(mappings) : mappings;
        if (!vcs.allowsNestedRoots()) {
            Collections.sort(result2, FilePathComparator.getInstance());
            ApplicationManager.getApplication().runReadAction(() -> {
                FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)this.myProject, FileIndexFacade.class);
                int i = 1;
                while (i < result2.size()) {
                    VirtualFile current;
                    VirtualFile previous = (VirtualFile)result2.get(i - 1);
                    if (facade.isValidAncestor(previous, current = (VirtualFile)result2.get(i))) {
                        result2.remove(i);
                        continue;
                    }
                    ++i;
                }
            });
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            MappingsToRoots.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getDetailedVcsMappings(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            MappingsToRoots.$$$reportNull$$$0(4);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(this.myMappings.getMappingsAsFilesUnderVcs(vcs));
        Collection<VirtualFile> modules = DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots();
        List modulesUnderVcs = ContainerUtil.filter(modules, file -> {
            if (!file.isDirectory()) {
                return false;
            }
            NewMappings.MappedRoot root = this.myMappings.getMappedRootFor((VirtualFile)file);
            return root != null && vcs.equals((Object)root.vcs);
        });
        List modulesToAdd = (List)ApplicationManager.getApplication().runReadAction(() -> {
            FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)this.myProject, FileIndexFacade.class);
            return ContainerUtil.filter((Collection)modulesUnderVcs, module -> ContainerUtil.or((Iterable)roots, root -> facade.isValidAncestor(root, module)));
        });
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(ContainerUtil.union(roots, (Collection)modulesToAdd));
        if (arrayList == null) {
            MappingsToRoots.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/MappingsToRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsUnderVcs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailedVcsMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedVcsMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

