"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Permalinks {
    constructor() {
    }
    // TODO: Encode permalinks
    static encodeViaArgs(servers) {
        if (!servers || !servers.length)
            return "";
        return `?via=${servers.join("via=")}`;
    }
    static forRoom(roomIdOrAlias, viaServers = []) {
        return `https://matrix.to/#/${roomIdOrAlias}${Permalinks.encodeViaArgs(viaServers)}`;
    }
    static forUser(userId) {
        return `https://matrix.to/#/${userId}`;
    }
    static forEvent(roomIdOrAlias, eventId, viaServers = []) {
        return `https://matrix.to/#/${roomIdOrAlias}/${eventId}${Permalinks.encodeViaArgs(viaServers)}`;
    }
}
exports.Permalinks = Permalinks;
