/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ArrayConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "arrayInlineToSizeConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "asSingleArgumentLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "ir.backend.common"})
public final class ArrayConstructorLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    private final IrFunctionSymbol arrayInlineToSizeConstructor(IrConstructor irConstructor) {
        IrSymbol irSymbol;
        IrClassSymbol clazz = (IrClassSymbol)AdditionalIrUtilsKt.getConstructedClass(irConstructor).getSymbol();
        if (irConstructor.getValueParameters().size() != 2) {
            irSymbol = null;
        } else if (Intrinsics.areEqual(clazz, this.context.getIrBuiltIns().getArrayClass())) {
            irSymbol = this.context.getIr().getSymbols().getArrayOfNulls();
        } else if (this.context.getIrBuiltIns().getPrimitiveArrays().contains(clazz)) {
            Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(clazz);
            boolean $i$f$single = false;
            IrConstructorSymbol single$iv = null;
            boolean found$iv = false;
            Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
            while (iterator2.hasNext()) {
                IrConstructorSymbol element$iv;
                IrConstructorSymbol it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            irSymbol = single$iv;
        } else {
            irSymbol = null;
        }
        return (IrFunctionSymbol)irSymbol;
    }

    private final IrSimpleFunction asSingleArgumentLambda(@NotNull IrExpression $this$asSingleArgumentLambda) {
        IrSimpleFunction irSimpleFunction = IrInlineUtilsKt.asSimpleLambda($this$asSingleArgumentLambda);
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction function2 = irSimpleFunction;
        if (function2.getValueParameters().size() != 1) {
            return null;
        }
        return function2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrFunctionAccessExpression $this$single$iv;
        IrExpression irExpression;
        void $this$irBlock$iv;
        Object v;
        Object it;
        void startOffset$iv;
        void $this$irBlock$iv2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrFunctionSymbol irFunctionSymbol = this.arrayInlineToSizeConstructor((IrConstructor)expression2.getSymbol().getOwner());
        if (irFunctionSymbol == null) {
            return super.visitConstructorCall(expression2);
        }
        IrFunctionSymbol sizeConstructor = irFunctionSymbol;
        IrExpression irExpression2 = expression2.getValueArgument(0);
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        IrExpression size = irExpression2.transform(this, null);
        IrExpression irExpression3 = expression2.getValueArgument(1);
        if (irExpression3 == null) {
            Intrinsics.throwNpe();
        }
        IrExpression invokable = irExpression3.transform(this, null);
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        Scope scope = scopeWithIr.getScope();
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, scope.getScopeOwnerSymbol(), 0, 0, 6, null);
        int n = expression2.getStartOffset();
        int endOffset$iv = expression2.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv2.getContext(), $this$irBlock$iv2.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv;
        boolean bl = false;
        IrVariable index2 = ExpressionHelpersKt.irTemporaryVar$default($this$irBlock, ExpressionHelpersKt.irInt($this$irBlock, 0), null, null, 6, null);
        IrVariable sizeVar = ExpressionHelpersKt.irTemporary$default($this$irBlock, size, null, null, null, 14, null);
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, sizeConstructor, expression2.getType());
        IrStatementsBuilder irStatementsBuilder = $this$irBlock;
        boolean bl2 = false;
        boolean bl3 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl4 = false;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom($this$apply, expression2);
        $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$irBlock, sizeVar));
        IrExpression irExpression4 = irFunctionAccessExpression;
        IrVariable result2 = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, irExpression4, null, null, null, 14, null);
        IrSimpleFunction lambda2 = this.asSingleArgumentLambda(invokable);
        IrClass irClass = IrTypesKt.getClass(invokable.getType());
        if (irClass == null) {
            Intrinsics.throwNpe();
        }
        Sequence<IrSimpleFunction> $this$single$iv2 = IrUtilsKt.getFunctions(irClass);
        boolean $i$f$single = false;
        IrSimpleFunction single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunction> iterator2 = $this$single$iv2.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction element$iv = iterator2.next();
            it = element$iv;
            boolean $i$a$-single-ArrayConstructorLowering$visitConstructorCall$1$invoke$22 = false;
            if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invoke2 = single$iv;
        IrVariable invokableVar = lambda2 == null ? ExpressionHelpersKt.irTemporary$default($this$irBlock, invokable, null, null, null, 14, null) : null;
        IrWhileLoopImpl irWhileLoopImpl = IrBuildersKt.irWhile$default($this$irBlock, null, 1, null);
        irStatementsBuilder = $this$irBlock;
        boolean bl5 = false;
        boolean bl6 = false;
        IrWhileLoopImpl $this$apply2 = irWhileLoopImpl;
        boolean bl7 = false;
        it = $this$irBlock.getContext().getIrBuiltIns().getLessFunByOperandType();
        KotlinType $i$a$-single-ArrayConstructorLowering$visitConstructorCall$1$invoke$22 = IrTypesKt.toKotlinType(index2.getType());
        Object object2 = $this$irBlock;
        IrWhileLoopImpl irWhileLoopImpl2 = $this$apply2;
        boolean bl8 = false;
        Object v2 = v = it.get($i$a$-single-ArrayConstructorLowering$visitConstructorCall$1$invoke$22);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        it = ExpressionHelpersKt.irCall((IrBuilderWithScope)object2, (IrSimpleFunctionSymbol)v2);
        boolean $i$a$-single-ArrayConstructorLowering$visitConstructorCall$1$invoke$22 = false;
        bl8 = false;
        Object $this$apply3 = it;
        boolean bl9 = false;
        $this$apply3.putValueArgument(0, ExpressionHelpersKt.irGet($this$irBlock, index2));
        $this$apply3.putValueArgument(1, ExpressionHelpersKt.irGet($this$irBlock, sizeVar));
        object2 = it;
        irWhileLoopImpl2.setCondition((IrExpression)object2);
        it = $this$irBlock;
        irWhileLoopImpl2 = $this$apply2;
        int startOffset$iv2 = $this$irBlock$iv.getStartOffset();
        int endOffset$iv2 = $this$irBlock$iv.getEndOffset();
        IrStatementOrigin origin$iv2 = null;
        IrType resultType$iv2 = null;
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder this_$iv$iv2 = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv2, endOffset$iv2, origin$iv2, resultType$iv2, false, 64, null);
        boolean $i$f$block2 = false;
        IrBlockBuilder $this$irBlock2 = this_$iv$iv2;
        boolean bl10 = false;
        IrVariable tempIndex = ExpressionHelpersKt.irTemporary$default($this$irBlock2, ExpressionHelpersKt.irGet($this$irBlock2, index2), null, null, null, 14, null);
        IrStatement irStatement = lambda2;
        if (irStatement != null && (irStatement = IrInlineUtilsKt.inline(irStatement, CollectionsKt.listOf(tempIndex))) != null) {
            irExpression = (IrExpression)irStatement;
        } else {
            IrBuilderWithScope irBuilderWithScope = $this$irBlock2;
            IrFunctionSymbol irFunctionSymbol2 = invoke2.getSymbol();
            IrType irType = invoke2.getReturnType();
            IrBuilderWithScope irBuilderWithScope2 = $this$irBlock2;
            IrVariable irVariable2 = invokableVar;
            if (irVariable2 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = ExpressionHelpersKt.irCallOp(irBuilderWithScope, irFunctionSymbol2, irType, ExpressionHelpersKt.irGet(irBuilderWithScope2, irVariable2), ExpressionHelpersKt.irGet($this$irBlock2, tempIndex));
        }
        IrExpression value2 = irExpression;
        IrBuilderWithScope irBuilderWithScope = $this$irBlock2;
        IrClass irClass2 = IrTypesKt.getClass(result2.getType());
        if (irClass2 == null) {
            Intrinsics.throwNpe();
        }
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(irClass2);
        Object object3 = irBuilderWithScope;
        IrBlockBuilder irBlockBuilder = $this$irBlock2;
        boolean $i$f$single2 = false;
        Object single$iv22 = null;
        boolean found$iv2 = false;
        Iterator iterator3 = $this$single$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            IrSimpleFunction it2 = (IrSimpleFunction)element$iv;
            boolean bl11 = false;
            if (!Intrinsics.areEqual(it2.getName(), OperatorNameConventions.SET)) continue;
            if (found$iv2) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv22 = element$iv;
            found$iv2 = true;
        }
        if (!found$iv2) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var54_70 = single$iv22;
        $this$single$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)object3, var54_70);
        $i$f$single2 = false;
        boolean single$iv22 = false;
        IrFunctionAccessExpression $this$apply4 = $this$single$iv;
        boolean bl12 = false;
        $this$apply4.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irBlock2, result2));
        $this$apply4.putValueArgument(0, ExpressionHelpersKt.irGet($this$irBlock2, tempIndex));
        $this$apply4.putValueArgument(1, value2);
        object3 = $this$single$iv;
        irBlockBuilder.unaryPlus((IrStatement)object3);
        IrClass irClass3 = IrTypesKt.getClass(index2.getType());
        if (irClass3 == null) {
            Intrinsics.throwNpe();
        }
        Sequence<IrSimpleFunction> $this$single$iv3 = IrUtilsKt.getFunctions(irClass3);
        boolean $i$f$single3 = false;
        IrSimpleFunction single$iv3 = null;
        boolean found$iv3 = false;
        Iterator<IrSimpleFunction> iterator4 = $this$single$iv3.iterator();
        while (iterator4.hasNext()) {
            IrSimpleFunction element$iv;
            IrSimpleFunction it3 = element$iv = iterator4.next();
            boolean bl13 = false;
            if (!Intrinsics.areEqual(it3.getName(), OperatorNameConventions.INC)) continue;
            if (found$iv3) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv3 = element$iv;
            found$iv3 = true;
        }
        if (!found$iv3) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction inc = single$iv3;
        $this$irBlock2.unaryPlus(ExpressionHelpersKt.irSetVar($this$irBlock2, (IrVariableSymbol)index2.getSymbol(), ExpressionHelpersKt.irCallOp$default($this$irBlock2, inc.getSymbol(), index2.getType(), ExpressionHelpersKt.irGet($this$irBlock2, index2), null, 8, null)));
        object2 = this_$iv$iv2.doBuild();
        irWhileLoopImpl2.setBody((IrExpression)object2);
        irExpression4 = irWhileLoopImpl;
        irStatementsBuilder.unaryPlus(irExpression4);
        $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, result2));
        object = this_$iv$iv.doBuild();
        n = 0;
        boolean bl14 = false;
        Object it4 = object;
        boolean bl15 = false;
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)it4, scope.getLocalDeclarationParent());
        return object;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public ArrayConstructorLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }
}

