"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseField = exports.UseField = void 0;

var _react = _interopRequireWildcard(require("react"));

var _hooks = require("../hooks");

var _form_context = require("../form_context");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const UseField = ({
  path,
  config,
  defaultValue,
  component = 'input',
  componentProps = {},
  children
}) => {
  const form = (0, _form_context.useFormContext)();

  if (typeof defaultValue === 'undefined') {
    defaultValue = form.getFieldDefaultValue(path);
  }

  if (!config) {
    config = form.__readFieldConfigFromSchema(path);
  } // Don't modify the config object


  const configCopy = typeof defaultValue !== 'undefined' ? { ...config,
    defaultValue
  } : { ...config
  };

  if (!configCopy.path) {
    configCopy.path = path;
  } else {
    if (configCopy.path !== path) {
      throw new Error(`Field path mismatch. Got "${path}" but field config has "${configCopy.path}".`);
    }
  }

  const field = (0, _hooks.useField)(form, path, configCopy); // Remove field from form when it is unmounted or if its path changes

  (0, _react.useEffect)(() => {
    return () => {
      form.__removeField(path);
    };
  }, [path]); // Children prevails over anything else provided.

  if (children) {
    return children(field);
  }

  if (component === 'input') {
    return _react.default.createElement("input", _extends({
      type: field.type,
      onChange: field.onChange,
      value: field.value
    }, componentProps));
  }

  return component({
    field,
    ...componentProps
  });
};
/**
 * Get a <UseField /> component providing some common props for all instances.
 * @param partialProps Partial props to apply to all <UseField /> instances
 */


exports.UseField = UseField;

const getUseField = partialProps => props => {
  const componentProps = { ...partialProps,
    ...props
  };
  return _react.default.createElement(UseField, componentProps);
};

exports.getUseField = getUseField;