"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumericField = void 0;

var _react = _interopRequireDefault(require("react"));

var _eui = require("@elastic/eui");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const NumericField = ({
  field,
  euiFieldProps = {},
  ...rest
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _helpers.getFieldValidityAndErrorMessage)(field);
  return _react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": rest['data-test-subj'],
    describedByIds: rest.idAria ? [rest.idAria] : undefined
  }, _react.default.createElement(_eui.EuiFieldNumber, _extends({
    isInvalid: isInvalid,
    value: field.value,
    onChange: field.onChange,
    isLoading: field.isValidating,
    fullWidth: true,
    "data-test-subj": "input"
  }, euiFieldProps)));
};

exports.NumericField = NumericField;