"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = exports.getResponseAggConfigClass = void 0;

var _lodash = require("lodash");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Get the ResponseAggConfig class for an aggConfig,
 * which might be cached on the aggConfig or created.
 *
 * @param  {AggConfig} agg - the AggConfig the VAC should inherit from
 * @param  {object} props - properties that the VAC should have
 * @return {Constructor} - a constructor for VAC objects that will inherit the aggConfig
 */
var getResponseAggConfigClass = function getResponseAggConfigClass(agg, props) {
  if (agg.$$_ResponseAggConfigClass) {
    return agg.$$_ResponseAggConfigClass;
  } else {
    return agg.$$_ResponseAggConfigClass = create(agg, props);
  }
};

exports.getResponseAggConfigClass = getResponseAggConfigClass;

var create = function create(parentAgg, props) {
  /**
   * AggConfig "wrapper" for multi-value metric aggs which
   * need to modify AggConfig behavior for each value produced.
   *
   * @param {string|number} key - the key or index that identifies
   *                            this part of the multi-value
   */
  var ResponseAggConfig = function ResponseAggConfig(key) {
    _classCallCheck(this, ResponseAggConfig);

    _defineProperty(this, "id", void 0);

    _defineProperty(this, "key", void 0);

    _defineProperty(this, "parentId", void 0);

    this.key = key;
    this.parentId = parentAgg.id;
    var subId = String(key);

    if (subId.indexOf('.') > -1) {
      this.id = this.parentId + "['" + subId.replace(/'/g, "\\'") + "']";
    } else {
      this.id = this.parentId + '.' + subId;
    }
  };

  ResponseAggConfig.prototype = Object.create(parentAgg);
  ResponseAggConfig.prototype.constructor = ResponseAggConfig;
  (0, _lodash.assign)(ResponseAggConfig.prototype, props);
  return ResponseAggConfig;
};

exports.create = create;