"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionRequestHandler = getTimelionRequestHandler;

var _esQuery = require("@kbn/es-query");

var _timezone = require("ui/vis/lib/timezone");

var _i18n = require("@kbn/i18n");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getTimelionRequestHandler(dependencies) {
  var uiSettings = dependencies.uiSettings,
      http = dependencies.http;
  var timezone = (0, _timezone.timezoneProvider)(uiSettings)();
  return (
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(_ref) {
        var timeRange, filters, query, visParams, expression, esQueryConfigs, err;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                timeRange = _ref.timeRange, filters = _ref.filters, query = _ref.query, visParams = _ref.visParams;
                expression = visParams.expression;

                if (expression) {
                  _context.next = 4;
                  break;
                }

                throw new Error(_i18n.i18n.translate('timelion.emptyExpressionErrorMessage', {
                  defaultMessage: 'Timelion error: No expression provided'
                }));

              case 4:
                esQueryConfigs = (0, _esQuery.getEsQueryConfig)(uiSettings);
                _context.prev = 5;
                _context.next = 8;
                return http.post('../api/timelion/run', {
                  body: JSON.stringify({
                    sheet: [expression],
                    extended: {
                      es: {
                        filter: (0, _esQuery.buildEsQuery)(undefined, query, filters, esQueryConfigs)
                      }
                    },
                    time: _objectSpread({}, timeRange, {
                      interval: visParams.interval,
                      timezone: timezone
                    })
                  })
                });

              case 8:
                return _context.abrupt("return", _context.sent);

              case 11:
                _context.prev = 11;
                _context.t0 = _context["catch"](5);

                if (!(_context.t0 && _context.t0.body)) {
                  _context.next = 19;
                  break;
                }

                err = new Error("".concat(_i18n.i18n.translate('timelion.requestHandlerErrorTitle', {
                  defaultMessage: 'Timelion request error'
                }), ": ").concat(_context.t0.body.title, " ").concat(_context.t0.body.message));
                err.stack = _context.t0.stack;
                throw err;

              case 19:
                throw _context.t0;

              case 20:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[5, 11]]);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }()
  );
}