"use strict";

var _routes = _interopRequireDefault(require("ui/routes"));

var _timefilter = require("ui/timefilter");

var _breadcrumbs = require("plugins/kibana/discover/breadcrumbs");

var _index = _interopRequireDefault(require("./index.html"));

require("./doc_directive");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

_routes.default // the old, pre 8.0 route, no longer used, keep it to stay compatible
// somebody might have bookmarked his favorite log messages
.when('/doc/:indexPattern/:index/:type', {
  redirectTo: '/doc/:indexPattern/:index'
}) // the new route, es 7 deprecated types, es 8 removed them
.when('/doc/:indexPattern/:index', {
  controller: function controller($scope, $route, es, indexPatterns) {
    _timefilter.timefilter.disableAutoRefreshSelector();

    _timefilter.timefilter.disableTimeRangeSelector();

    $scope.esClient = es;
    $scope.id = $route.current.params.id;
    $scope.index = $route.current.params.index;
    $scope.indexPatternId = $route.current.params.indexPattern;
    $scope.indexPatternService = indexPatterns;
  },
  template: _index.default,
  k7Breadcrumbs: function k7Breadcrumbs($route) {
    return [].concat(_toConsumableArray((0, _breadcrumbs.getRootBreadcrumbs)()), [{
      text: "".concat($route.current.params.index, "#").concat($route.current.params.id)
    }]);
  }
});