"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverIndexPattern = DiscoverIndexPattern;

var _react = _interopRequireWildcard(require("react"));

var _eui = require("@elastic/eui");

var _discover_index_pattern_title = require("./discover_index_pattern_title");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Component allows you to select an index pattern in discovers side bar
 */
function DiscoverIndexPattern(_ref) {
  var indexPatternList = _ref.indexPatternList,
      selectedIndexPattern = _ref.selectedIndexPattern,
      setIndexPattern = _ref.setIndexPattern;

  if (!indexPatternList || indexPatternList.length === 0 || !selectedIndexPattern) {
    // just in case, shouldn't happen
    return null;
  }

  var _useState = (0, _react.useState)(selectedIndexPattern),
      _useState2 = _slicedToArray(_useState, 2),
      selected = _useState2[0],
      setSelected = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      showCombo = _useState4[0],
      setShowCombo = _useState4[1];

  var options = indexPatternList.map(function (entity) {
    return {
      value: entity.id,
      label: entity.attributes.title
    };
  });
  var selectedOptions = selected ? [{
    value: selected.id,
    label: selected.attributes.title
  }] : [];

  var findIndexPattern = function findIndexPattern(id) {
    return indexPatternList.find(function (entity) {
      return entity.id === id;
    });
  };

  if (!showCombo) {
    return _react.default.createElement(_discover_index_pattern_title.DiscoverIndexPatternTitle, {
      isChangeable: indexPatternList.length > 1,
      onChange: function onChange() {
        return setShowCombo(true);
      },
      title: selected.attributes ? selected.attributes.title : ''
    });
  }
  /**
   * catches a EuiComboBox related 'Can't perform a React state update on an unmounted component'
   * warning in console by delaying the hiding/removal of the EuiComboBox a bit
   */


  function hideCombo() {
    setTimeout(function () {
      return setShowCombo(false);
    }, 50);
  }

  return _react.default.createElement(_eui.EuiComboBox, {
    className: "index-pattern-selection",
    "data-test-subj": "index-pattern-selection",
    fullWidth: true,
    isClearable: false,
    onBlur: function onBlur() {
      return hideCombo();
    },
    onChange: function onChange(choices) {
      var newSelected = choices[0] && findIndexPattern(choices[0].value);

      if (newSelected) {
        setSelected(newSelected);
        setIndexPattern(newSelected.id);
      }

      hideCombo();
    },
    inputRef: function inputRef(el) {
      // auto focus input element when combo box is displayed
      if (el) {
        el.focus();
      }
    },
    options: options,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    }
  });
}