"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSourceFormat = createSourceFormat;

var _lodash = require("lodash");

var _no_white_space = require("../../utils/no_white_space");

var _shorten_dotted_string = require("../../utils/shorten_dotted_string");

var _common = require("../../../../../../plugins/data/common/");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const templateHtml = `
  <dl class="source truncate-by-height">
    <% defPairs.forEach(function (def) { %>
      <dt><%- def[0] %>:</dt>
      <dd><%= def[1] %></dd>
      <%= ' ' %>
    <% }); %>
  </dl>`;
const doTemplate = (0, _lodash.template)((0, _no_white_space.noWhiteSpace)(templateHtml));

function createSourceFormat() {
  class SourceFormat extends _common.FieldFormat {
    constructor(params, getConfig) {
      super(params);

      _defineProperty(this, "getConfig", void 0);

      _defineProperty(this, "textConvert", value => JSON.stringify(value));

      _defineProperty(this, "htmlConvert", (value, field, hit) => {
        if (!field) {
          const converter = this.getConverterFor('text');
          return (0, _lodash.escape)(converter(value));
        }

        const highlights = hit && hit.highlight || {};
        const formatted = field.indexPattern.formatHit(hit);
        const highlightPairs = [];
        const sourcePairs = [];
        const isShortDots = this.getConfig('shortDots:enable');
        (0, _lodash.keys)(formatted).forEach(key => {
          const pairs = highlights[key] ? highlightPairs : sourcePairs;
          const newField = isShortDots ? (0, _shorten_dotted_string.shortenDottedString)(key) : key;
          const val = formatted[key];
          pairs.push([newField, val]);
        }, []);
        return doTemplate({
          defPairs: highlightPairs.concat(sourcePairs)
        });
      });

      this.getConfig = getConfig;
    }

  }

  _defineProperty(SourceFormat, "id", '_source');

  _defineProperty(SourceFormat, "title", '_source');

  _defineProperty(SourceFormat, "fieldType", _common.KBN_FIELD_TYPES._SOURCE);

  return SourceFormat;
}