"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDateOnServerFormat = createDateOnServerFormat;

var _lodash = require("lodash");

var _momentTimezone = _interopRequireDefault(require("moment-timezone"));

var _common = require("../../../../../../plugins/data/common/");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function createDateOnServerFormat() {
  var _class, _temp;

  return _temp = _class = class DateFormat extends _common.FieldFormat {
    constructor(params, getConfig) {
      super(params);

      _defineProperty(this, "getConfig", void 0);

      _defineProperty(this, "memoizedConverter", _lodash.noop);

      _defineProperty(this, "memoizedPattern", '');

      _defineProperty(this, "timeZone", '');

      _defineProperty(this, "textConvert", val => {
        // don't give away our ref to converter so we can hot-swap when config changes
        const pattern = this.param('pattern');
        const timezone = this.param('timezone');
        const timezoneChanged = this.timeZone !== timezone;
        const datePatternChanged = this.memoizedPattern !== pattern;

        if (timezoneChanged || datePatternChanged) {
          this.timeZone = timezone;
          this.memoizedPattern = pattern;
        }

        return this.memoizedConverter(val);
      });

      this.getConfig = getConfig;
      this.memoizedConverter = (0, _lodash.memoize)(val => {
        if (val == null) {
          return '-';
        }
        /* On the server, importing moment returns a new instance. Unlike on
         * the client side, it doesn't have the dateFormat:tz configuration
         * baked in.
         * We need to set the timezone manually here. The date is taken in as
         * UTC and converted into the desired timezone. */


        let date;

        if (this.timeZone === 'Browser') {
          // Assume a warning has been logged this can be unpredictable. It
          // would be too verbose to log anything here.
          date = _momentTimezone.default.utc(val);
        } else {
          date = _momentTimezone.default.utc(val).tz(this.timeZone);
        }

        if (date.isValid()) {
          return date.format(this.memoizedPattern);
        } else {
          return val;
        }
      });
    }

    getParamDefaults() {
      return {
        pattern: this.getConfig('dateFormat'),
        timezone: this.getConfig('dateFormat:tz')
      };
    }

  }, _defineProperty(_class, "id", 'date'), _defineProperty(_class, "title", 'Date'), _defineProperty(_class, "fieldType", _common.KBN_FIELD_TYPES.DATE), _temp;
}