"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualization = void 0;

var _lodash = require("lodash");

var _i18n = require("@kbn/i18n");

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _query_filter = require("ui/filter_manager/query_filter");

var _persisted_state = require("ui/persisted_state");

var _legacy = require("../../../data/public/legacy");

var _legacy2 = require("../../../visualizations/public/np_ready/public/legacy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var visualization = function visualization() {
  return {
    name: 'visualization',
    type: 'render',
    help: _i18n.i18n.translate('interpreter.functions.visualization.help', {
      defaultMessage: 'A simple visualization'
    }),
    args: {
      // TODO: Below `help` keys should be internationalized once this function
      // TODO: is moved to visualizations plugin.
      index: {
        types: ['string', 'null'],
        default: null,
        help: 'Index'
      },
      metricsAtAllLevels: {
        types: ['boolean'],
        default: false,
        help: 'Metrics levels'
      },
      partialRows: {
        types: ['boolean'],
        default: false,
        help: 'Partial rows'
      },
      type: {
        types: ['string'],
        default: '',
        help: 'Type'
      },
      schemas: {
        types: ['string'],
        default: '"{}"',
        help: 'Schemas'
      },
      visConfig: {
        types: ['string'],
        default: '"{}"',
        help: 'Visualization configuration'
      },
      uiState: {
        types: ['string'],
        default: '"{}"',
        help: 'User interface state'
      }
    },
    fn: function () {
      var _fn = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(context, args, handlers) {
        var $injector, Private, indexPatterns, queryFilter, visConfigParams, schemas, visType, indexPattern, uiStateParams, uiState;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return _chrome.default.dangerouslyGetActiveInjector();

              case 2:
                $injector = _context.sent;
                Private = $injector.get('Private');
                indexPatterns = _legacy.start.indexPatterns.indexPatterns;
                queryFilter = Private(_query_filter.FilterBarQueryFilterProvider);
                visConfigParams = args.visConfig ? JSON.parse(args.visConfig) : {};
                schemas = args.schemas ? JSON.parse(args.schemas) : {};
                visType = _legacy2.start.types.get(args.type || 'histogram');

                if (!args.index) {
                  _context.next = 15;
                  break;
                }

                _context.next = 12;
                return indexPatterns.get(args.index);

              case 12:
                _context.t0 = _context.sent;
                _context.next = 16;
                break;

              case 15:
                _context.t0 = null;

              case 16:
                indexPattern = _context.t0;
                uiStateParams = args.uiState ? JSON.parse(args.uiState) : {};
                uiState = new _persisted_state.PersistedState(uiStateParams);

                if (!(typeof visType.requestHandler === 'function')) {
                  _context.next = 23;
                  break;
                }

                _context.next = 22;
                return visType.requestHandler({
                  partialRows: args.partialRows,
                  metricsAtAllLevels: args.metricsAtAllLevels,
                  index: indexPattern,
                  visParams: visConfigParams,
                  timeRange: (0, _lodash.get)(context, 'timeRange', null),
                  query: (0, _lodash.get)(context, 'query', null),
                  filters: (0, _lodash.get)(context, 'filters', null),
                  uiState: uiState,
                  inspectorAdapters: handlers.inspectorAdapters,
                  queryFilter: queryFilter,
                  forceFetch: true
                });

              case 22:
                context = _context.sent;

              case 23:
                if (!(typeof visType.responseHandler === 'function')) {
                  _context.next = 28;
                  break;
                }

                if (context.columns) {
                  // assign schemas to aggConfigs
                  context.columns.forEach(function (column) {
                    if (column.aggConfig) {
                      column.aggConfig.aggConfigs.schemas = visType.schemas.all;
                    }
                  });
                  Object.keys(schemas).forEach(function (key) {
                    schemas[key].forEach(function (i) {
                      if (context.columns[i] && context.columns[i].aggConfig) {
                        context.columns[i].aggConfig.schema = key;
                      }
                    });
                  });
                }

                _context.next = 27;
                return visType.responseHandler(context, visConfigParams.dimensions);

              case 27:
                context = _context.sent;

              case 28:
                return _context.abrupt("return", {
                  type: 'render',
                  as: 'visualization',
                  value: {
                    visData: context,
                    visType: args.type || '',
                    visConfig: visConfigParams
                  }
                });

              case 29:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function fn(_x, _x2, _x3) {
        return _fn.apply(this, arguments);
      }

      return fn;
    }()
  };
};

exports.visualization = visualization;