"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionsPublicPlugin = void 0;

var _new_platform = require("ui/new_platform");

var _services = require("./services");

var _expression_renderer = require("./expression_renderer");

var _loader = require("./loader");

var _execute = require("./execute");

var _render = require("./render");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ExpressionsPublicPlugin =
/*#__PURE__*/
function () {
  function ExpressionsPublicPlugin(initializerContext) {
    _classCallCheck(this, ExpressionsPublicPlugin);
  }

  _createClass(ExpressionsPublicPlugin, [{
    key: "setup",
    value: function setup(core, plugins) {
      (0, _services.setRenderersRegistry)(_new_platform.npSetup.plugins.expressions.__LEGACY.renderers); // eslint-disable-next-line

      var _require = require('../../../../interpreter/public/interpreter'),
          getInterpreter = _require.getInterpreter;

      getInterpreter().then(function (_ref) {
        var interpreter = _ref.interpreter;
        (0, _services.setInterpreter)(interpreter);
      }).catch(function (e) {
        throw new Error('interpreter is not initialized');
      });
      return {
        registerType: _new_platform.npSetup.plugins.expressions.registerType,
        registerFunction: _new_platform.npSetup.plugins.expressions.registerFunction,
        registerRenderer: _new_platform.npSetup.plugins.expressions.registerRenderer,
        __LEGACY: _new_platform.npSetup.plugins.expressions.__LEGACY
      };
    }
  }, {
    key: "start",
    value: function start(core, _ref2) {
      var inspector = _ref2.inspector;
      (0, _services.setInspector)(inspector);
      return {
        execute: _execute.execute,
        render: _render.render,
        loader: _loader.loader,
        ExpressionRenderer: _expression_renderer.ExpressionRendererImplementation,
        ExpressionDataHandler: _execute.ExpressionDataHandler,
        ExpressionRenderHandler: _render.ExpressionRenderHandler,
        ExpressionLoader: _loader.ExpressionLoader
      };
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return ExpressionsPublicPlugin;
}();

exports.ExpressionsPublicPlugin = ExpressionsPublicPlugin;