"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loader = exports.ExpressionLoader = void 0;

var _rxjs = require("rxjs");

var _operators = require("rxjs/operators");

var _execute = require("./execute");

var _render = require("./render");

var _services = require("./services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var ExpressionLoader =
/*#__PURE__*/
function () {
  function ExpressionLoader(element, _expression, _params) {
    var _this = this;

    _classCallCheck(this, ExpressionLoader);

    _defineProperty(this, "data$", void 0);

    _defineProperty(this, "update$", void 0);

    _defineProperty(this, "render$", void 0);

    _defineProperty(this, "events$", void 0);

    _defineProperty(this, "loading$", void 0);

    _defineProperty(this, "dataHandler", void 0);

    _defineProperty(this, "renderHandler", void 0);

    _defineProperty(this, "dataSubject", void 0);

    _defineProperty(this, "loadingSubject", void 0);

    _defineProperty(this, "data", void 0);

    _defineProperty(this, "params", {});

    _defineProperty(this, "loadData",
    /*#__PURE__*/
    function () {
      var _ref = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(expression, params) {
        var data;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this.loadingSubject.next();

                if (_this.dataHandler) {
                  _this.dataHandler.cancel();
                }

                _this.setParams(params);

                _this.dataHandler = new _execute.ExpressionDataHandler(expression, params);
                _context.next = 6;
                return _this.dataHandler.getData();

              case 6:
                data = _context.sent;

                _this.dataSubject.next(data);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x, _x2) {
        return _ref.apply(this, arguments);
      };
    }());

    this.dataSubject = new _rxjs.Subject();
    this.data$ = this.dataSubject.asObservable().pipe((0, _operators.share)());
    this.loadingSubject = new _rxjs.Subject();
    this.loading$ = this.loadingSubject.asObservable().pipe((0, _operators.share)());
    this.renderHandler = new _render.ExpressionRenderHandler(element);
    this.render$ = this.renderHandler.render$;
    this.update$ = this.renderHandler.update$;
    this.events$ = this.renderHandler.events$;
    this.update$.subscribe(function (_ref2) {
      var newExpression = _ref2.newExpression,
          newParams = _ref2.newParams;

      _this.update(newExpression, newParams);
    });
    this.data$.subscribe(function (data) {
      _this.render(data);
    });
    this.setParams(_params);
    this.loadData(_expression, this.params);
  }

  _createClass(ExpressionLoader, [{
    key: "destroy",
    value: function destroy() {
      this.dataSubject.complete();
      this.loadingSubject.complete();
      this.renderHandler.destroy();

      if (this.dataHandler) {
        this.dataHandler.cancel();
      }
    }
  }, {
    key: "cancel",
    value: function cancel() {
      if (this.dataHandler) {
        this.dataHandler.cancel();
      }
    }
  }, {
    key: "getExpression",
    value: function getExpression() {
      if (this.dataHandler) {
        return this.dataHandler.getExpression();
      }
    }
  }, {
    key: "getAst",
    value: function getAst() {
      if (this.dataHandler) {
        return this.dataHandler.getAst();
      }
    }
  }, {
    key: "getElement",
    value: function getElement() {
      return this.renderHandler.getElement();
    }
  }, {
    key: "openInspector",
    value: function openInspector(title) {
      var inspector = this.inspect();

      if (inspector) {
        return (0, _services.getInspector)().open(inspector, {
          title: title
        });
      }
    }
  }, {
    key: "inspect",
    value: function inspect() {
      if (this.dataHandler) {
        return this.dataHandler.inspect();
      }
    }
  }, {
    key: "update",
    value: function update(expression, params) {
      this.setParams(params);

      if (expression) {
        this.loadData(expression, this.params);
      } else {
        this.render(this.data);
      }
    }
  }, {
    key: "render",
    value: function render(data) {
      this.loadingSubject.next();
      this.renderHandler.render(data, this.params.extraHandlers);
    }
  }, {
    key: "setParams",
    value: function setParams(params) {
      if (!params || !Object.keys(params).length) {
        return;
      }

      if (params.searchContext && this.params.searchContext) {
        this.params.searchContext = _.defaults({}, params.searchContext, this.params.searchContext);
      }

      if (params.extraHandlers && this.params) {
        this.params.extraHandlers = params.extraHandlers;
      }

      if (!Object.keys(this.params).length) {
        this.params = _objectSpread({}, params, {
          searchContext: _objectSpread({
            type: 'kibana_context'
          }, params.searchContext || {})
        });
      }
    }
  }]);

  return ExpressionLoader;
}();

exports.ExpressionLoader = ExpressionLoader;

var loader = function loader(element, expression, params) {
  return new ExpressionLoader(element, expression, params);
};

exports.loader = loader;