"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initLegacyModule = void 0;

var _lodash = require("lodash");

var _i18n = require("ui/i18n");

var _modules = require("ui/modules");

var _new_platform = require("ui/new_platform");

var _filter = require("../filter");

var _index_patterns = require("../index_patterns/index_patterns");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore

/** @internal */
var initLegacyModule = (0, _lodash.once)(function () {
  _modules.uiModules.get('app/kibana', ['react']).directive('filterBar', function () {
    return {
      restrict: 'E',
      template: '',
      compile: function compile(elem) {
        var child = document.createElement('filter-bar-helper'); // Copy attributes to the child directive

        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = elem[0].attributes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var attr = _step.value;
            child.setAttribute(attr.name, attr.value);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return != null) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        child.setAttribute('ui-settings', 'uiSettings');
        child.setAttribute('doc-links', 'docLinks');
        child.setAttribute('plugin-data-start', 'pluginDataStart'); // Append helper directive

        elem.append(child);

        var linkFn = function linkFn($scope) {
          $scope.uiSettings = _new_platform.npStart.core.uiSettings;
          $scope.docLinks = _new_platform.npStart.core.docLinks;
          $scope.pluginDataStart = _new_platform.npStart.plugins.data;
        };

        return linkFn;
      }
    };
  }).directive('filterBarHelper', function (reactDirective) {
    return reactDirective((0, _i18n.wrapInI18nContext)(_filter.FilterBar), [['uiSettings', {
      watchDepth: 'reference'
    }], ['docLinks', {
      watchDepth: 'reference'
    }], ['onFiltersUpdated', {
      watchDepth: 'reference'
    }], ['indexPatterns', {
      watchDepth: 'collection'
    }], ['filters', {
      watchDepth: 'collection'
    }], ['className', {
      watchDepth: 'reference'
    }], ['pluginDataStart', {
      watchDepth: 'reference'
    }]]);
  }).directive('applyFiltersPopover', function () {
    return {
      restrict: 'E',
      template: '',
      compile: function compile(elem) {
        var child = document.createElement('apply-filters-popover-helper'); // Copy attributes to the child directive

        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = elem[0].attributes[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var attr = _step2.value;
            child.setAttribute(attr.name, attr.value);
          } // Add a key attribute that will force a full rerender every time that
          // a filter changes.

        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
              _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }

        child.setAttribute('key', 'key'); // Append helper directive

        elem.append(child);

        var linkFn = function linkFn($scope, _, $attr) {
          // Watch only for filter changes to update key.
          $scope.$watch(function () {
            return $scope.$eval($attr.filters) || [];
          }, function (newVal) {
            $scope.key = Date.now();
          }, true);
        };

        return linkFn;
      }
    };
  }).directive('applyFiltersPopoverHelper', function (reactDirective) {
    return reactDirective((0, _i18n.wrapInI18nContext)(_filter.ApplyFiltersPopover), [['filters', {
      watchDepth: 'collection'
    }], ['onCancel', {
      watchDepth: 'reference'
    }], ['onSubmit', {
      watchDepth: 'reference'
    }], ['indexPatterns', {
      watchDepth: 'collection'
    }], // Key is needed to trigger a full rerender of the component
    'key']);
  });

  var module = _modules.uiModules.get('kibana/index_patterns');

  var _service;

  module.service('indexPatterns', function () {
    if (!_service) _service = new _index_patterns.IndexPatterns(_new_platform.npStart.core.uiSettings, _new_platform.npStart.core.savedObjects.client, _new_platform.npStart.core.http, _new_platform.npStart.core.notifications);
    return _service;
  });
});
exports.initLegacyModule = initLegacyModule;