"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autoIndent = autoIndent;
exports.getDocumentation = getDocumentation;

var _autocomplete = require("../../../../../../public/quarantined/src/autocomplete");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
function autoIndent(editor, event) {
  editor.autoIndent();
  event.preventDefault();
  editor.focus();
}

function getDocumentation(editor, docLinkVersion) {
  return new Promise(function (resolve) {
    editor.getRequestsInRange(function (requests) {
      if (!requests || requests.length === 0) {
        resolve(null);
        return;
      }

      var position = requests[0].range.end;
      position.column = position.column - 1;
      var endpoint = (0, _autocomplete.getEndpointFromPosition)(editor, position);

      if (endpoint && endpoint.documentation && endpoint.documentation.indexOf('http') !== -1) {
        var nextDocumentation = endpoint.documentation.replace('/master/', "/".concat(docLinkVersion, "/")).replace('/current/', "/".concat(docLinkVersion, "/"));
        resolve(nextDocumentation);
      } else {
        resolve(null);
      }
    });
  });
}