"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplicationService = void 0;

var _history = require("history");

var _rxjs = require("rxjs");

var _react = _interopRequireDefault(require("react"));

var _capabilities = require("./capabilities");

var _ui = require("./ui");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Service that is responsible for registering new applications.
 * @internal
 */
var ApplicationService =
/*#__PURE__*/
function () {
  function ApplicationService() {
    _classCallCheck(this, ApplicationService);

    _defineProperty(this, "apps$", new _rxjs.BehaviorSubject(new Map()));

    _defineProperty(this, "legacyApps$", new _rxjs.BehaviorSubject(new Map()));

    _defineProperty(this, "capabilities", new _capabilities.CapabilitiesService());

    _defineProperty(this, "mountContext", void 0);
  }

  _createClass(ApplicationService, [{
    key: "setup",
    value: function setup(_ref) {
      var _this = this;

      var context = _ref.context;
      this.mountContext = context.createContextContainer();
      return {
        register: function register(plugin, app) {
          if (_this.apps$.value.has(app.id)) {
            throw new Error("An application is already registered with the id \"".concat(app.id, "\""));
          }

          if (_this.apps$.isStopped) {
            throw new Error("Applications cannot be registered after \"setup\"");
          }

          var appBox = {
            app: app,
            mount: _this.mountContext.createHandler(plugin, app.mount)
          };

          _this.apps$.next(new Map([].concat(_toConsumableArray(_this.apps$.value.entries()), [[app.id, appBox]])));
        },
        registerLegacyApp: function registerLegacyApp(app) {
          if (_this.legacyApps$.value.has(app.id)) {
            throw new Error("A legacy application is already registered with the id \"".concat(app.id, "\""));
          }

          if (_this.legacyApps$.isStopped) {
            throw new Error("Applications cannot be registered after \"setup\"");
          }

          _this.legacyApps$.next(new Map([].concat(_toConsumableArray(_this.legacyApps$.value.entries()), [[app.id, app]])));
        },
        registerMountContext: this.mountContext.registerContext
      };
    }
  }, {
    key: "start",
    value: function () {
      var _start = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(_ref2) {
        var _this2 = this;

        var http, injectedMetadata, _ref2$redirectTo, redirectTo, legacyMode, currentAppId$, _ref3, availableApps, availableLegacyApps, capabilities, history;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                http = _ref2.http, injectedMetadata = _ref2.injectedMetadata, _ref2$redirectTo = _ref2.redirectTo, redirectTo = _ref2$redirectTo === void 0 ? function (path) {
                  return window.location.href = path;
                } : _ref2$redirectTo;

                if (this.mountContext) {
                  _context.next = 3;
                  break;
                }

                throw new Error("ApplicationService#setup() must be invoked before start.");

              case 3:
                // Disable registration of new applications
                this.apps$.complete();
                this.legacyApps$.complete();
                legacyMode = injectedMetadata.getLegacyMode();
                currentAppId$ = new _rxjs.BehaviorSubject(undefined);
                _context.next = 9;
                return this.capabilities.start({
                  apps: new Map(_toConsumableArray(this.apps$.value).map(function (_ref4) {
                    var _ref5 = _slicedToArray(_ref4, 2),
                        id = _ref5[0],
                        app = _ref5[1].app;

                    return [id, app];
                  })),
                  legacyApps: this.legacyApps$.value,
                  injectedMetadata: injectedMetadata
                });

              case 9:
                _ref3 = _context.sent;
                availableApps = _ref3.availableApps;
                availableLegacyApps = _ref3.availableLegacyApps;
                capabilities = _ref3.capabilities;
                // Only setup history if we're not in legacy mode
                history = legacyMode ? null : (0, _history.createBrowserHistory)({
                  basename: http.basePath.get()
                });
                return _context.abrupt("return", {
                  availableApps: availableApps,
                  availableLegacyApps: availableLegacyApps,
                  capabilities: capabilities,
                  registerMountContext: this.mountContext.registerContext,
                  currentAppId$: currentAppId$,
                  getUrlForApp: function getUrlForApp(appId) {
                    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
                    return http.basePath.prepend(appPath(appId, options));
                  },
                  navigateToApp: function navigateToApp(appId) {
                    var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                        path = _ref6.path,
                        state = _ref6.state;

                    if (legacyMode) {
                      // If we're in legacy mode, do a full page refresh to load the NP app.
                      redirectTo(http.basePath.prepend(appPath(appId, {
                        path: path
                      })));
                    } else {
                      // basePath not needed here because `history` is configured with basename
                      history.push(appPath(appId, {
                        path: path
                      }), state);
                    }
                  },
                  getComponent: function getComponent() {
                    if (legacyMode) {
                      return null;
                    } // Filter only available apps and map to just the mount function.


                    var appMounters = new Map(_toConsumableArray(_this2.apps$.value).filter(function (_ref7) {
                      var _ref8 = _slicedToArray(_ref7, 1),
                          id = _ref8[0];

                      return availableApps.has(id);
                    }).map(function (_ref9) {
                      var _ref10 = _slicedToArray(_ref9, 2),
                          id = _ref10[0],
                          mount = _ref10[1].mount;

                      return [id, mount];
                    }));
                    return _react.default.createElement(_ui.AppRouter, {
                      apps: appMounters,
                      legacyApps: availableLegacyApps,
                      basePath: http.basePath,
                      currentAppId$: currentAppId$,
                      history: history,
                      redirectTo: redirectTo
                    });
                  }
                });

              case 15:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function start(_x) {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return ApplicationService;
}();

exports.ApplicationService = ApplicationService;

var appPath = function appPath(appId) {
  var _ref11 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      path = _ref11.path;

  return path ? "/app/".concat(appId, "/").concat(path.replace(/^\//, '')) // Remove preceding slash from path if present
  : "/app/".concat(appId);
};