/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;

public class NumberCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JSpinner editor = new JSpinner();
    private SpinnerNumberModel spinnerModel;

    public NumberCellEditor() {
        this.editor.setBorder(BorderFactory.createEmptyBorder());
        this.spinnerModel = (SpinnerNumberModel)this.editor.getModel();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() > 1;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object comparable, boolean bl, int n, int n2) {
        this.editor.setValue(comparable != null ? comparable : this.getModel().getMinimum());
        return this.editor;
    }

    public SpinnerNumberModel getModel() {
        return this.spinnerModel;
    }

    public void setModel(SpinnerNumberModel spinnerNumberModel) {
        this.spinnerModel = spinnerNumberModel;
        this.editor.setModel(this.spinnerModel);
    }

    public void setMinimum(Comparable comparable) {
        this.getModel().setMinimum(comparable);
    }

    public void setMaximum(Comparable comparable) {
        this.getModel().setMaximum(comparable);
    }
}

