/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.beans;

import grails.databinding.DataBinder;
import grails.util.Environment;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.grails.web.binding.CompositeEditor;
import org.grails.web.binding.StructuredDateEditor;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PropertyEditorRegistryUtils
implements GroovyObject {
    private static final String PROPERTY_EDITOR_REGISTRARS = "org.codehaus.groovy.grails.PROPERTY_EDITOR_REGISTRARS";
    private static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PropertyEditorRegistryUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void registerCustomEditors(GrailsWebRequest grailsWebRequest, PropertyEditorRegistry registry, Locale locale) {
        NumberFormat floatFormat = NumberFormat.getInstance(locale);
        NumberFormat integerFormat = NumberFormat.getIntegerInstance(locale);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DataBinder.DEFAULT_DATE_FORMAT, locale);
        registry.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
        registry.registerCustomEditor(BigDecimal.class, (PropertyEditor)new CustomNumberEditor(BigDecimal.class, floatFormat, true));
        registry.registerCustomEditor(BigInteger.class, (PropertyEditor)new CustomNumberEditor(BigInteger.class, floatFormat, true));
        registry.registerCustomEditor(Double.class, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Double.TYPE, (PropertyEditor)new CustomNumberEditor(Double.class, floatFormat, true));
        registry.registerCustomEditor(Float.class, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Float.TYPE, (PropertyEditor)new CustomNumberEditor(Float.class, floatFormat, true));
        registry.registerCustomEditor(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Long.TYPE, (PropertyEditor)new CustomNumberEditor(Long.class, integerFormat, true));
        registry.registerCustomEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Integer.TYPE, (PropertyEditor)new CustomNumberEditor(Integer.class, integerFormat, true));
        registry.registerCustomEditor(Short.class, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Short.TYPE, (PropertyEditor)new CustomNumberEditor(Short.class, integerFormat, true));
        registry.registerCustomEditor(Date.class, (PropertyEditor)new CompositeEditor(new PropertyEditor[]{new StructuredDateEditor(dateFormat, true), new CustomDateEditor((DateFormat)new SimpleDateFormat(JSON_DATE_FORMAT), true)}));
        registry.registerCustomEditor(Calendar.class, (PropertyEditor)((Object)new StructuredDateEditor(dateFormat, true)));
        ServletContext servletContext = (ServletContext)ScriptBytecodeAdapter.castToType((Object)(grailsWebRequest != null ? grailsWebRequest.getServletContext() : null), ServletContext.class);
        PropertyEditorRegistryUtils.registerCustomEditorsFromContext(servletContext, registry);
    }

    private static void registerCustomEditorsFromContext(ServletContext servletContext, PropertyEditorRegistry registry) {
        if (servletContext == null) {
            return;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (context == null) {
            return;
        }
        Map editors = (Map)ScriptBytecodeAdapter.castToType((Object)servletContext.getAttribute(PROPERTY_EDITOR_REGISTRARS), Map.class);
        if (editors == null) {
            Map map;
            editors = map = context.getBeansOfType(PropertyEditorRegistrar.class);
            if (!Environment.isDevelopmentMode()) {
                servletContext.setAttribute(PROPERTY_EDITOR_REGISTRARS, (Object)editors);
            }
        }
        PropertyEditorRegistrar editorRegistrar = null;
        Iterator iterator = editors.values().iterator();
        while (iterator.hasNext()) {
            editorRegistrar = (PropertyEditorRegistrar)ScriptBytecodeAdapter.castToType(iterator.next(), PropertyEditorRegistrar.class);
            editorRegistrar.registerCustomEditors(registry);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PropertyEditorRegistryUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

