/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.IvyArtifactName;

public class ModuleSelectors<T extends ResolvableSelectorState>
implements Iterable<T> {
    private static final VersionParser VERSION_PARSER = new VersionParser();
    private static final Version EMPTY_VERSION = VERSION_PARSER.transform("");
    private static final Comparator<Version> VERSION_COMPARATOR = new DefaultVersionComparator().asVersionComparator().reversed();
    static final Comparator<ResolvableSelectorState> SELECTOR_COMPARATOR = ModuleSelectors.reverse(ResolvableSelectorState::isProject).thenComparing(ModuleSelectors.reverse(ResolvableSelectorState::isFromLock)).thenComparing(ModuleSelectors.reverse(ModuleSelectors::hasLatestSelector)).thenComparing(ModuleSelectors::isDynamicSelector).thenComparing(ModuleSelectors::requiredVersion, VERSION_COMPARATOR).thenComparing(ModuleSelectors::preferredVersion, VERSION_COMPARATOR);
    private final List<T> selectors = Lists.newArrayList();
    private boolean deferSelection;
    private boolean forced;

    private static <T, U extends Comparable<? super U>> Comparator<T> reverse(Function<? super T, ? extends U> keyExtractor) {
        return (Comparator)Cast.uncheckedCast(Comparator.comparing(keyExtractor).reversed());
    }

    public boolean checkDeferSelection() {
        if (this.deferSelection) {
            this.deferSelection = false;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.selectors.iterator();
    }

    public void add(T selector, boolean deferSelection) {
        this.deferSelection = deferSelection;
        if (this.selectors.isEmpty() || this.forced) {
            this.selectors.add(selector);
        } else {
            this.doAdd(selector);
        }
        this.forced = this.forced || selector.isForce();
    }

    private void doAdd(T selector) {
        int size = this.selectors.size();
        if (size == 1) {
            this.doAddWhenListHasOneElement(selector);
        } else {
            ModuleSelectors.doAddWhenListHasManyElements(this.selectors, selector, size);
        }
    }

    private static <T extends ResolvableSelectorState> void doAddWhenListHasManyElements(List<T> selectors, T selector, int size) {
        int insertionPoint = Collections.binarySearch(selectors, selector, SELECTOR_COMPARATOR);
        if ((insertionPoint = ModuleSelectors.advanceToPreserveOrder(selectors, selector, size, insertionPoint)) < 0) {
            insertionPoint ^= 0xFFFFFFFF;
        }
        selectors.add(insertionPoint, selector);
    }

    private static <T extends ResolvableSelectorState> int advanceToPreserveOrder(List<T> selectors, T selector, int size, int insertionPoint) {
        while (insertionPoint > 0 && insertionPoint < size && SELECTOR_COMPARATOR.compare((ResolvableSelectorState)selectors.get(insertionPoint), selector) == 0) {
            ++insertionPoint;
        }
        return insertionPoint;
    }

    private void doAddWhenListHasOneElement(T selector) {
        ResolvableSelectorState first = (ResolvableSelectorState)this.selectors.get(0);
        int c = SELECTOR_COMPARATOR.compare(first, (ResolvableSelectorState)selector);
        if (c <= 0) {
            this.selectors.add(selector);
        } else {
            this.selectors.add(0, selector);
        }
    }

    public boolean remove(T selector) {
        return this.selectors.remove(selector);
    }

    private static boolean isDynamicSelector(ResolvableSelectorState selector) {
        return selector.getVersionConstraint() != null && selector.getVersionConstraint().isDynamic();
    }

    private static boolean hasLatestSelector(ResolvableSelectorState selector) {
        return selector.getVersionConstraint() != null && ModuleSelectors.hasLatestSelector(selector.getVersionConstraint());
    }

    private static boolean hasLatestSelector(ResolvedVersionConstraint vc) {
        return ModuleSelectors.hasLatestSelector(vc.getRequiredSelector());
    }

    private static boolean hasLatestSelector(VersionSelector versionSelector) {
        return versionSelector instanceof LatestVersionSelector;
    }

    private static Version requiredVersion(ResolvableSelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint == null) {
            return EMPTY_VERSION;
        }
        return ModuleSelectors.versionOf(versionConstraint.getRequiredSelector());
    }

    private static Version preferredVersion(ResolvableSelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint == null) {
            return EMPTY_VERSION;
        }
        return ModuleSelectors.versionOf(versionConstraint.getPreferredSelector());
    }

    private static Version versionOf(VersionSelector selector) {
        if (!(selector instanceof ExactVersionSelector)) {
            return EMPTY_VERSION;
        }
        return VERSION_PARSER.transform(selector.getSelector());
    }

    public int size() {
        return this.selectors.size();
    }

    public T first() {
        if (this.size() == 0) {
            return null;
        }
        if (this.size() == 1) {
            return (T)((ResolvableSelectorState)this.selectors.get(0));
        }
        return (T)((ResolvableSelectorState)this.selectors.get(0));
    }

    public IvyArtifactName getFirstDependencyArtifact() {
        for (ResolvableSelectorState selector : this.selectors) {
            if (selector.getFirstDependencyArtifact() == null) continue;
            return selector.getFirstDependencyArtifact();
        }
        return null;
    }
}

