/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;

public class DefaultCollectionEventRegister<T>
implements CollectionEventRegister<T> {
    private final Class<? extends T> baseType;
    private final CollectionCallbackActionDecorator decorator;
    private ImmutableActionSet<T> addActions = ImmutableActionSet.empty();
    private ImmutableActionSet<T> removeActions = ImmutableActionSet.empty();
    private boolean baseTypeSubscribed;
    private Set<Class<?>> subscribedTypes;

    public DefaultCollectionEventRegister(Class<? extends T> baseType, CollectionCallbackActionDecorator decorator) {
        this.baseType = baseType;
        this.decorator = decorator;
    }

    @Override
    public boolean isSubscribed(Class<?> type) {
        if (this.baseTypeSubscribed) {
            return true;
        }
        if (this.subscribedTypes != null) {
            if (type == null) {
                return true;
            }
            for (Class<?> subscribedType : this.subscribedTypes) {
                if (!subscribedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CollectionCallbackActionDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public ImmutableActionSet<T> getAddActions() {
        return this.addActions;
    }

    @Override
    public void fireObjectAdded(T element) {
        this.addActions.execute(element);
    }

    @Override
    public void fireObjectRemoved(T element) {
        this.removeActions.execute(element);
    }

    @Override
    public Action<? super T> registerEagerAddAction(Class<? extends T> type, Action<? super T> addAction) {
        return this.registerEagerAddDecoratedAction(type, addAction);
    }

    @Override
    public Action<? super T> registerLazyAddAction(Action<? super T> addAction) {
        return this.registerLazyAddDecoratedAction(addAction);
    }

    @Override
    public void registerRemoveAction(Class<? extends T> type, Action<? super T> removeAction) {
        this.registerRemoveDecoratedAction(removeAction);
    }

    private Action<? super T> registerEagerAddDecoratedAction(Class<? extends T> type, Action<? super T> decorated) {
        this.subscribe(type);
        return this.registerLazyAddDecoratedAction(decorated);
    }

    private Action<? super T> registerLazyAddDecoratedAction(Action<? super T> decorated) {
        this.addActions = this.addActions.add(decorated);
        return decorated;
    }

    private void registerRemoveDecoratedAction(Action<? super T> decorated) {
        this.removeActions = this.removeActions.add(decorated);
    }

    @Override
    public <S extends T> CollectionEventRegister<S> filtered(CollectionFilter<S> filter) {
        return new FilteredEventRegister<S>(filter, this);
    }

    private void subscribe(Class<? extends T> type) {
        if (this.baseTypeSubscribed) {
            return;
        }
        if (type.equals(this.baseType)) {
            this.baseTypeSubscribed = true;
            this.subscribedTypes = null;
        } else {
            if (this.subscribedTypes == null) {
                this.subscribedTypes = new HashSet();
            }
            this.subscribedTypes.add(type);
        }
    }

    private class FilteredEventRegister<S extends T>
    implements CollectionEventRegister<S> {
        private final CollectionFilter<S> filter;
        private final CollectionEventRegister<S> delegate;

        FilteredEventRegister(CollectionFilter<S> filter, CollectionEventRegister<T> delegate) {
            this.filter = filter;
            this.delegate = (CollectionEventRegister)Cast.uncheckedCast(delegate);
        }

        @Override
        public CollectionCallbackActionDecorator getDecorator() {
            return this.delegate.getDecorator();
        }

        @Override
        public ImmutableActionSet<S> getAddActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fireObjectAdded(S element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fireObjectRemoved(S element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSubscribed(Class<?> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Action<? super S> registerEagerAddAction(Class<? extends S> type, Action<? super S> addAction) {
            return this.delegate.registerEagerAddAction(type, this.filter.filtered(addAction));
        }

        @Override
        public Action<? super S> registerLazyAddAction(Action<? super S> addAction) {
            return this.delegate.registerLazyAddAction(this.filter.filtered(addAction));
        }

        @Override
        public void registerRemoveAction(Class<? extends S> type, Action<? super S> removeAction) {
            this.delegate.registerRemoveAction(type, this.filter.filtered(removeAction));
        }

        @Override
        public <N extends S> CollectionEventRegister<N> filtered(CollectionFilter<N> filter) {
            return new FilteredEventRegister<N>(filter, this);
        }
    }
}

