define(["dom","focusManager","appRouter","inputManager","events","globalize","layoutManager","playbackManager","itemHelper","listView","imageLoader","backdrop","emby-scroller","emby-itemscontainer","css!./playqueue","paper-icon-button-light"],function(dom,focusManager,appRouter,inputManager,events,globalize,layoutManager,playbackManager,itemHelper,listView,imageLoader,backdrop){"use strict";function isValidForPlaylist(i){return i.Id&&i.ServerId}function savePlaylist(instance){require(["playlistEditor"],function(playlistEditor){fetchPlaylistItems.call(instance).then(function(items){if((items=items.filter(isValidForPlaylist)).length){var serverId=items[0].ServerId;(new playlistEditor).show({items:items.map(function(i){return i.Id}),serverId:serverId,enableAddToPlayQueue:!1,defaultValue:"new"})}})})}function fetchPlaylistItems(){if(this.empty)return renderNextItem(this,null),Promise.resolve([]);var instance=this;return playbackManager.getPlaylist(this.currentPlayer).then(function(items){return renderNextItem(instance,items[instance.playlistIndex+1]),items})}function renderNextItem(instance,item){var name;instance.upNextTitleElement||(instance.upNextTitleElement=instance.options.parent.querySelector(".upNextTitle")),item&&(name=itemHelper.getDisplayName(item,{})),instance.upNextTitleElement.innerHTML=name?globalize.translate("NextValue",name):""}function OsdPlayQueue(options){var parent=(this.options=options).parent;!function(parent,options){var html="";options.toggleBar&&(html+='<div class="upNextBar upNextBar-togglebar flex align-items-center">',html+='<i class="md-icon flex-shrink-zero" style="font-size:1.7em;">&#xe03d;</i>',html+='<div class="upNextTitle flex-grow">',html+="</div>",html+='<button type="button" is="paper-icon-button-light" class="btnToggleOsdPlayQueue flex-shrink-zero" title="'+globalize.translate("HeaderPlayQueue")+'"><i class="md-icon btnToggleOsdPlayQueue-icon">&#xe5ce;</i></button>',html+="</div>",html+='<div class="upNextBar upNextBar-static flex align-items-center">',html+='<i class="md-icon flex-shrink-zero" style="font-size:1.7em;">&#xe03d;</i>',html+='<div class="upNextTitle flex-grow">',html+=globalize.translate("HeaderPlayQueue"),html+="</div>",html+='<button type="button" is="paper-icon-button-light" class="btnSavePlaylist flex-shrink-zero" title="'+globalize.translate("HeaderSavePlaylist")+'"><i class="md-icon">&#xe161;</i></button>',html+="</div>"),html+='<div class="osdPlaylist flex flex-grow hide osdPlaylist-hidden">',html+='<div is="emby-scroller" class="flex flex-grow osdPlaylist-scroller" data-mousewheel="true" data-horizontal="false" data-centerfocus="true">',html+='<div is="emby-itemscontainer" class="scrollSlider flex-grow flex-direction-column vertical-list itemsContainer osdPlaylistItemsContainer" data-dragreorder="true">',html+="</div>",html+="</div>",html+="</div>",parent.innerHTML=html}(parent,options),this.playlistElement=parent.querySelector(".osdPlaylist"),this.itemsContainer=parent.querySelector(".itemsContainer"),this.itemsContainer.fetchData=fetchPlaylistItems.bind(this),this.itemsContainer.getItemsHtml=function(items){return listView.getListViewHtml({items:items,smallIcon:!0,action:"setplaylistindex",enableUserDataButtons:!1,rightButtons:[{icon:"&#xE15C;",title:globalize.translate("Remove"),id:"remove"}],dragHandle:!layoutManager.tv,playlistItemId:this.playlistItemId})}.bind(this),this.toggleIcon=parent.querySelector(".btnToggleOsdPlayQueue-icon"),parent.querySelector(".upNextBar-togglebar").addEventListener("click",function(e){dom.parentWithClass(e.target,"btnSavePlaylist")?savePlaylist(this):this.togglePlaylist()}.bind(this)),parent.querySelector(".upNextBar-static").addEventListener("click",function(e){dom.parentWithClass(e.target,"btnSavePlaylist")&&savePlaylist(this)}.bind(this)),this.itemsContainer.addEventListener("action-remove",function(e){playbackManager.removeFromPlaylist([e.detail.playlistItemId],this.currentPlayer)}.bind(this)),this.itemsContainer.addEventListener("itemdrop",function(e){var newIndex=e.detail.newIndex,playlistItemId=e.detail.playlistItemId;playbackManager.movePlaylistItem(playlistItemId,newIndex,this.currentPlayer)}.bind(this)),this.playlistElement.addEventListener(dom.whichTransitionEvent(),onPlaylistTransitionComplete)}function onPlaylistTransitionComplete(e){var elem=e.target;elem===e.currentTarget&&elem.classList.contains("osdPlaylist-hidden")&&elem.classList.add("hide")}return OsdPlayQueue.prototype.showPlaylist=function(){var elem=this.playlistElement;elem.classList.remove("hide"),this.toggleIcon.innerHTML="&#xe5cf;",elem.offsetWidth,elem.classList.remove("osdPlaylist-hidden"),this.options.parent.classList.add("osdPlayQueue-expanded"),this.playlistExpanded=!0,events.trigger(this,"playlistexpanded")},OsdPlayQueue.prototype.hidePlaylist=function(){this.playlistElement.classList.add("osdPlaylist-hidden"),this.toggleIcon.innerHTML="&#xe5ce;",this.options.parent.classList.remove("osdPlayQueue-expanded"),this.playlistExpanded=!1,events.trigger(this,"playlistcollapsed")},OsdPlayQueue.prototype.togglePlaylist=function(){this.playlistExpanded?this.hidePlaylist():this.showPlaylist()},OsdPlayQueue.prototype.updatePlaylist=function(player,playlistItemId,playlistIndex,playlistLength){this.currentPlayer=player;var parent=this.options.parent;playlistLength?(this.empty=!1,this.playlistItemId=playlistItemId,this.playlistIndex=playlistIndex,this.refreshItems(),parent.classList.remove("hide")):(parent.classList.add("hide"),this.empty=!0,this.playlistItemId=null,this.playlistIndex=-1,this.refreshItems()),1<playlistLength?parent.classList.remove("osdPlayQueue-singletrack"):parent.classList.add("osdPlayQueue-singletrack")},OsdPlayQueue.prototype.onPlaybackStopped=function(){this.empty=!0,this.playlistItemId=null,this.playlistIndex=-1,this.refreshItems()},OsdPlayQueue.prototype.refreshItems=function(){this.itemsContainer.refreshItems?this.itemsContainer.refreshItems():setTimeout(this.refreshItems.bind(this),100)},OsdPlayQueue.prototype.onPlaylistItemMoved=function(player,e,info){this.playlistIndex=playbackManager.getCurrentPlaylistIndex(player),fetchPlaylistItems.call(this)},OsdPlayQueue.prototype.onPlaylistItemRemoved=function(player,e,info){for(var playlistItemIds=info.playlistItemIds,parent=this.options.parent,i=0,length=playlistItemIds.length;i<length;i++){var listItem=parent.querySelector('.listItem[data-playlistItemId="'+playlistItemIds[i]+'"]');listItem&&listItem.parentNode.removeChild(listItem)}this.playlistIndex=playbackManager.getCurrentPlaylistIndex(player),fetchPlaylistItems.call(this)},OsdPlayQueue.prototype.onInputCommand=function(e){return!(!this.playlistExpanded||"back"!==e.detail.command||focusManager.hasExclusiveFocusScope())&&(this.hidePlaylist(),e.preventDefault(),!0)},OsdPlayQueue.prototype.pause=function(){this.itemsContainer.pause()},OsdPlayQueue.prototype.resume=function(options){this.itemsContainer.resume(options)},OsdPlayQueue.prototype.setBackdropItems=function(items){},OsdPlayQueue.prototype.destroy=function(){var options=this.options;if(options){var parent=options.parent;parent&&(parent.innerHTML="",parent.classList.add("hide"))}this.options=null,this.currentPlayer=null,this.upNextTitleElement=null,this.itemsContainer=null,this.playlistElement=null,this.toggleIcon=null},OsdPlayQueue});