/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class ShapeQuery
extends Query {
    final String field;
    final ShapeField.QueryRelation queryRelation;

    protected ShapeQuery(String field, ShapeField.QueryRelation queryType) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.queryRelation = queryType;
    }

    protected abstract PointValues.Relation relateRangeBBoxToQuery(int var1, int var2, byte[] var3, int var4, int var5, byte[] var6);

    protected abstract boolean queryMatches(byte[] var1, ShapeField.DecodedTriangle var2, ShapeField.QueryRelation var3);

    protected PointValues.Relation relateRangeToQuery(byte[] minTriangle, byte[] maxTriangle, ShapeField.QueryRelation queryRelation) {
        PointValues.Relation r = this.relateRangeBBoxToQuery(4, 0, minTriangle, 12, 8, maxTriangle);
        if (queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return ShapeQuery.transposeRelation(r);
        }
        return r;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        final ShapeQuery query = this;
        return new ConstantScoreWeight(query, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                PointValues values = reader.getPointValues(ShapeQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(ShapeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                1 weight = this;
                PointValues.Relation rel = ShapeQuery.this.relateRangeToQuery(values.getMinPackedValue(), values.getMaxPackedValue(), ShapeQuery.this.queryRelation);
                if (rel == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return null;
                }
                if (values.getDocCount() == reader.maxDoc() && rel == PointValues.Relation.CELL_INSIDE_QUERY) {
                    return new ScorerSupplier((Weight)weight, reader){
                        final /* synthetic */ Weight val$weight;
                        final /* synthetic */ LeafReader val$reader;
                        {
                            this.val$weight = weight;
                            this.val$reader = leafReader;
                        }

                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(this.val$weight, this.score(), scoreMode, DocIdSetIterator.all((int)this.val$reader.maxDoc()));
                        }

                        public long cost() {
                            return this.val$reader.maxDoc();
                        }
                    };
                }
                if (ShapeQuery.this.queryRelation != ShapeField.QueryRelation.INTERSECTS && !ShapeQuery.hasAnyHits(query, values)) {
                    return null;
                }
                return new RelationScorerSupplier(values, ShapeQuery.this, (Weight)weight){
                    final /* synthetic */ Weight val$weight;
                    {
                        this.val$weight = weight;
                        super(values, query);
                    }

                    public Scorer get(long leadCost) throws IOException {
                        return this.getScorer(reader, this.val$weight, this.score(), scoreMode);
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public ShapeField.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.queryRelation.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((ShapeQuery)((Object)o)).field) && this.queryRelation == ((ShapeQuery)((Object)o)).queryRelation;
    }

    private static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static PointValues.IntersectVisitor getEstimateVisitor(final ShapeQuery query) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                throw new UnsupportedOperationException();
            }

            public void visit(int docID, byte[] t) {
                throw new UnsupportedOperationException();
            }

            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return query.relateRangeToQuery(minTriangle, maxTriangle, query.getQueryRelation());
            }
        };
    }

    private static PointValues.IntersectVisitor getSparseVisitor(final ShapeQuery query, final DocIdSetBuilder result) {
        return new PointValues.IntersectVisitor(){
            final ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
            DocIdSetBuilder.BulkAdder adder;

            public void grow(int count) {
                this.adder = result.grow(count);
            }

            public void visit(int docID) {
                this.adder.add(docID);
            }

            public void visit(int docID, byte[] t) {
                if (query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                    this.visit(docID);
                }
            }

            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                if (query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return query.relateRangeToQuery(minTriangle, maxTriangle, query.getQueryRelation());
            }
        };
    }

    private static PointValues.IntersectVisitor getDenseVisitor(final ShapeQuery query, final FixedBitSet result, final FixedBitSet excluded, final long[] cost) {
        return new PointValues.IntersectVisitor(){
            final ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();

            public void visit(int docID) {
                result.set(docID);
                cost[0] = cost[0] + 1L;
            }

            public void visit(int docID, byte[] t) {
                if (query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                    this.visit(docID);
                } else {
                    excluded.set(docID);
                }
            }

            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                int docID;
                boolean matches = query.queryMatches(t, this.scratchTriangle, query.getQueryRelation());
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (matches) {
                        this.visit(docID);
                        continue;
                    }
                    excluded.set(docID);
                }
            }

            public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                return query.relateRangeToQuery(minTriangle, maxTriangle, query.getQueryRelation());
            }
        };
    }

    private static PointValues.IntersectVisitor getInverseDenseVisitor(final ShapeQuery query, final FixedBitSet result, final long[] cost) {
        return new PointValues.IntersectVisitor(){
            final ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();

            public void visit(int docID) {
                result.clear(docID);
                cost[0] = cost[0] - 1L;
            }

            public void visit(int docID, byte[] packedTriangle) {
                if (!query.queryMatches(packedTriangle, this.scratchTriangle, query.getQueryRelation())) {
                    this.visit(docID);
                }
            }

            public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                if (!query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return ShapeQuery.transposeRelation(query.relateRangeToQuery(minPackedValue, maxPackedValue, query.getQueryRelation()));
            }
        };
    }

    private static PointValues.IntersectVisitor getShallowInverseDenseVisitor(final ShapeQuery query, final FixedBitSet result) {
        return new PointValues.IntersectVisitor(){

            public void visit(int docID) {
                result.clear(docID);
            }

            public void visit(int docID, byte[] packedTriangle) {
            }

            public void visit(DocIdSetIterator iterator, byte[] t) {
            }

            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                return ShapeQuery.transposeRelation(query.relateRangeToQuery(minPackedValue, maxPackedValue, query.getQueryRelation()));
            }
        };
    }

    private static boolean hasAnyHits(final ShapeQuery query, PointValues values) throws IOException {
        try {
            values.intersect(new PointValues.IntersectVisitor(){
                final ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();

                public void visit(int docID) {
                    throw new CollectionTerminatedException();
                }

                public void visit(int docID, byte[] t) {
                    if (query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                        throw new CollectionTerminatedException();
                    }
                }

                public void visit(DocIdSetIterator iterator, byte[] t) {
                    if (query.queryMatches(t, this.scratchTriangle, query.getQueryRelation())) {
                        throw new CollectionTerminatedException();
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    PointValues.Relation rel = query.relateRangeToQuery(minPackedValue, maxPackedValue, query.getQueryRelation());
                    if (rel == PointValues.Relation.CELL_INSIDE_QUERY) {
                        throw new CollectionTerminatedException();
                    }
                    return rel;
                }
            });
        }
        catch (CollectionTerminatedException e) {
            return true;
        }
        return false;
    }

    private static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        private final PointValues values;
        private final ShapeQuery query;
        private long cost = -1L;

        RelationScorerSupplier(PointValues values, ShapeQuery query) {
            this.values = values;
            this.query = query;
        }

        protected Scorer getScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            switch (this.query.getQueryRelation()) {
                case INTERSECTS: {
                    return this.getSparseScorer(reader, weight, boost, scoreMode);
                }
                case WITHIN: 
                case DISJOINT: {
                    return this.getDenseScorer(reader, weight, boost, scoreMode);
                }
            }
            throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)this.query.getQueryRelation()) + "]");
        }

        private Scorer getSparseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            if (this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result = new FixedBitSet(reader.maxDoc());
                result.set(0, reader.maxDoc());
                long[] cost = new long[]{reader.maxDoc()};
                this.values.intersect(ShapeQuery.getInverseDenseVisitor(this.query, result, cost));
                BitSetIterator iterator = new BitSetIterator((BitSet)result, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, (DocIdSetIterator)iterator);
            }
            DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(reader.maxDoc(), this.values, this.query.getField());
            this.values.intersect(ShapeQuery.getSparseVisitor(this.query, docIdSetBuilder));
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        private Scorer getDenseScorer(LeafReader reader, Weight weight, float boost, ScoreMode scoreMode) throws IOException {
            long[] cost;
            FixedBitSet result = new FixedBitSet(reader.maxDoc());
            if (this.values.getDocCount() == reader.maxDoc()) {
                cost = new long[]{this.values.size()};
                result.set(0, reader.maxDoc());
                this.values.intersect(ShapeQuery.getInverseDenseVisitor(this.query, result, cost));
            } else {
                cost = new long[]{0L};
                FixedBitSet excluded = new FixedBitSet(reader.maxDoc());
                this.values.intersect(ShapeQuery.getDenseVisitor(this.query, result, excluded, cost));
                result.andNot(excluded);
                this.values.intersect(ShapeQuery.getShallowInverseDenseVisitor(this.query, result));
            }
            assert (cost[0] > 0L);
            BitSetIterator iterator = new BitSetIterator((BitSet)result, cost[0]);
            return new ConstantScoreScorer(weight, boost, scoreMode, (DocIdSetIterator)iterator);
        }

        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.values.estimateDocCount(ShapeQuery.getEstimateVisitor(this.query));
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }
}

