/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTagParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandlerExtension;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParserExtension;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.util.Assert;

public abstract class AbstractModelLoader
implements IModelLoader {
    protected static final int encodingNameSearchLimit = 1000;
    private boolean DEBUG = false;
    protected IDocumentLoader documentLoaderInstance;

    private static long computeMem() {
        int i = 0;
        while (i < 5) {
            System.gc();
            System.runFinalization();
            ++i;
        }
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    protected void addFactories(IStructuredModel model, List factoryList) {
        Assert.isNotNull(model);
        FactoryRegistry registry = model.getFactoryRegistry();
        Assert.isNotNull(registry, "IStructuredModel " + model.getId() + " has a null FactoryRegistry");
        if (factoryList != null) {
            for (INodeAdapterFactory factory : factoryList) {
                registry.addFactory(factory);
            }
        }
    }

    @Override
    public IStructuredModel createModel() {
        this.documentLoaderInstance = null;
        IStructuredModel model = this.newModel();
        IEncodedDocument structuredDocument = this.getDocumentLoader().createNewStructuredDocument();
        if (structuredDocument instanceof IStructuredDocument) {
            model.setStructuredDocument((IStructuredDocument)structuredDocument);
            this.addFactories(model, this.getAdapterFactories());
            this.initEmbeddedTypePre(model, (IStructuredDocument)structuredDocument);
            this.initEmbeddedTypePost(model);
            this.preLoadAdapt(model);
        }
        return model;
    }

    @Override
    public IStructuredModel createModel(IStructuredDocument structuredDocument, String baseLocation, IModelHandler handler) {
        this.documentLoaderInstance = null;
        IStructuredModel model = this.newModel();
        model.setBaseLocation(baseLocation);
        model.setModelHandler(handler);
        this.addFactories(model, this.getAdapterFactories());
        this.preLoadAdapt(model);
        this.initEmbeddedTypePre(model, structuredDocument);
        model.setStructuredDocument(structuredDocument);
        this.initEmbeddedTypePost(model);
        return model;
    }

    @Override
    public IStructuredModel createModel(IStructuredModel oldModel) {
        this.documentLoaderInstance = null;
        IStructuredModel newModel = this.newModel();
        IStructuredDocument oldStructuredDocument = oldModel.getStructuredDocument();
        IStructuredDocument newStructuredDocument = oldStructuredDocument.newInstance();
        newModel.setStructuredDocument(newStructuredDocument);
        this.duplicateFactoryRegistry(newModel, oldModel);
        if (newModel instanceof AbstractStructuredModel) {
            ((AbstractStructuredModel)newModel).setContentTypeIdentifier(oldModel.getContentTypeIdentifier());
        }
        this.initEmbeddedType(oldModel, newModel);
        this.preLoadAdapt(newModel);
        return newModel;
    }

    private void duplicateFactoryRegistry(IStructuredModel newModel, IStructuredModel oldModel) {
        List oldAdapterFactories = oldModel.getFactoryRegistry().getFactories();
        ArrayList<INodeAdapterFactory> newAdapterFactories = new ArrayList<INodeAdapterFactory>();
        for (INodeAdapterFactory oldAdapterFactory : oldAdapterFactories) {
            newAdapterFactories.add(oldAdapterFactory.copy());
        }
        this.addFactories(newModel, newAdapterFactories);
    }

    @Override
    public List getAdapterFactories() {
        return new ArrayList(0);
    }

    public abstract IDocumentLoader getDocumentLoader();

    protected void initEmbeddedTypePre(IStructuredModel model) {
    }

    protected void initEmbeddedTypePre(IStructuredModel model, IStructuredDocument structuredDocument) {
        this.initEmbeddedTypePre(model);
    }

    protected void initEmbeddedTypePost(IStructuredModel model) {
    }

    protected void initEmbeddedType(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    @Override
    public void load(IFile file, IStructuredModel model) throws IOException, CoreException {
        IEncodedDocument structuredDocument = model.getStructuredDocument();
        structuredDocument = file == null ? this.getDocumentLoader().createNewStructuredDocument() : this.getDocumentLoader().createNewStructuredDocument(file);
        if (structuredDocument instanceof IStructuredDocument) {
            this.transformInstance(model.getStructuredDocument(), (IStructuredDocument)structuredDocument);
        } else {
            model.getStructuredDocument().set(structuredDocument.get());
        }
        this.documentLoaderInstance = null;
    }

    @Override
    public void load(InputStream inputStream, IStructuredModel model, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException {
        IEncodedDocument structuredDocument = model.getStructuredDocument();
        if (inputStream == null) {
            structuredDocument = this.getDocumentLoader().createNewStructuredDocument();
        } else {
            structuredDocument = this.getDocumentLoader().createNewStructuredDocument(model.getBaseLocation(), inputStream, encodingRule);
            model.getStructuredDocument().set(structuredDocument.get());
        }
        this.documentLoaderInstance = null;
    }

    public synchronized void load(InputStream inputStream, IStructuredModel model, String encodingName, String lineDelimiter) throws UnsupportedEncodingException, IOException {
        if (encodingName != null && encodingName.trim().length() == 0) {
            this.load(inputStream, model, EncodingRule.FORCE_DEFAULT);
        } else {
            this.load(inputStream, model, EncodingRule.CONTENT_BASED);
        }
    }

    @Override
    public void load(String filename, InputStream inputStream, IStructuredModel model, String junk, String dummy) throws UnsupportedEncodingException, IOException {
        long memoryAtEnd;
        long memoryUsed = 0L;
        if (this.DEBUG) {
            memoryUsed = AbstractModelLoader.computeMem();
            System.out.println("measuring heap memory for " + filename);
        }
        IEncodedDocument newstructuredDocument = null;
        IStructuredDocument oldStructuredDocument = model.getStructuredDocument();
        newstructuredDocument = inputStream == null ? this.getDocumentLoader().createNewStructuredDocument() : this.getDocumentLoader().createNewStructuredDocument(filename, inputStream);
        if (this.DEBUG) {
            memoryAtEnd = AbstractModelLoader.computeMem();
            System.out.println("    heap memory implied used by document: " + (memoryAtEnd - memoryUsed));
        }
        if (newstructuredDocument instanceof IStructuredDocument) {
            this.transformInstance(oldStructuredDocument, (IStructuredDocument)newstructuredDocument);
        } else {
            oldStructuredDocument.set(newstructuredDocument.get());
        }
        this.documentLoaderInstance = null;
        if (this.DEBUG) {
            memoryAtEnd = AbstractModelLoader.computeMem();
            System.out.println("    heap memory implied used by document and model: " + (memoryAtEnd - memoryUsed));
        }
    }

    @Override
    public abstract IStructuredModel newModel();

    protected void preLoadAdapt(IStructuredModel structuredModel) {
    }

    @Override
    public IStructuredModel reinitialize(IStructuredModel model) {
        model.getStructuredDocument().setText(this, model.getStructuredDocument().get());
        return model;
    }

    @Override
    public synchronized void reload(InputStream inputStream, IStructuredModel structuredModel) {
        this.documentLoaderInstance = null;
        try {
            this.load(inputStream, structuredModel, EncodingRule.CONTENT_BASED);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logException("Warning:  XMLLoader::reload.  This exception really should not have happened!! But will attemp to continue after dumping stack trace", e);
            throw new Error("Program Error", e);
        }
        catch (IOException e) {
            Logger.logException("Warning:  XMLLoader::reload.  This exception really should not have happened!! But will attemp to continue after dumping stack trace", e);
            throw new Error("Program Error", e);
        }
    }

    private void transformInstance(IStructuredDocument oldInstance, IStructuredDocument newInstance) {
        int i;
        RegionParser oldParser = oldInstance.getParser();
        RegionParser newParser = newInstance.getParser().newInstance();
        if (oldParser instanceof StructuredDocumentRegionParserExtension && newParser instanceof StructuredDocumentRegionParserExtension) {
            List oldHandlers = ((StructuredDocumentRegionParserExtension)oldParser).getStructuredDocumentRegionHandlers();
            i = 0;
            while (i < oldHandlers.size()) {
                StructuredDocumentRegionHandler handler = (StructuredDocumentRegionHandler)oldHandlers.get(i);
                if (!(handler instanceof StructuredDocumentRegionHandlerExtension)) {
                    ((StructuredDocumentRegionParser)oldParser).removeStructuredDocumentRegionHandler(handler);
                    ((StructuredDocumentRegionParser)newParser).addStructuredDocumentRegionHandler(handler);
                    handler.resetNodes();
                }
                ++i;
            }
        }
        if (oldParser instanceof BlockTagParser && newParser instanceof BlockTagParser) {
            List oldBlockMarkers = ((BlockTagParser)((Object)oldParser)).getBlockMarkers();
            i = 0;
            while (i < oldBlockMarkers.size()) {
                BlockMarker blockMarker = (BlockMarker)oldBlockMarkers.get(i);
                if (blockMarker.isGlobal()) {
                    ((BlockTagParser)((Object)newParser)).addBlockMarker(blockMarker);
                }
                ++i;
            }
        }
        ((BasicStructuredDocument)oldInstance).setParser(newParser);
        ((BasicStructuredDocument)oldInstance).setReParser(newInstance.getReParser().newInstance());
        if (newInstance.getDocumentPartitioner() instanceof StructuredTextPartitioner) {
            StructuredTextPartitioner partitioner = null;
            if (oldInstance instanceof IDocumentExtension3 && newInstance instanceof IDocumentExtension3) {
                partitioner = (StructuredTextPartitioner)((IDocumentExtension3)newInstance).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
                if (partitioner != null) {
                    partitioner = (StructuredTextPartitioner)partitioner.newInstance();
                }
                ((IDocumentExtension3)oldInstance).setDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning", (IDocumentPartitioner)partitioner);
            }
            if (partitioner == null) {
                partitioner = (StructuredTextPartitioner)((StructuredTextPartitioner)newInstance.getDocumentPartitioner()).newInstance();
                oldInstance.setDocumentPartitioner(partitioner);
            }
            if (partitioner != null) {
                partitioner.connect(oldInstance);
            }
        }
        String existingLineDelimiter = null;
        try {
            existingLineDelimiter = newInstance.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {
            existingLineDelimiter = System.getProperty("line.separator");
        }
        oldInstance.setLineDelimiter(existingLineDelimiter);
        if (newInstance.getEncodingMemento() != null) {
            oldInstance.setEncodingMemento((EncodingMemento)newInstance.getEncodingMemento().clone());
        }
        if (oldParser instanceof StructuredDocumentRegionParserExtension && newParser instanceof StructuredDocumentRegionParserExtension) {
            List oldHandlers = ((StructuredDocumentRegionParserExtension)oldParser).getStructuredDocumentRegionHandlers();
            int i2 = 0;
            while (i2 < oldHandlers.size()) {
                StructuredDocumentRegionHandler handler = (StructuredDocumentRegionHandler)oldHandlers.get(i2);
                if (handler instanceof StructuredDocumentRegionHandlerExtension) {
                    StructuredDocumentRegionHandlerExtension handlerExtension = (StructuredDocumentRegionHandlerExtension)handler;
                    handlerExtension.setStructuredDocument(oldInstance);
                }
                ++i2;
            }
        }
        String holdString = newInstance.get();
        newInstance = null;
        oldInstance.set(holdString);
    }
}

