/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CTypedef
extends PlatformObject
implements ITypedef,
ITypeContainer,
ICInternalBinding {
    private final IASTName name;
    private IType type = null;

    public CTypedef(IASTName name) {
        this.name = name;
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.name;
    }

    @Override
    public IType getType() {
        if (this.type == null && this.name.getParent() instanceof IASTDeclarator) {
            this.type = CVisitor.createType((IASTDeclarator)this.name.getParent());
        }
        return this.type;
    }

    @Override
    public void setType(IType t) {
        this.type = t;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.name.toCharArray();
    }

    @Override
    public IScope getScope() {
        IASTDeclarator declarator = (IASTDeclarator)this.name.getParent();
        return CVisitor.getContainingScope(declarator.getParent());
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public boolean isSameType(IType t) {
        if (t == this) {
            return true;
        }
        if (t instanceof ITypedef) {
            IType temp = this.getType();
            if (temp != null) {
                return temp.isSameType(((ITypedef)t).getType());
            }
            return false;
        }
        IType temp = this.getType();
        if (temp != null) {
            return temp.isSameType(t);
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return IASTNode.EMPTY_NODE_ARRAY;
    }

    @Override
    public IASTNode getDefinition() {
        return this.name;
    }

    @Override
    public IBinding getOwner() {
        return CVisitor.findEnclosingFunction(this.name);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " -> " + ASTTypeUtil.getType(this, true);
    }
}

