/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolCreateForeignKeyDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class ExasolForeignKeyManager
extends SQLForeignKeyManager<ExasolTableForeignKey, ExasolTable>
implements DBEObjectRenamer<ExasolTableForeignKey> {
    public DBSObjectCache<? extends DBSObject, ExasolTableForeignKey> getObjectsCache(ExasolTableForeignKey object) {
        ExasolTable parent = (ExasolTable)object.getParentObject();
        return ((ExasolSchema)parent.getContainer()).getAssociationCache();
    }

    protected ExasolTableForeignKey createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        final ExasolTable table = (ExasolTable)container;
        final ExasolTableForeignKey foreignKey = new ExasolTableForeignKey(table, null, true, "FK");
        foreignKey.setName(this.getNewConstraintName(monitor, foreignKey));
        return (ExasolTableForeignKey)((Object)new UITask<ExasolTableForeignKey>(){

            protected ExasolTableForeignKey runTask() {
                ExasolCreateForeignKeyDialog editPage = new ExasolCreateForeignKeyDialog("Create Foreign Key", foreignKey);
                if (!editPage.edit()) {
                    return null;
                }
                ArrayList<ExasolTableKeyColumn> columns = new ArrayList<ExasolTableKeyColumn>();
                int cnt = 0;
                for (EditForeignKeyPage.FKColumnInfo column : editPage.getColumns()) {
                    try {
                        columns.add(new ExasolTableKeyColumn((AbstractTableConstraint<ExasolTable>)foreignKey, table.getAttribute(monitor, column.getOwnColumn().getName()), ++cnt));
                    }
                    catch (DBException dBException) {
                        log.error((Object)"Could not get Attribute Information from Table");
                        return null;
                    }
                }
                foreignKey.setName(editPage.getName());
                foreignKey.setReferencedConstraint((ExasolTableUniqueKey)editPage.getUniqueConstraint());
                foreignKey.setEnabled(editPage.isEnabled());
                foreignKey.setColumns(columns);
                return foreignKey;
            }
        }.execute());
    }

    protected String getDropForeignKeyPattern(ExasolTableForeignKey constraint) {
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)constraint.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " DROP CONSTRAINT " + DBUtils.getObjectFullName((DBPNamedObject)constraint, (DBPEvaluationContext)DBPEvaluationContext.DDL);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolTableForeignKey key = (ExasolTableForeignKey)command.getObject();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Foreign Key", ExasolUtils.getFKDdl(key, monitor)));
        }
        catch (DBException e) {
            log.error((Object)("Could not created DDL for Exasol FK: " + key.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            log.error((Object)e.getMessage());
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolTableForeignKey key = (ExasolTableForeignKey)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename FK", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)key.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolTableForeignKey constraint = (ExasolTableForeignKey)command.getObject();
        if (command.getProperties().containsKey("enabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter FK", "ALTER TABLE " + ((ExasolTable)constraint.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY CONSTRAINT " + constraint.getName() + " " + (constraint.getEnabled() != false ? "ENABLE" : "DISABLE")));
        }
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolTableForeignKey object, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    public void renameObject(DBECommandContext commandContext, ExasolTableForeignKey object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }
}

