/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardStub;

public class TaskConfigurationWizardDialog
extends ActiveWizardDialog {
    private static final Log log = Log.getLog(TaskConfigurationWizardDialog.class);
    private static final int SAVE_TASK_BTN_ID = 1000;
    private TaskConfigurationWizard nestedTaskWizard;
    private boolean taskCreateWizard;
    private TaskConfigurationWizardPageTask taskEditPage;

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard wizard) {
        this(window, wizard, null);
    }

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard wizard, IStructuredSelection selection) {
        super(window, (IWizard)wizard, selection);
        this.setFinishButtonLabel(UIMessages.button_start);
    }

    TaskConfigurationWizardDialog(IWorkbenchWindow window) {
        this(window, new TaskConfigurationWizardStub(), null);
    }

    protected TaskConfigurationWizard getWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    public int getShellStyle() {
        int shellStyle = 0xCF0 | TaskConfigurationWizardDialog.getDefaultOrientation();
        if (UIUtils.isInDialog()) {
            shellStyle |= 0x10000;
        }
        return shellStyle;
    }

    protected TaskConfigurationWizard getTaskWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createButton(parent, 1000, this.getWizard().isTaskEditor() ? "Save Task" : "New Task", false);
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ++((GridLayout)parent.getLayout()).numColumns;
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            this.getWizard().saveTask();
            return;
        }
        if (buttonId == 15 && this.getWizard() instanceof TaskConfigurationWizardStub && this.getCurrentPage() instanceof TaskConfigurationWizardPageTask) {
            this.taskCreateWizard = true;
            this.taskEditPage = (TaskConfigurationWizardPageTask)this.getCurrentPage();
            if (this.nestedTaskWizard == null) {
                try {
                    this.nestedTaskWizard = this.taskEditPage.getTaskWizard();
                    this.nestedTaskWizard.addPages();
                    this.setWizard((IWizard)this.nestedTaskWizard);
                }
                catch (Exception e) {
                    this.setErrorMessage("Configuration error: " + e.getMessage());
                    log.error((Object)("Can't create task " + this.taskEditPage.getSelectedTaskType().getName() + " configuration wizard"), (Throwable)e);
                    return;
                }
            }
            this.showPage(this.nestedTaskWizard.getStartingPage());
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        super.updateButtons();
        Button saveAsButton = this.getButton(1000);
        if (saveAsButton != null) {
            saveAsButton.setEnabled(this.getWizard().canFinish());
        }
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    TaskConfigurationWizardPageTask getTaskPage() {
        if (this.taskEditPage != null) {
            return this.taskEditPage;
        }
        IWizardPage[] pages = this.getWizard().getPages();
        if (pages.length > 0 && pages[0] instanceof TaskConfigurationWizardPageTask) {
            return (TaskConfigurationWizardPageTask)pages[0];
        }
        return null;
    }
}

