/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.ui.dnd.LocalObjectTransfer;

public class TabFolderReorder {
    private CTabItem dragItem;

    public TabFolderReorder(final CTabFolder folder) {
        DragSource source = new DragSource((Control)folder, 2);
        source.setTransfer(new Transfer[]{TabTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;

            public void dragStart(DragSourceEvent event) {
                Point point = folder.toControl(folder.getDisplay().getCursorLocation());
                TabFolderReorder.this.dragItem = folder.getItem(point);
                if (TabFolderReorder.this.dragItem == null) {
                    return;
                }
                Rectangle columnBounds = TabFolderReorder.this.dragItem.getBounds();
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
                GC gc = new GC((Drawable)folder);
                this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                event.image = this.dragImage;
                gc.dispose();
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = TabFolderReorder.this.dragItem;
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)folder, 2);
        dropTarget.setTransfer(new Transfer[]{TabTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    TabFolderReorder.this.moveTabs(folder, event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(folder, event) ? 0 : 2;
                event.feedback = 1;
            }

            private boolean isDropSupported(CTabFolder folder2, DropTargetEvent event) {
                if (TabFolderReorder.this.dragItem == null) {
                    return false;
                }
                Point point = folder2.toControl(folder2.getDisplay().getCursorLocation());
                return folder2.getItem(new Point(point.x, point.y)) != null;
            }
        });
    }

    private void moveTabs(CTabFolder folder, DropTargetEvent event) {
        Point point = folder.toControl(folder.getDisplay().getCursorLocation());
        CTabItem item = folder.getItem(new Point(point.x, point.y));
        if (item != null && this.dragItem != null) {
            Control dragControl = this.dragItem.getControl();
            String dragText = this.dragItem.getText();
            Image dragImage = this.dragItem.getImage();
            String dragToolTip = this.dragItem.getToolTipText();
            boolean dragShowClose = this.dragItem.getShowClose();
            Object dragData = this.dragItem.getData();
            this.dragItem.setText(item.getText());
            this.dragItem.setImage(item.getImage());
            this.dragItem.setToolTipText(item.getToolTipText());
            this.dragItem.setData(item.getData());
            this.dragItem.setShowClose(item.getShowClose());
            this.dragItem.setControl(item.getControl());
            item.setText(dragText);
            item.setImage(dragImage);
            item.setToolTipText(dragToolTip);
            item.setData(dragData);
            item.setShowClose(dragShowClose);
            item.setControl(dragControl);
            folder.setSelection(item);
        }
    }

    public static final class TabTransfer
    extends LocalObjectTransfer<CTabItem> {
        public static final TabTransfer INSTANCE = new TabTransfer();
        private static final String TYPE_NAME = "TabTransfer.CTabItem Transfer" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPEID = TabTransfer.registerType((String)TYPE_NAME);

        private TabTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }
    }
}

