'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

var _preRunMessage = require('../preRunMessage');

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
class BaseReporter {
  log(message) {
    process.stderr.write(message + '\n');
  }

  onRunStart(results, options) {
    (0, _preRunMessage.remove)(process.stderr);
  }

  onTestResult(test, testResult, results) {}

  onTestStart(test) {}

  onRunComplete(contexts, aggregatedResults) {}

  _setError(error) {
    this._error = error;
  } // Return an error that occurred during reporting. This error will
  // define whether the test run was successful or failed.

  getLastError() {
    return this._error;
  }
}

exports.default = BaseReporter;
