'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.run = run;
exports.buildArgv = exports.runCLI = void 0;

function _path() {
  const data = _interopRequireDefault(require('path'));

  _path = function _path() {
    return data;
  };

  return data;
}

function _jestUtil() {
  const data = require('jest-util');

  _jestUtil = function _jestUtil() {
    return data;
  };

  return data;
}

function _jestValidate() {
  const data = require('jest-validate');

  _jestValidate = function _jestValidate() {
    return data;
  };

  return data;
}

function _jestConfig() {
  const data = require('jest-config');

  _jestConfig = function _jestConfig() {
    return data;
  };

  return data;
}

var args = _interopRequireWildcard(require('./args'));

function _chalk() {
  const data = _interopRequireDefault(require('chalk'));

  _chalk = function _chalk() {
    return data;
  };

  return data;
}

var _create_context = _interopRequireDefault(require('../lib/create_context'));

function _exit() {
  const data = _interopRequireDefault(require('exit'));

  _exit = function _exit() {
    return data;
  };

  return data;
}

var _getChangedFilesPromise = _interopRequireDefault(
  require('../getChangedFilesPromise')
);

var _collectHandles = require('../collectHandles');

var _handle_deprecation_warnings = _interopRequireDefault(
  require('../lib/handle_deprecation_warnings')
);

var _preRunMessage = require('../preRunMessage');

var _runJest = _interopRequireDefault(require('../runJest'));

function _jestRuntime() {
  const data = _interopRequireDefault(require('jest-runtime'));

  _jestRuntime = function _jestRuntime() {
    return data;
  };

  return data;
}

var _TestWatcher = _interopRequireDefault(require('../TestWatcher'));

var _watch = _interopRequireDefault(require('../watch'));

var _pluralize = _interopRequireDefault(require('../pluralize'));

function _yargs() {
  const data = _interopRequireDefault(require('yargs'));

  _yargs = function _yargs() {
    return data;
  };

  return data;
}

function _rimraf() {
  const data = _interopRequireDefault(require('rimraf'));

  _rimraf = function _rimraf() {
    return data;
  };

  return data;
}

function _realpathNative() {
  const data = require('realpath-native');

  _realpathNative = function _realpathNative() {
    return data;
  };

  return data;
}

var _init = _interopRequireDefault(require('../lib/init'));

var _log_debug_messages = _interopRequireDefault(
  require('../lib/log_debug_messages')
);

var _version = _interopRequireDefault(require('../version'));

function _interopRequireWildcard(obj) {
  if (obj && obj.__esModule) {
    return obj;
  } else {
    var newObj = {};
    if (obj != null) {
      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc =
            Object.defineProperty && Object.getOwnPropertyDescriptor
              ? Object.getOwnPropertyDescriptor(obj, key)
              : {};
          if (desc.get || desc.set) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }
    newObj.default = obj;
    return newObj;
  }
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);
    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(
        Object.getOwnPropertySymbols(source).filter(function(sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        })
      );
    }
    ownKeys.forEach(function(key) {
      _defineProperty(target, key, source[key]);
    });
  }
  return target;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function() {
    var self = this,
      args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'next', value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'throw', err);
      }
      _next(undefined);
    });
  };
}

function run(_x, _x2) {
  return _run2.apply(this, arguments);
}

function _run2() {
  _run2 = _asyncToGenerator(function*(maybeArgv, project) {
    try {
      // $FlowFixMe:`allow reduced return
      const argv = buildArgv(maybeArgv, project);

      if (argv.init) {
        yield (0, _init.default)();
        return;
      }

      const projects = getProjectListFromCLIArgs(argv, project);

      const _ref9 = yield runCLI(argv, projects),
        results = _ref9.results,
        globalConfig = _ref9.globalConfig;

      readResultsAndExit(results, globalConfig);
    } catch (error) {
      (0, _jestUtil().clearLine)(process.stderr);
      (0, _jestUtil().clearLine)(process.stdout);
      console.error(_chalk().default.red(error.stack));
      (0, _exit().default)(1);
      throw error;
    }
  });
  return _run2.apply(this, arguments);
}

const runCLI =
  /*#__PURE__*/
  (function() {
    var _ref = _asyncToGenerator(function*(argv, projects) {
      const realFs = require('fs');

      const fs = require('graceful-fs');

      fs.gracefulify(realFs);
      let results; // If we output a JSON object, we can't write anything to stdout, since
      // it'll break the JSON structure and it won't be valid.

      const outputStream =
        argv.json || argv.useStderr ? process.stderr : process.stdout;

      const _readConfigs = (0, _jestConfig().readConfigs)(argv, projects),
        globalConfig = _readConfigs.globalConfig,
        configs = _readConfigs.configs,
        hasDeprecationWarnings = _readConfigs.hasDeprecationWarnings;

      if (argv.debug) {
        (0, _log_debug_messages.default)(globalConfig, configs, outputStream);
      }

      if (argv.showConfig) {
        (0, _log_debug_messages.default)(globalConfig, configs, process.stdout);
        (0, _exit().default)(0);
      }

      if (argv.clearCache) {
        configs.forEach(config => {
          _rimraf().default.sync(config.cacheDirectory);

          process.stdout.write(`Cleared ${config.cacheDirectory}\n`);
        });
        (0, _exit().default)(0);
      }

      yield _run(
        globalConfig,
        configs,
        hasDeprecationWarnings,
        outputStream,
        r => (results = r)
      );

      if (argv.watch || argv.watchAll) {
        // If in watch mode, return the promise that will never resolve.
        // If the watch mode is interrupted, watch should handle the process
        // shutdown.
        return new Promise(() => {});
      }

      if (!results) {
        throw new Error(
          'AggregatedResult must be present after test run is complete'
        );
      }

      const _results = results,
        openHandles = _results.openHandles;

      if (openHandles && openHandles.length) {
        const formatted = (0, _collectHandles.formatHandleErrors)(
          openHandles,
          configs[0]
        );
        const openHandlesString = (0, _pluralize.default)(
          'open handle',
          formatted.length,
          's'
        );
        const message =
          _chalk().default.red(
            `\nJest has detected the following ${openHandlesString} potentially keeping Jest from exiting:\n\n`
          ) + formatted.join('\n\n');
        console.error(message);
      }

      return Promise.resolve({
        globalConfig,
        results
      });
    });

    return function runCLI(_x3, _x4) {
      return _ref.apply(this, arguments);
    };
  })();

exports.runCLI = runCLI;

const readResultsAndExit = (result, globalConfig) => {
  const code = !result || result.success ? 0 : globalConfig.testFailureExitCode; // Only exit if needed

  process.on('exit', () => {
    if (typeof code === 'number' && code !== 0) {
      process.exitCode = code;
    }
  });

  if (globalConfig.forceExit) {
    if (!globalConfig.detectOpenHandles) {
      console.error(
        _chalk().default.red.bold('Force exiting Jest\n\n') +
          _chalk().default.red(
            'Have you considered using `--detectOpenHandles` to detect ' +
              'async operations that kept running after all tests finished?'
          )
      );
    }

    (0, _exit().default)(code);
  } else if (!globalConfig.detectOpenHandles) {
    setTimeout(() => {
      console.error(
        _chalk().default.red.bold(
          'Jest did not exit one second after the test run has completed.\n\n'
        ) +
          _chalk().default.red(
            'This usually means that there are asynchronous operations that ' +
              "weren't stopped in your tests. Consider running Jest with " +
              '`--detectOpenHandles` to troubleshoot this issue.'
          )
      ); // $FlowFixMe: `unref` exists in Node
    }, 1000).unref();
  }
};

const buildArgv = (maybeArgv, project) => {
  const version =
    (0, _version.default)() +
    (__dirname.includes(`packages${_path().default.sep}jest-cli`)
      ? '-dev'
      : '');
  const rawArgv = maybeArgv || process.argv.slice(2);
  const argv = (0, _yargs().default)(rawArgv)
    .usage(args.usage)
    .version(version)
    .alias('help', 'h')
    .options(args.options)
    .epilogue(args.docs)
    .check(args.check).argv;
  (0, _jestValidate().validateCLIOptions)(
    argv,
    _objectSpread({}, args.options, {
      deprecationEntries: _jestConfig().deprecationEntries
    }), // strip leading dashes
    Array.isArray(rawArgv)
      ? rawArgv.map(rawArgv => rawArgv.replace(/^--?/, ''))
      : Object.keys(rawArgv)
  ); // strip dashed args

  return Object.keys(argv).reduce((result, key) => {
    if (!key.includes('-')) {
      // $FlowFixMe:`allow reduced return
      result[key] = argv[key];
    }

    return result;
  }, {});
};

exports.buildArgv = buildArgv;

const getProjectListFromCLIArgs = (argv, project) => {
  const projects = argv.projects ? argv.projects : [];

  if (project) {
    projects.push(project);
  }

  if (!projects.length && process.platform === 'win32') {
    try {
      projects.push((0, _realpathNative().sync)(process.cwd()));
    } catch (err) {
      // do nothing, just catch error
      // process.binding('fs').realpath can throw, e.g. on mapped drives
    }
  }

  if (!projects.length) {
    projects.push(process.cwd());
  }

  return projects;
};

const buildContextsAndHasteMaps =
  /*#__PURE__*/
  (function() {
    var _ref2 = _asyncToGenerator(function*(
      configs,
      globalConfig,
      outputStream
    ) {
      const hasteMapInstances = Array(configs.length);
      const contexts = yield Promise.all(
        configs.map(
          /*#__PURE__*/
          (function() {
            var _ref3 = _asyncToGenerator(function*(config, index) {
              (0, _jestUtil().createDirectory)(config.cacheDirectory);

              const hasteMapInstance = _jestRuntime().default.createHasteMap(
                config,
                {
                  console: new (_jestUtil()).Console(
                    outputStream,
                    outputStream
                  ),
                  maxWorkers: globalConfig.maxWorkers,
                  resetCache: !config.cache,
                  watch: globalConfig.watch || globalConfig.watchAll,
                  watchman: globalConfig.watchman
                }
              );

              hasteMapInstances[index] = hasteMapInstance;
              return (0,
              _create_context.default)(config, yield hasteMapInstance.build());
            });

            return function(_x8, _x9) {
              return _ref3.apply(this, arguments);
            };
          })()
        )
      );
      return {
        contexts,
        hasteMapInstances
      };
    });

    return function buildContextsAndHasteMaps(_x5, _x6, _x7) {
      return _ref2.apply(this, arguments);
    };
  })();

const _run =
  /*#__PURE__*/
  (function() {
    var _ref4 = _asyncToGenerator(function*(
      globalConfig,
      configs,
      hasDeprecationWarnings,
      outputStream,
      onComplete
    ) {
      // Queries to hg/git can take a while, so we need to start the process
      // as soon as possible, so by the time we need the result it's already there.
      const changedFilesPromise = (0, _getChangedFilesPromise.default)(
        globalConfig,
        configs
      );

      const _ref5 = yield buildContextsAndHasteMaps(
          configs,
          globalConfig,
          outputStream
        ),
        contexts = _ref5.contexts,
        hasteMapInstances = _ref5.hasteMapInstances;

      globalConfig.watch || globalConfig.watchAll
        ? yield runWatch(
            contexts,
            configs,
            hasDeprecationWarnings,
            globalConfig,
            outputStream,
            hasteMapInstances,
            changedFilesPromise
          )
        : yield runWithoutWatch(
            globalConfig,
            contexts,
            outputStream,
            onComplete,
            changedFilesPromise
          );
    });

    return function _run(_x10, _x11, _x12, _x13, _x14) {
      return _ref4.apply(this, arguments);
    };
  })();

const runWatch =
  /*#__PURE__*/
  (function() {
    var _ref6 = _asyncToGenerator(function*(
      contexts,
      configs,
      hasDeprecationWarnings,
      globalConfig,
      outputStream,
      hasteMapInstances,
      changedFilesPromise
    ) {
      if (hasDeprecationWarnings) {
        try {
          yield (0, _handle_deprecation_warnings.default)(
            outputStream,
            process.stdin
          );
          return (0, _watch.default)(
            globalConfig,
            contexts,
            outputStream,
            hasteMapInstances
          );
        } catch (e) {
          (0, _exit().default)(0);
        }
      }

      return (0, _watch.default)(
        globalConfig,
        contexts,
        outputStream,
        hasteMapInstances
      );
    });

    return function runWatch(_x15, _x16, _x17, _x18, _x19, _x20, _x21) {
      return _ref6.apply(this, arguments);
    };
  })();

const runWithoutWatch =
  /*#__PURE__*/
  (function() {
    var _ref7 = _asyncToGenerator(function*(
      globalConfig,
      contexts,
      outputStream,
      onComplete,
      changedFilesPromise
    ) {
      const startRun =
        /*#__PURE__*/
        (function() {
          var _ref8 = _asyncToGenerator(function*() {
            if (!globalConfig.listTests) {
              (0, _preRunMessage.print)(outputStream);
            }

            return yield (0, _runJest.default)({
              changedFilesPromise,
              contexts,
              failedTestsCache: null,
              globalConfig,
              onComplete,
              outputStream,
              startRun,
              testWatcher: new _TestWatcher.default({
                isWatchMode: false
              })
            });
          });

          return function startRun() {
            return _ref8.apply(this, arguments);
          };
        })();

      return yield startRun();
    });

    return function runWithoutWatch(_x22, _x23, _x24, _x25, _x26) {
      return _ref7.apply(this, arguments);
    };
  })();
