'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.findSiblingsWithFileExtension = exports.enhanceUnexpectedTokenMessage = void 0;

function _path() {
  const data = _interopRequireDefault(require('path'));

  _path = function _path() {
    return data;
  };

  return data;
}

function _chalk() {
  const data = _interopRequireDefault(require('chalk'));

  _chalk = function _chalk() {
    return data;
  };

  return data;
}

function _slash() {
  const data = _interopRequireDefault(require('slash'));

  _slash = function _slash() {
    return data;
  };

  return data;
}

function _glob() {
  const data = _interopRequireDefault(require('glob'));

  _glob = function _glob() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

// Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
const DOT = ' \u2022 ';

const enhanceUnexpectedTokenMessage = e => {
  e.stack =
    `${_chalk().default.bold.red('Jest encountered an unexpected token')}

This usually means that you are trying to import a file which Jest cannot parse, e.g. it's not plain JavaScript.

By default, if Jest sees a Babel config, it will use that to transform your files, ignoring "node_modules".

Here's what you can do:
${DOT}To have some of your "node_modules" files transformed, you can specify a custom ${_chalk().default.bold(
      '"transformIgnorePatterns"'
    )} in your config.
${DOT}If you need a custom transformation specify a ${_chalk().default.bold(
      '"transform"'
    )} option in your config.
${DOT}If you simply want to mock your non-JS modules (e.g. binary assets) you can stub them out with the ${_chalk().default.bold(
      '"moduleNameMapper"'
    )} config option.

You'll find more details and examples of these config options in the docs:
${_chalk().default.cyan('https://jestjs.io/docs/en/configuration.html')}

${_chalk().default.bold.red('Details:')}

` + e.stack;
  return e;
};

exports.enhanceUnexpectedTokenMessage = enhanceUnexpectedTokenMessage;

const findSiblingsWithFileExtension = (
  moduleFileExtensions,
  from,
  moduleName
) => {
  if (
    !_path().default.isAbsolute(moduleName) &&
    _path().default.extname(moduleName) === ''
  ) {
    const dirname = _path().default.dirname(from);

    const pathToModule = _path().default.resolve(dirname, moduleName);

    try {
      const slashedDirname = (0, _slash().default)(dirname);

      const matches = _glob()
        .default.sync(`${pathToModule}.*`)
        .map(match => (0, _slash().default)(match))
        .map(match => {
          const relativePath = _path().default.posix.relative(
            slashedDirname,
            match
          );

          return _path().default.posix.dirname(match) === slashedDirname
            ? `./${relativePath}`
            : relativePath;
        })
        .map(match => `\t'${match}'`)
        .join('\n');

      if (matches) {
        const foundMessage = `\n\nHowever, Jest was able to find:\n${matches}`;
        const mappedModuleFileExtensions = moduleFileExtensions
          .map(ext => `'${ext}'`)
          .join(', ');
        return (
          foundMessage +
          "\n\nYou might want to include a file extension in your import, or update your 'moduleFileExtensions', which is currently " +
          `[${mappedModuleFileExtensions}].\n\nSee https://jestjs.io/docs/en/configuration#modulefileextensions-array-string`
        );
      }
    } catch (ignored) {}
  }

  return '';
};

exports.findSiblingsWithFileExtension = findSiblingsWithFileExtension;
