'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _util() {
  const data = _interopRequireDefault(require('util'));

  _util = function _util() {
    return data;
  };

  return data;
}

function _chalk() {
  const data = _interopRequireDefault(require('chalk'));

  _chalk = function _chalk() {
    return data;
  };

  return data;
}

function _prettyFormat() {
  const data = _interopRequireDefault(require('pretty-format'));

  _prettyFormat = function _prettyFormat() {
    return data;
  };

  return data;
}

function _jestGetType() {
  const data = _interopRequireDefault(require('jest-get-type'));

  _jestGetType = function _jestGetType() {
    return data;
  };

  return data;
}

function _jestUtil() {
  const data = require('jest-util');

  _jestUtil = function _jestUtil() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
const EXPECTED_COLOR = _chalk().default.green;

const RECEIVED_COLOR = _chalk().default.red;

const SUPPORTED_PLACEHOLDERS = /%[sdifjoOp%]/g;
const PRETTY_PLACEHOLDER = '%p';
const INDEX_PLACEHOLDER = '%#';
const PRIMITIVES = new Set([
  'string',
  'number',
  'boolean',
  'null',
  'undefined'
]);

var _default = (cb, supportsDone = true) => (...args) =>
  function eachBind(title, test, timeout) {
    if (args.length === 1) {
      const tableArg = args[0];

      if (!Array.isArray(tableArg)) {
        const error = new (_jestUtil()).ErrorWithStack(
          '`.each` must be called with an Array or Tagged Template Literal.\n\n' +
            `Instead was called with: ${(0, _prettyFormat().default)(tableArg, {
              maxDepth: 1,
              min: true
            })}\n`,
          eachBind
        );
        return cb(title, () => {
          throw error;
        });
      }

      if (isTaggedTemplateLiteral(tableArg)) {
        if (isEmptyString(tableArg[0])) {
          const error = new (_jestUtil()).ErrorWithStack(
            'Error: `.each` called with an empty Tagged Template Literal of table data.\n',
            eachBind
          );
          return cb(title, () => {
            throw error;
          });
        }

        const error = new (_jestUtil()).ErrorWithStack(
          'Error: `.each` called with a Tagged Template Literal with no data, remember to interpolate with ${expression} syntax.\n',
          eachBind
        );
        return cb(title, () => {
          throw error;
        });
      }

      if (isEmptyTable(tableArg)) {
        const error = new (_jestUtil()).ErrorWithStack(
          'Error: `.each` called with an empty Array of table data.\n',
          eachBind
        );
        return cb(title, () => {
          throw error;
        });
      }

      const table = tableArg.every(Array.isArray)
        ? tableArg
        : tableArg.map(entry => [entry]);
      return table.forEach((row, i) =>
        cb(
          arrayFormat(title, i, ...row),
          applyRestParams(supportsDone, row, test),
          timeout
        )
      );
    }

    const templateStrings = args[0];
    const data = args.slice(1);
    const keys = getHeadingKeys(templateStrings[0]);
    const table = buildTable(data, keys.length, keys);
    const missingData = data.length % keys.length;

    if (missingData > 0) {
      const error = new (_jestUtil()).ErrorWithStack(
        'Not enough arguments supplied for given headings:\n' +
          EXPECTED_COLOR(keys.join(' | ')) +
          '\n\n' +
          'Received:\n' +
          RECEIVED_COLOR((0, _prettyFormat().default)(data)) +
          '\n\n' +
          `Missing ${RECEIVED_COLOR(missingData.toString())} ${pluralize(
            'argument',
            missingData
          )}`,
        eachBind
      );
      return cb(title, () => {
        throw error;
      });
    }

    return table.forEach(row =>
      cb(
        interpolate(title, row),
        applyObjectParams(supportsDone, row, test),
        timeout
      )
    );
  };

exports.default = _default;

const isTaggedTemplateLiteral = array => array.raw !== undefined;

const isEmptyTable = table => table.length === 0;

const isEmptyString = str => typeof str === 'string' && str.trim() === '';

const getPrettyIndexes = placeholders =>
  placeholders.reduce((indexes, placeholder, index) => {
    if (placeholder === PRETTY_PLACEHOLDER) {
      indexes.push(index);
    }

    return indexes;
  }, []);

const arrayFormat = (title, rowIndex, ...args) => {
  const placeholders = title.match(SUPPORTED_PLACEHOLDERS) || [];
  const prettyIndexes = getPrettyIndexes(placeholders);

  const _args$reduce = args.reduce(
      (acc, arg, index) => {
        if (prettyIndexes.indexOf(index) !== -1) {
          return {
            args: acc.args,
            title: acc.title.replace(
              PRETTY_PLACEHOLDER,
              (0, _prettyFormat().default)(arg, {
                maxDepth: 1,
                min: true
              })
            )
          };
        }

        return {
          args: acc.args.concat([arg]),
          title: acc.title
        };
      },
      {
        args: [],
        title
      }
    ),
    prettyTitle = _args$reduce.title,
    remainingArgs = _args$reduce.args;

  return _util().default.format(
    prettyTitle.replace(INDEX_PLACEHOLDER, rowIndex.toString()),
    ...remainingArgs.slice(0, placeholders.length - prettyIndexes.length)
  );
};

const applyRestParams = (supportsDone, params, test) =>
  supportsDone && params.length < test.length
    ? done => test(...params, done)
    : () => test(...params);

const getHeadingKeys = headings => headings.replace(/\s/g, '').split('|');

const buildTable = (data, rowSize, keys) =>
  Array.from({
    length: data.length / rowSize
  })
    .map((_, index) => data.slice(index * rowSize, index * rowSize + rowSize))
    .map(row =>
      row.reduce(
        (acc, value, index) =>
          Object.assign(acc, {
            [keys[index]]: value
          }),
        {}
      )
    );

const getMatchingKeyPaths = title => (matches, key) =>
  matches.concat(title.match(new RegExp(`\\$${key}[\\.\\w]*`, 'g')) || []);

const replaceKeyPathWithValue = data => (title, match) => {
  const keyPath = match.replace('$', '').split('.');
  const value = getPath(data, keyPath);
  const valueType = (0, _jestGetType().default)(value);

  if (PRIMITIVES.has(valueType)) {
    return title.replace(match, value);
  }

  return title.replace(
    match,
    (0, _prettyFormat().default)(value, {
      maxDepth: 1,
      min: true
    })
  );
};

const interpolate = (title, data) =>
  Object.keys(data)
    .reduce(getMatchingKeyPaths(title), []) // aka flatMap
    .reduce(replaceKeyPathWithValue(data), title);

const applyObjectParams = (supportsDone, obj, test) =>
  supportsDone && test.length > 1 ? done => test(obj, done) : () => test(obj);

const pluralize = (word, count) => word + (count === 1 ? '' : 's');

const getPath = (o, [head, ...tail]) => {
  if (!head || !o.hasOwnProperty || !o.hasOwnProperty(head)) return o;
  return getPath(o[head], tail);
};
