/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { compileInjectable as render3CompileInjectable } from '../render3/jit/injectable';
import { makeDecorator } from '../util/decorators';
import { defineInjectable, getInjectableDef } from './defs';
import { convertInjectableProviderToFactory } from './util';
/**
 * Type of the Injectable decorator / constructor function.
 *
 * \@publicApi
 * @record
 */
export function InjectableDecorator() { }
// WARNING: interface has both a type and a value, skipping emit
/**
 * Injectable decorator and metadata.
 *
 * \@Annotation
 * \@publicApi
 * @type {?}
 */
export const Injectable = makeDecorator('Injectable', undefined, undefined, undefined, (type, meta) => SWITCH_COMPILE_INJECTABLE((/** @type {?} */ (type)), meta));
/**
 * Type representing injectable service.
 *
 * \@publicApi
 * @record
 * @template T
 */
export function InjectableType() { }
if (false) {
    /** @type {?} */
    InjectableType.prototype.ngInjectableDef;
}
/**
 * Supports \@Injectable() in JIT mode for Render2.
 * @param {?} injectableType
 * @param {?} options
 * @return {?}
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        /** @nocollapse */ injectableType.ngInjectableDef = defineInjectable({
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
/** @type {?} */
export const SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
/** @type {?} */
const SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
/** @type {?} */
const SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5qZWN0YWJsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL2RpL2luamVjdGFibGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7QUFRQSxPQUFPLEVBQUMsaUJBQWlCLElBQUksd0JBQXdCLEVBQUMsTUFBTSwyQkFBMkIsQ0FBQztBQUV4RixPQUFPLEVBQWdCLGFBQWEsRUFBQyxNQUFNLG9CQUFvQixDQUFDO0FBRWhFLE9BQU8sRUFBZ0MsZ0JBQWdCLEVBQUUsZ0JBQWdCLEVBQUMsTUFBTSxRQUFRLENBQUM7QUFFekYsT0FBTyxFQUFDLGtDQUFrQyxFQUFDLE1BQU0sUUFBUSxDQUFDOzs7Ozs7O0FBZ0IxRCx5Q0F3QkM7Ozs7Ozs7OztBQXVCRCxNQUFNLE9BQU8sVUFBVSxHQUF3QixhQUFhLENBQ3hELFlBQVksRUFBRSxTQUFTLEVBQUUsU0FBUyxFQUFFLFNBQVMsRUFDN0MsQ0FBQyxJQUFlLEVBQUUsSUFBZ0IsRUFBRSxFQUFFLENBQUMseUJBQXlCLENBQUMsbUJBQUEsSUFBSSxFQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7Ozs7Ozs7O0FBT3hGLG9DQUF5Rjs7O0lBQXBDLHlDQUFrQzs7Ozs7Ozs7QUFLdkYsU0FBUyx3QkFBd0IsQ0FDN0IsY0FBbUMsRUFDbkMsT0FBcUU7SUFDdkUsSUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLFVBQVUsS0FBSyxTQUFTLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUMsRUFBRTtRQUNwRixjQUFjLENBQUMsZUFBZSxHQUFHLGdCQUFnQixDQUFDO1lBQ2hELFVBQVUsRUFBRSxPQUFPLENBQUMsVUFBVTtZQUM5QixPQUFPLEVBQUUsa0NBQWtDLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQztTQUNyRSxDQUFDLENBQUM7S0FDSjtBQUNILENBQUM7O0FBRUQsTUFBTSxPQUFPLG9DQUFvQyxHQUFHLHdCQUF3Qjs7TUFDdEUsbUNBQW1DLEdBQUcsd0JBQXdCOztNQUM5RCx5QkFBeUIsR0FDM0IsbUNBQW1DIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge2NvbXBpbGVJbmplY3RhYmxlIGFzIHJlbmRlcjNDb21waWxlSW5qZWN0YWJsZX0gZnJvbSAnLi4vcmVuZGVyMy9qaXQvaW5qZWN0YWJsZSc7XG5pbXBvcnQge1R5cGV9IGZyb20gJy4uL3R5cGUnO1xuaW1wb3J0IHtUeXBlRGVjb3JhdG9yLCBtYWtlRGVjb3JhdG9yfSBmcm9tICcuLi91dGlsL2RlY29yYXRvcnMnO1xuXG5pbXBvcnQge0luamVjdGFibGVEZWYsIEluamVjdGFibGVUeXBlLCBkZWZpbmVJbmplY3RhYmxlLCBnZXRJbmplY3RhYmxlRGVmfSBmcm9tICcuL2RlZnMnO1xuaW1wb3J0IHtDbGFzc1NhbnNQcm92aWRlciwgQ29uc3RydWN0b3JTYW5zUHJvdmlkZXIsIEV4aXN0aW5nU2Fuc1Byb3ZpZGVyLCBGYWN0b3J5U2Fuc1Byb3ZpZGVyLCBTdGF0aWNDbGFzc1NhbnNQcm92aWRlciwgVmFsdWVTYW5zUHJvdmlkZXJ9IGZyb20gJy4vcHJvdmlkZXInO1xuaW1wb3J0IHtjb252ZXJ0SW5qZWN0YWJsZVByb3ZpZGVyVG9GYWN0b3J5fSBmcm9tICcuL3V0aWwnO1xuXG5cbi8qKlxuICogSW5qZWN0YWJsZSBwcm92aWRlcnMgdXNlZCBpbiBgQEluamVjdGFibGVgIGRlY29yYXRvci5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCB0eXBlIEluamVjdGFibGVQcm92aWRlciA9IFZhbHVlU2Fuc1Byb3ZpZGVyIHwgRXhpc3RpbmdTYW5zUHJvdmlkZXIgfFxuICAgIFN0YXRpY0NsYXNzU2Fuc1Byb3ZpZGVyIHwgQ29uc3RydWN0b3JTYW5zUHJvdmlkZXIgfCBGYWN0b3J5U2Fuc1Byb3ZpZGVyIHwgQ2xhc3NTYW5zUHJvdmlkZXI7XG5cbi8qKlxuICogVHlwZSBvZiB0aGUgSW5qZWN0YWJsZSBkZWNvcmF0b3IgLyBjb25zdHJ1Y3RvciBmdW5jdGlvbi5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5qZWN0YWJsZURlY29yYXRvciB7XG4gIC8qKlxuICAgKiBNYXJrcyBhIGNsYXNzIGFzIGF2YWlsYWJsZSB0byBgSW5qZWN0b3JgIGZvciBjcmVhdGlvbi5cbiAgICpcbiAgICogQHNlZSBbSW50cm9kdWN0aW9uIHRvIFNlcnZpY2VzIGFuZCBESV0oZ3VpZGUvYXJjaGl0ZWN0dXJlLXNlcnZpY2VzKVxuICAgKiBAc2VlIFtEZXBlbmRlbmN5IEluamVjdGlvbiBHdWlkZV0oZ3VpZGUvZGVwZW5kZW5jeS1pbmplY3Rpb24pXG4gICAqXG4gICAqIEB1c2FnZU5vdGVzXG4gICAqXG4gICAqIFRoZSBmb2xsb3dpbmcgZXhhbXBsZSBzaG93cyBob3cgc2VydmljZSBjbGFzc2VzIGFyZSBwcm9wZXJseSBtYXJrZWQgYXNcbiAgICogaW5qZWN0YWJsZS5cbiAgICpcbiAgICoge0BleGFtcGxlIGNvcmUvZGkvdHMvbWV0YWRhdGFfc3BlYy50cyByZWdpb249J0luamVjdGFibGUnfVxuICAgKlxuICAgKiBgSW5qZWN0b3JgIHRocm93cyBhbiBlcnJvciBpZiBpdCB0cmllcyB0byBpbnN0YW50aWF0ZSBhIGNsYXNzIHRoYXRcbiAgICogaXMgbm90IGRlY29yYXRlZCB3aXRoIGBASW5qZWN0YWJsZWAsIGFzIHNob3duIGluIHRoZSBmb2xsb3dpbmcgZXhhbXBsZS5cbiAgICpcbiAgICoge0BleGFtcGxlIGNvcmUvZGkvdHMvbWV0YWRhdGFfc3BlYy50cyByZWdpb249J0luamVjdGFibGVUaHJvd3MnfVxuICAgKlxuICAgKi9cbiAgKCk6IFR5cGVEZWNvcmF0b3I7XG4gIChvcHRpb25zPzoge3Byb3ZpZGVkSW46IFR5cGU8YW55PnwgJ3Jvb3QnIHwgbnVsbH0mSW5qZWN0YWJsZVByb3ZpZGVyKTogVHlwZURlY29yYXRvcjtcbiAgbmV3ICgpOiBJbmplY3RhYmxlO1xuICBuZXcgKG9wdGlvbnM/OiB7cHJvdmlkZWRJbjogVHlwZTxhbnk+fCAncm9vdCcgfCBudWxsfSZJbmplY3RhYmxlUHJvdmlkZXIpOiBJbmplY3RhYmxlO1xufVxuXG4vKipcbiAqIFR5cGUgb2YgdGhlIEluamVjdGFibGUgbWV0YWRhdGEuXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEluamVjdGFibGUge1xuICAvKipcbiAgICogRGV0ZXJtaW5lcyB3aGljaCBpbmplY3RvcnMgd2lsbCBwcm92aWRlIHRoZSBpbmplY3RhYmxlLFxuICAgKiBieSBlaXRoZXIgYXNzb2NpYXRpbmcgaXQgd2l0aCBhbiBATmdNb2R1bGUgb3Igb3RoZXIgYEluamVjdG9yVHlwZWAsXG4gICAqIG9yIGJ5IHNwZWNpZnlpbmcgdGhhdCB0aGlzIGluamVjdGFibGUgc2hvdWxkIGJlIHByb3ZpZGVkIGluIHRoZVxuICAgKiAncm9vdCcgaW5qZWN0b3IsIHdoaWNoIHdpbGwgYmUgdGhlIGFwcGxpY2F0aW9uLWxldmVsIGluamVjdG9yIGluIG1vc3QgYXBwcy5cbiAgICovXG4gIHByb3ZpZGVkSW4/OiBUeXBlPGFueT58J3Jvb3QnfG51bGw7XG59XG5cbi8qKlxuICogSW5qZWN0YWJsZSBkZWNvcmF0b3IgYW5kIG1ldGFkYXRhLlxuICpcbiAqIEBBbm5vdGF0aW9uXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBjb25zdCBJbmplY3RhYmxlOiBJbmplY3RhYmxlRGVjb3JhdG9yID0gbWFrZURlY29yYXRvcihcbiAgICAnSW5qZWN0YWJsZScsIHVuZGVmaW5lZCwgdW5kZWZpbmVkLCB1bmRlZmluZWQsXG4gICAgKHR5cGU6IFR5cGU8YW55PiwgbWV0YTogSW5qZWN0YWJsZSkgPT4gU1dJVENIX0NPTVBJTEVfSU5KRUNUQUJMRSh0eXBlIGFzIGFueSwgbWV0YSkpO1xuXG4vKipcbiAqIFR5cGUgcmVwcmVzZW50aW5nIGluamVjdGFibGUgc2VydmljZS5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5qZWN0YWJsZVR5cGU8VD4gZXh0ZW5kcyBUeXBlPFQ+IHsgbmdJbmplY3RhYmxlRGVmOiBJbmplY3RhYmxlRGVmPFQ+OyB9XG5cbi8qKlxuICogU3VwcG9ydHMgQEluamVjdGFibGUoKSBpbiBKSVQgbW9kZSBmb3IgUmVuZGVyMi5cbiAqL1xuZnVuY3Rpb24gcmVuZGVyMkNvbXBpbGVJbmplY3RhYmxlKFxuICAgIGluamVjdGFibGVUeXBlOiBJbmplY3RhYmxlVHlwZTxhbnk+LFxuICAgIG9wdGlvbnM6IHtwcm92aWRlZEluPzogVHlwZTxhbnk+fCAncm9vdCcgfCBudWxsfSAmIEluamVjdGFibGVQcm92aWRlcik6IHZvaWQge1xuICBpZiAob3B0aW9ucyAmJiBvcHRpb25zLnByb3ZpZGVkSW4gIT09IHVuZGVmaW5lZCAmJiAhZ2V0SW5qZWN0YWJsZURlZihpbmplY3RhYmxlVHlwZSkpIHtcbiAgICBpbmplY3RhYmxlVHlwZS5uZ0luamVjdGFibGVEZWYgPSBkZWZpbmVJbmplY3RhYmxlKHtcbiAgICAgIHByb3ZpZGVkSW46IG9wdGlvbnMucHJvdmlkZWRJbixcbiAgICAgIGZhY3Rvcnk6IGNvbnZlcnRJbmplY3RhYmxlUHJvdmlkZXJUb0ZhY3RvcnkoaW5qZWN0YWJsZVR5cGUsIG9wdGlvbnMpLFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBTV0lUQ0hfQ09NUElMRV9JTkpFQ1RBQkxFX19QT1NUX1IzX18gPSByZW5kZXIzQ29tcGlsZUluamVjdGFibGU7XG5jb25zdCBTV0lUQ0hfQ09NUElMRV9JTkpFQ1RBQkxFX19QUkVfUjNfXyA9IHJlbmRlcjJDb21waWxlSW5qZWN0YWJsZTtcbmNvbnN0IFNXSVRDSF9DT01QSUxFX0lOSkVDVEFCTEU6IHR5cGVvZiByZW5kZXIzQ29tcGlsZUluamVjdGFibGUgPVxuICAgIFNXSVRDSF9DT01QSUxFX0lOSkVDVEFCTEVfX1BSRV9SM19fO1xuIl19