"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const webpack_1 = require("@ngtools/webpack");
const common_1 = require("./common");
function _createAotPlugin(wco, options, _host, useMain = true, extract = false) {
    const { root, buildOptions } = wco;
    options.compilerOptions = options.compilerOptions || {};
    if (wco.buildOptions.preserveSymlinks) {
        options.compilerOptions.preserveSymlinks = true;
    }
    let i18nInFile = buildOptions.i18nFile
        ? path.resolve(root, buildOptions.i18nFile)
        : undefined;
    const i18nFileAndFormat = extract
        ? {
            i18nOutFile: buildOptions.i18nFile,
            i18nOutFormat: buildOptions.i18nFormat,
        } : {
        i18nInFile: i18nInFile,
        i18nInFormat: buildOptions.i18nFormat,
    };
    const additionalLazyModules = {};
    if (buildOptions.lazyModules) {
        for (const lazyModule of buildOptions.lazyModules) {
            additionalLazyModules[lazyModule] = path.resolve(root, lazyModule);
        }
    }
    const hostReplacementPaths = {};
    if (buildOptions.fileReplacements) {
        for (const replacement of buildOptions.fileReplacements) {
            hostReplacementPaths[replacement.replace] = replacement.with;
        }
    }
    const pluginOptions = Object.assign({ mainPath: useMain ? path.join(root, buildOptions.main) : undefined }, i18nFileAndFormat, { locale: buildOptions.i18nLocale, platform: buildOptions.platform === 'server' ? webpack_1.PLATFORM.Server : webpack_1.PLATFORM.Browser, missingTranslation: buildOptions.i18nMissingTranslation, sourceMap: buildOptions.sourceMap.scripts, additionalLazyModules,
        hostReplacementPaths, nameLazyFiles: buildOptions.namedChunks, forkTypeChecker: buildOptions.forkTypeChecker, contextElementDependencyConstructor: require('webpack/lib/dependencies/ContextElementDependency'), logger: wco.logger, directTemplateLoading: true }, options);
    return new webpack_1.AngularCompilerPlugin(pluginOptions);
}
function getNonAotConfig(wco, host) {
    const { tsConfigPath } = wco;
    return {
        module: { rules: [{ test: /\.tsx?$/, loader: webpack_1.NgToolsLoader }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath, skipCodeGeneration: true }, host)]
    };
}
exports.getNonAotConfig = getNonAotConfig;
function getAotConfig(wco, host, extract = false) {
    const { tsConfigPath, buildOptions } = wco;
    const loaders = [webpack_1.NgToolsLoader];
    if (buildOptions.buildOptimizer) {
        loaders.unshift({
            loader: common_1.buildOptimizerLoader,
            options: { sourceMap: buildOptions.sourceMap.scripts }
        });
    }
    const test = /(?:\.ngfactory\.js|\.ngstyle\.js|\.tsx?)$/;
    return {
        module: { rules: [{ test, use: loaders }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath }, host, true, extract)]
    };
}
exports.getAotConfig = getAotConfig;
function getNonAotTestConfig(wco, host) {
    const { tsConfigPath } = wco;
    return {
        module: { rules: [{ test: /\.tsx?$/, loader: webpack_1.NgToolsLoader }] },
        plugins: [_createAotPlugin(wco, { tsConfigPath, skipCodeGeneration: true }, host, false)]
    };
}
exports.getNonAotTestConfig = getNonAotTestConfig;
//# sourceMappingURL=data:application/json;base64,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