"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _issueishLink = require("./issueish-link");

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _prCheckoutController = require("../controllers/pr-checkout-controller");

var _githubDotcomMarkdown = _interopRequireDefault(require("./github-dotcom-markdown"));

var _patchPreviewView = _interopRequireDefault(require("./patch-preview-view"));

var _reviewCommentView = _interopRequireDefault(require("./review-comment-view"));

var _actionableReviewView = _interopRequireDefault(require("./actionable-review-view"));

var _checkoutButton = _interopRequireDefault(require("./checkout-button"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const authorAssociationText = {
  MEMBER: 'Member',
  OWNER: 'Owner',
  COLLABORATOR: 'Collaborator',
  CONTRIBUTOR: 'Contributor',
  FIRST_TIME_CONTRIBUTOR: 'First-time contributor',
  FIRST_TIMER: 'First-timer',
  NONE: null
};

class ReviewsView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "logStartReviewClick", () => {
      (0, _reporterProxy.addEvent)('start-pr-review', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "renderReviewSummary", review => {
      const reviewTypes = type => {
        return {
          APPROVED: {
            icon: 'icon-check',
            copy: 'approved these changes'
          },
          COMMENTED: {
            icon: 'icon-comment',
            copy: 'commented'
          },
          CHANGES_REQUESTED: {
            icon: 'icon-alert',
            copy: 'requested changes'
          }
        }[type] || {
          icon: '',
          copy: ''
        };
      };

      const {
        icon,
        copy
      } = reviewTypes(review.state); // filter non actionable empty summary comments from this view

      if (review.state === 'PENDING' || review.state === 'COMMENTED' && review.bodyHTML === '') {
        return null;
      }

      const author = review.author || _helpers.GHOST_USER;
      return _react["default"].createElement("div", {
        className: "github-ReviewSummary",
        key: review.id
      }, _react["default"].createElement(_actionableReviewView["default"], {
        originalContent: review,
        confirm: this.props.confirm,
        commands: this.props.commands,
        contentUpdater: this.props.updateSummary,
        render: showActionsMenu => {
          return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("header", {
            className: "github-Review-header"
          }, _react["default"].createElement("div", {
            className: "github-Review-header-authorData"
          }, _react["default"].createElement("span", {
            className: `github-ReviewSummary-icon icon ${icon}`
          }), _react["default"].createElement("img", {
            className: "github-ReviewSummary-avatar",
            src: author.avatarUrl,
            alt: author.login
          }), _react["default"].createElement("a", {
            className: "github-ReviewSummary-username",
            href: author.url
          }, author.login), _react["default"].createElement("span", {
            className: "github-ReviewSummary-type"
          }, copy), this.renderEditedLink(review), this.renderAuthorAssociation(review)), _react["default"].createElement(_timeago["default"], {
            className: "github-ReviewSummary-timeAgo",
            time: review.submittedAt,
            displayStyle: "short"
          }), _react["default"].createElement(_octicon["default"], {
            icon: "ellipses",
            className: "github-Review-actionsMenu",
            onClick: event => showActionsMenu(event, review, author)
          })), _react["default"].createElement("main", {
            className: "github-ReviewSummary-comment"
          }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
            html: review.bodyHTML,
            switchToIssueish: this.props.openIssueish,
            openIssueishLinkInNewTab: this.openIssueishLinkInNewTab
          }), _react["default"].createElement(_emojiReactionsController["default"], {
            reactable: review,
            tooltips: this.props.tooltips,
            reportRelayError: this.props.reportRelayError
          })));
        }
      }));
    });

    _defineProperty(this, "renderReviewCommentThread", commentThread => {
      const {
        comments,
        thread
      } = commentThread;
      const rootComment = comments[0];

      if (!rootComment) {
        return null;
      }

      let threadHolder = this.threadHolders.get(thread.id);

      if (!threadHolder) {
        threadHolder = new _refHolder["default"]();
        this.threadHolders.set(thread.id, threadHolder);
      }

      const nativePath = (0, _helpers.toNativePathSep)(rootComment.path);

      const {
        dir,
        base
      } = _path["default"].parse(nativePath);

      const {
        lineNumber,
        positionText
      } = this.getTranslatedPosition(rootComment);
      const refJumpToFileButton = new _refHolder["default"]();
      const jumpToFileDisabledLabel = 'Checkout this pull request to enable Jump To File.';
      const elementId = `review-thread-${thread.id}`;
      const navButtonClasses = ['github-Review-navButton', 'icon', {
        outdated: !lineNumber
      }];
      const openFileClasses = (0, _classnames["default"])('icon-code', ...navButtonClasses);
      const openDiffClasses = (0, _classnames["default"])('icon-diff', ...navButtonClasses);
      const isOpen = this.props.threadIDsOpen.has(thread.id);
      const isHighlighted = this.props.highlightedThreadIDs.has(thread.id);

      const toggle = evt => {
        evt.preventDefault();
        evt.stopPropagation();

        if (isOpen) {
          this.props.hideThreadID(thread.id);
        } else {
          this.props.showThreadID(thread.id);
        }
      };

      const author = rootComment.author || _helpers.GHOST_USER;
      return _react["default"].createElement("details", {
        ref: threadHolder.setter,
        className: (0, _classnames["default"])('github-Review', {
          'resolved': thread.isResolved,
          'github-Review--highlight': isHighlighted
        }),
        key: elementId,
        id: elementId,
        open: isOpen
      }, _react["default"].createElement("summary", {
        className: "github-Review-reference",
        onClick: toggle
      }, dir && _react["default"].createElement("span", {
        className: "github-Review-path"
      }, dir), _react["default"].createElement("span", {
        className: "github-Review-file"
      }, dir ? _path["default"].sep : '', base), _react["default"].createElement("span", {
        className: "github-Review-lineNr"
      }, positionText), _react["default"].createElement("img", {
        className: "github-Review-referenceAvatar",
        src: author.avatarUrl,
        alt: author.login
      }), _react["default"].createElement(_timeago["default"], {
        className: "github-Review-referenceTimeAgo",
        time: rootComment.createdAt,
        displayStyle: "short"
      })), _react["default"].createElement("nav", {
        className: "github-Review-nav"
      }, _react["default"].createElement("button", {
        className: openFileClasses,
        "data-path": nativePath,
        "data-line": lineNumber,
        onClick: this.openFile,
        disabled: this.props.checkoutOp.isEnabled(),
        ref: refJumpToFileButton.setter
      }, "Jump To File"), _react["default"].createElement("button", {
        className: openDiffClasses,
        "data-path": nativePath,
        "data-line": rootComment.position,
        onClick: this.openDiff
      }, "Open Diff"), this.props.checkoutOp.isEnabled() && _react["default"].createElement(_tooltip["default"], {
        manager: this.props.tooltips,
        target: refJumpToFileButton,
        title: jumpToFileDisabledLabel,
        showDelay: 200
      })), rootComment.position !== null && _react["default"].createElement(_patchPreviewView["default"], {
        multiFilePatch: this.props.multiFilePatch,
        fileName: nativePath,
        diffRow: rootComment.position,
        maxRowCount: this.props.contextLines,
        config: this.props.config
      }), this.renderThread({
        thread,
        comments
      }));
    });

    _defineProperty(this, "renderThread", ({
      thread,
      comments
    }) => {
      let replyHolder = this.replyHolders.get(thread.id);

      if (!replyHolder) {
        replyHolder = new _refHolder["default"]();
        this.replyHolders.set(thread.id, replyHolder);
      }

      const lastComment = comments[comments.length - 1];
      const isPosting = this.props.postingToThreadID !== null;
      return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("main", {
        className: "github-Review-comments"
      }, comments.map(comment => {
        return _react["default"].createElement(_reviewCommentView["default"], {
          key: comment.id,
          comment: comment,
          openIssueish: this.props.openIssueish,
          openIssueishLinkInNewTab: this.openIssueishLinkInNewTab,
          tooltips: this.props.tooltips,
          reportRelayError: this.props.reportRelayError,
          renderEditedLink: this.renderEditedLink,
          renderAuthorAssociation: this.renderAuthorAssociation,
          isPosting: isPosting,
          confirm: this.props.confirm,
          commands: this.props.commands,
          updateComment: this.props.updateComment
        });
      }), _react["default"].createElement("div", {
        className: (0, _classnames["default"])('github-Review-reply', {
          'github-Review-reply--disabled': isPosting
        }),
        "data-thread-id": thread.id
      }, _react["default"].createElement(_atomTextEditor["default"], {
        placeholderText: "Reply...",
        lineNumberGutterVisible: false,
        softWrapped: true,
        autoHeight: true,
        readOnly: isPosting,
        refModel: replyHolder
      }))), thread.isResolved && _react["default"].createElement("div", {
        className: "github-Review-resolvedText"
      }, "This conversation was marked as resolved by @", thread.resolvedBy.login), _react["default"].createElement("footer", {
        className: "github-Review-footer"
      }, _react["default"].createElement("button", {
        className: "github-Review-replyButton btn btn-primary",
        title: "Add your comment",
        disabled: isPosting,
        onClick: () => this.submitReply(replyHolder, thread, lastComment)
      }, "Comment"), this.renderResolveButton(thread)));
    });

    _defineProperty(this, "renderResolveButton", thread => {
      if (thread.isResolved) {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn icon icon-check",
          title: "Unresolve conversation",
          onClick: () => this.resolveUnresolveThread(thread)
        }, "Unresolve conversation");
      } else {
        return _react["default"].createElement("button", {
          className: "github-Review-resolveButton btn icon icon-check",
          title: "Resolve conversation",
          onClick: () => this.resolveUnresolveThread(thread)
        }, "Resolve conversation");
      }
    });

    _defineProperty(this, "openFile", evt => {
      if (!this.props.checkoutOp.isEnabled()) {
        const target = evt.currentTarget;
        this.props.openFile(target.dataset.path, target.dataset.line);
      }
    });

    _defineProperty(this, "openDiff", evt => {
      const target = evt.currentTarget;
      this.props.openDiff(target.dataset.path, parseInt(target.dataset.line, 10));
    });

    _defineProperty(this, "openIssueishLinkInNewTab", evt => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(evt.target.dataset.url);
      return this.props.openIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "submitCurrentComment", evt => {
      const threadID = evt.currentTarget.dataset.threadId;
      /* istanbul ignore if */

      if (!threadID) {
        return null;
      }

      const {
        thread,
        comments
      } = this.props.commentThreads.find(each => each.thread.id === threadID);
      const replyHolder = this.replyHolders.get(threadID);
      return this.submitReply(replyHolder, thread, comments[comments.length - 1]);
    });

    this.rootHolder = new _refHolder["default"]();
    this.replyHolders = new Map();
    this.threadHolders = new Map();
    this.state = {
      isRefreshing: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID) {
      this.scrollToThread(scrollToThreadID);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      scrollToThreadID
    } = this.props;

    if (scrollToThreadID && scrollToThreadID !== prevProps.scrollToThreadID) {
      this.scrollToThread(scrollToThreadID);
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Reviews",
      ref: this.rootHolder.setter
    }, this.renderCommands(), this.renderHeader(), _react["default"].createElement("div", {
      className: "github-Reviews-list"
    }, this.renderReviewSummaries(), this.renderReviewCommentThreads()));
  }

  renderCommands() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.rootHolder
    }, _react["default"].createElement(_commands.Command, {
      command: "github:more-context",
      callback: this.props.moreContext
    }), _react["default"].createElement(_commands.Command, {
      command: "github:less-context",
      callback: this.props.lessContext
    })), _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: ".github-Review-reply"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:submit-comment",
      callback: this.submitCurrentComment
    })));
  }

  renderHeader() {
    const refresh = () => {
      if (this.state.isRefreshing) {
        return;
      }

      this.setState({
        isRefreshing: true
      });
      const sub = this.props.refetch(() => {
        this.subs.remove(sub);
        this.setState({
          isRefreshing: false
        });
      });
      this.subs.add(sub);
    };

    return _react["default"].createElement("header", {
      className: "github-Reviews-topHeader"
    }, _react["default"].createElement("span", {
      className: "icon icon-comment-discussion"
    }), _react["default"].createElement("span", {
      className: "github-Reviews-headerTitle"
    }, "Reviews for\xA0", _react["default"].createElement("span", {
      className: "github-Reviews-clickable",
      onClick: this.props.openPR
    }, this.props.owner, "/", this.props.repo, "#", this.props.number)), _react["default"].createElement("button", {
      className: (0, _classnames["default"])('github-Reviews-headerButton github-Reviews-clickable icon icon-repo-sync', {
        refreshing: this.state.isRefreshing
      }),
      onClick: refresh
    }), _react["default"].createElement(_checkoutButton["default"], {
      checkoutOp: this.props.checkoutOp,
      classNamePrefix: "github-Reviews-checkoutButton--",
      classNames: ['github-Reviews-headerButton']
    }));
  }

  renderEmptyState() {
    const {
      number,
      repo,
      owner
    } = this.props; // todo: make this open the review flow in Atom instead of dotcom

    const pullRequestURL = `https://www.github.com/${owner}/${repo}/pull/${number}/files/`;
    return _react["default"].createElement("div", {
      className: "github-Reviews-emptyState"
    }, _react["default"].createElement("img", {
      src: "atom://github/img/mona.svg",
      alt: "Mona the octocat in spaaaccee",
      className: "github-Reviews-emptyImg"
    }), _react["default"].createElement("div", {
      className: "github-Reviews-emptyText"
    }, "This pull request has no reviews"), _react["default"].createElement("button", {
      className: "github-Reviews-emptyCallToActionButton btn"
    }, _react["default"].createElement("a", {
      href: pullRequestURL,
      onClick: this.logStartReviewClick
    }, "Start a new review")));
  }

  renderReviewSummaries() {
    if (this.props.summaries.length === 0) {
      return this.renderEmptyState();
    }

    const toggle = evt => {
      evt.preventDefault();

      if (this.props.summarySectionOpen) {
        this.props.hideSummaries();
      } else {
        this.props.showSummaries();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section summaries",
      open: this.props.summarySectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggle
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Summaries")), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, this.props.summaries.map(this.renderReviewSummary)));
  }

  renderReviewCommentThreads() {
    const commentThreads = this.props.commentThreads;

    if (commentThreads.length === 0) {
      return null;
    }

    const resolvedThreads = commentThreads.filter(pair => pair.thread.isResolved);
    const unresolvedThreads = commentThreads.filter(pair => !pair.thread.isResolved);

    const toggleComments = evt => {
      evt.preventDefault();

      if (this.props.commentSectionOpen) {
        this.props.hideComments();
      } else {
        this.props.showComments();
      }
    };

    return _react["default"].createElement("details", {
      className: "github-Reviews-section comments",
      open: this.props.commentSectionOpen
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header",
      onClick: toggleComments
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Comments"), _react["default"].createElement("span", {
      className: "github-Reviews-progress"
    }, _react["default"].createElement("span", {
      className: "github-Reviews-count"
    }, "Resolved", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, resolvedThreads.length), ' ', "of", ' ', _react["default"].createElement("span", {
      className: "github-Reviews-countNr"
    }, resolvedThreads.length + unresolvedThreads.length)), _react["default"].createElement("progress", {
      className: "github-Reviews-progessBar",
      value: resolvedThreads.length,
      max: resolvedThreads.length + unresolvedThreads.length
    }))), unresolvedThreads.length > 0 && _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, unresolvedThreads.map(this.renderReviewCommentThread)), resolvedThreads.length > 0 && _react["default"].createElement("details", {
      className: "github-Reviews-section resolved-comments",
      open: true
    }, _react["default"].createElement("summary", {
      className: "github-Reviews-header"
    }, _react["default"].createElement("span", {
      className: "github-Reviews-title"
    }, "Resolved")), _react["default"].createElement("main", {
      className: "github-Reviews-container"
    }, resolvedThreads.map(this.renderReviewCommentThread))));
  }

  renderEditedLink(entity) {
    if (!entity.lastEditedAt) {
      return null;
    } else {
      return _react["default"].createElement("span", {
        className: "github-Review-edited"
      }, "\xA0\u2022\xA0", _react["default"].createElement("a", {
        className: "github-Review-edited",
        href: entity.url
      }, "edited"));
    }
  }

  renderAuthorAssociation(entity) {
    const text = authorAssociationText[entity.authorAssociation];

    if (!text) {
      return null;
    }

    return _react["default"].createElement("span", {
      className: "github-Review-authorAssociationBadge badge"
    }, text);
  }

  submitReply(replyHolder, thread, lastComment) {
    const body = replyHolder.map(editor => editor.getText()).getOr('');

    const didSubmitComment = () => replyHolder.map(editor => editor.setText('', {
      bypassReadOnly: true
    }));

    const didFailComment = () => replyHolder.map(editor => editor.setText(body, {
      bypassReadOnly: true
    }));

    return this.props.addSingleComment(body, thread.id, lastComment.id, lastComment.path, lastComment.position, {
      didSubmitComment,
      didFailComment
    });
  }

  getTranslatedPosition(rootComment) {
    let lineNumber, positionText;
    const translations = this.props.commentTranslations;

    const isCheckedOutPullRequest = this.props.checkoutOp.why() === _prCheckoutController.checkoutStates.CURRENT;

    if (translations === null) {
      lineNumber = null;
      positionText = '';
    } else if (rootComment.position === null) {
      lineNumber = null;
      positionText = 'outdated';
    } else {
      const translationsForFile = translations.get(rootComment.path);
      lineNumber = translationsForFile.diffToFilePosition.get(parseInt(rootComment.position, 10));

      if (translationsForFile.fileTranslations && isCheckedOutPullRequest) {
        lineNumber = translationsForFile.fileTranslations.get(lineNumber).newPosition;
      }

      positionText = lineNumber;
    }

    return {
      lineNumber,
      positionText
    };
  }
  /* istanbul ignore next */


  scrollToThread(threadID) {
    const threadHolder = this.threadHolders.get(threadID);

    if (threadHolder) {
      threadHolder.map(element => {
        element.scrollIntoViewIfNeeded();
        return null; // shh, eslint
      });
    }
  }

  async resolveUnresolveThread(thread) {
    if (thread.isResolved) {
      await this.props.unresolveThread(thread);
    } else {
      await this.props.resolveThread(thread);
    }
  }

}

exports["default"] = ReviewsView;

_defineProperty(ReviewsView, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].object.isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  multiFilePatch: _propTypes["default"].object.isRequired,
  contextLines: _propTypes["default"].number.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  summarySectionOpen: _propTypes["default"].bool.isRequired,
  commentSectionOpen: _propTypes["default"].bool.isRequired,
  threadIDsOpen: _propTypes["default"].shape({
    has: _propTypes["default"].func.isRequired
  }),
  highlightedThreadIDs: _propTypes["default"].shape({
    has: _propTypes["default"].func.isRequired
  }),
  postingToThreadID: _propTypes["default"].string,
  scrollToThreadID: _propTypes["default"].string,
  // Structure: Map< relativePath: String, {
  //   rawPositions: Set<lineNumbers: Number>,
  //   diffToFilePosition: Map<rawPosition: Number, adjustedPosition: Number>,
  //   fileTranslations: null | Map<adjustedPosition: Number, {newPosition: Number}>,
  //   digest: String,
  // }>
  commentTranslations: _propTypes["default"].object,
  // for the dotcom link in the empty state
  number: _propTypes["default"].number.isRequired,
  repo: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  openFile: _propTypes["default"].func.isRequired,
  openDiff: _propTypes["default"].func.isRequired,
  openPR: _propTypes["default"].func.isRequired,
  moreContext: _propTypes["default"].func.isRequired,
  lessContext: _propTypes["default"].func.isRequired,
  openIssueish: _propTypes["default"].func.isRequired,
  showSummaries: _propTypes["default"].func.isRequired,
  hideSummaries: _propTypes["default"].func.isRequired,
  showComments: _propTypes["default"].func.isRequired,
  hideComments: _propTypes["default"].func.isRequired,
  showThreadID: _propTypes["default"].func.isRequired,
  hideThreadID: _propTypes["default"].func.isRequired,
  resolveThread: _propTypes["default"].func.isRequired,
  unresolveThread: _propTypes["default"].func.isRequired,
  addSingleComment: _propTypes["default"].func.isRequired,
  updateComment: _propTypes["default"].func.isRequired,
  updateSummary: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJldmlld3Mtdmlldy5qcyJdLCJuYW1lcyI6WyJhdXRob3JBc3NvY2lhdGlvblRleHQiLCJNRU1CRVIiLCJPV05FUiIsIkNPTExBQk9SQVRPUiIsIkNPTlRSSUJVVE9SIiwiRklSU1RfVElNRV9DT05UUklCVVRPUiIsIkZJUlNUX1RJTUVSIiwiTk9ORSIsIlJldmlld3NWaWV3IiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwiY29tcG9uZW50IiwibmFtZSIsInJldmlldyIsInJldmlld1R5cGVzIiwidHlwZSIsIkFQUFJPVkVEIiwiaWNvbiIsImNvcHkiLCJDT01NRU5URUQiLCJDSEFOR0VTX1JFUVVFU1RFRCIsInN0YXRlIiwiYm9keUhUTUwiLCJhdXRob3IiLCJHSE9TVF9VU0VSIiwiaWQiLCJjb25maXJtIiwiY29tbWFuZHMiLCJ1cGRhdGVTdW1tYXJ5Iiwic2hvd0FjdGlvbnNNZW51IiwiYXZhdGFyVXJsIiwibG9naW4iLCJ1cmwiLCJyZW5kZXJFZGl0ZWRMaW5rIiwicmVuZGVyQXV0aG9yQXNzb2NpYXRpb24iLCJzdWJtaXR0ZWRBdCIsImV2ZW50Iiwib3Blbklzc3VlaXNoIiwib3Blbklzc3VlaXNoTGlua0luTmV3VGFiIiwidG9vbHRpcHMiLCJyZXBvcnRSZWxheUVycm9yIiwiY29tbWVudFRocmVhZCIsImNvbW1lbnRzIiwidGhyZWFkIiwicm9vdENvbW1lbnQiLCJ0aHJlYWRIb2xkZXIiLCJ0aHJlYWRIb2xkZXJzIiwiZ2V0IiwiUmVmSG9sZGVyIiwic2V0IiwibmF0aXZlUGF0aCIsInBhdGgiLCJkaXIiLCJiYXNlIiwicGFyc2UiLCJsaW5lTnVtYmVyIiwicG9zaXRpb25UZXh0IiwiZ2V0VHJhbnNsYXRlZFBvc2l0aW9uIiwicmVmSnVtcFRvRmlsZUJ1dHRvbiIsImp1bXBUb0ZpbGVEaXNhYmxlZExhYmVsIiwiZWxlbWVudElkIiwibmF2QnV0dG9uQ2xhc3NlcyIsIm91dGRhdGVkIiwib3BlbkZpbGVDbGFzc2VzIiwib3BlbkRpZmZDbGFzc2VzIiwiaXNPcGVuIiwidGhyZWFkSURzT3BlbiIsImhhcyIsImlzSGlnaGxpZ2h0ZWQiLCJoaWdobGlnaHRlZFRocmVhZElEcyIsInRvZ2dsZSIsImV2dCIsInByZXZlbnREZWZhdWx0Iiwic3RvcFByb3BhZ2F0aW9uIiwiaGlkZVRocmVhZElEIiwic2hvd1RocmVhZElEIiwic2V0dGVyIiwiaXNSZXNvbHZlZCIsInNlcCIsImNyZWF0ZWRBdCIsIm9wZW5GaWxlIiwiY2hlY2tvdXRPcCIsImlzRW5hYmxlZCIsInBvc2l0aW9uIiwib3BlbkRpZmYiLCJtdWx0aUZpbGVQYXRjaCIsImNvbnRleHRMaW5lcyIsImNvbmZpZyIsInJlbmRlclRocmVhZCIsInJlcGx5SG9sZGVyIiwicmVwbHlIb2xkZXJzIiwibGFzdENvbW1lbnQiLCJsZW5ndGgiLCJpc1Bvc3RpbmciLCJwb3N0aW5nVG9UaHJlYWRJRCIsIm1hcCIsImNvbW1lbnQiLCJ1cGRhdGVDb21tZW50IiwicmVzb2x2ZWRCeSIsInN1Ym1pdFJlcGx5IiwicmVuZGVyUmVzb2x2ZUJ1dHRvbiIsInJlc29sdmVVbnJlc29sdmVUaHJlYWQiLCJ0YXJnZXQiLCJjdXJyZW50VGFyZ2V0IiwiZGF0YXNldCIsImxpbmUiLCJwYXJzZUludCIsInJlcG9Pd25lciIsInJlcG9OYW1lIiwiaXNzdWVpc2hOdW1iZXIiLCJ0aHJlYWRJRCIsInRocmVhZElkIiwiY29tbWVudFRocmVhZHMiLCJmaW5kIiwiZWFjaCIsInJvb3RIb2xkZXIiLCJNYXAiLCJpc1JlZnJlc2hpbmciLCJzdWJzIiwiQ29tcG9zaXRlRGlzcG9zYWJsZSIsImNvbXBvbmVudERpZE1vdW50Iiwic2Nyb2xsVG9UaHJlYWRJRCIsInNjcm9sbFRvVGhyZWFkIiwiY29tcG9uZW50RGlkVXBkYXRlIiwicHJldlByb3BzIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJkaXNwb3NlIiwicmVuZGVyIiwicmVuZGVyQ29tbWFuZHMiLCJyZW5kZXJIZWFkZXIiLCJyZW5kZXJSZXZpZXdTdW1tYXJpZXMiLCJyZW5kZXJSZXZpZXdDb21tZW50VGhyZWFkcyIsIm1vcmVDb250ZXh0IiwibGVzc0NvbnRleHQiLCJzdWJtaXRDdXJyZW50Q29tbWVudCIsInJlZnJlc2giLCJzZXRTdGF0ZSIsInN1YiIsInJlZmV0Y2giLCJyZW1vdmUiLCJhZGQiLCJvcGVuUFIiLCJvd25lciIsInJlcG8iLCJudW1iZXIiLCJyZWZyZXNoaW5nIiwicmVuZGVyRW1wdHlTdGF0ZSIsInB1bGxSZXF1ZXN0VVJMIiwibG9nU3RhcnRSZXZpZXdDbGljayIsInN1bW1hcmllcyIsInN1bW1hcnlTZWN0aW9uT3BlbiIsImhpZGVTdW1tYXJpZXMiLCJzaG93U3VtbWFyaWVzIiwicmVuZGVyUmV2aWV3U3VtbWFyeSIsInJlc29sdmVkVGhyZWFkcyIsImZpbHRlciIsInBhaXIiLCJ1bnJlc29sdmVkVGhyZWFkcyIsInRvZ2dsZUNvbW1lbnRzIiwiY29tbWVudFNlY3Rpb25PcGVuIiwiaGlkZUNvbW1lbnRzIiwic2hvd0NvbW1lbnRzIiwicmVuZGVyUmV2aWV3Q29tbWVudFRocmVhZCIsImVudGl0eSIsImxhc3RFZGl0ZWRBdCIsInRleHQiLCJhdXRob3JBc3NvY2lhdGlvbiIsImJvZHkiLCJlZGl0b3IiLCJnZXRUZXh0IiwiZ2V0T3IiLCJkaWRTdWJtaXRDb21tZW50Iiwic2V0VGV4dCIsImJ5cGFzc1JlYWRPbmx5IiwiZGlkRmFpbENvbW1lbnQiLCJhZGRTaW5nbGVDb21tZW50IiwidHJhbnNsYXRpb25zIiwiY29tbWVudFRyYW5zbGF0aW9ucyIsImlzQ2hlY2tlZE91dFB1bGxSZXF1ZXN0Iiwid2h5IiwiY2hlY2tvdXRTdGF0ZXMiLCJDVVJSRU5UIiwidHJhbnNsYXRpb25zRm9yRmlsZSIsImRpZmZUb0ZpbGVQb3NpdGlvbiIsImZpbGVUcmFuc2xhdGlvbnMiLCJuZXdQb3NpdGlvbiIsImVsZW1lbnQiLCJzY3JvbGxJbnRvVmlld0lmTmVlZGVkIiwidW5yZXNvbHZlVGhyZWFkIiwicmVzb2x2ZVRocmVhZCIsInJlbGF5IiwiUHJvcFR5cGVzIiwic2hhcGUiLCJlbnZpcm9ubWVudCIsIm9iamVjdCIsImlzUmVxdWlyZWQiLCJyZXBvc2l0b3J5IiwicHVsbFJlcXVlc3QiLCJhcnJheSIsImFycmF5T2YiLCJmdW5jIiwiRW5hYmxlYWJsZU9wZXJhdGlvblByb3BUeXBlIiwiYm9vbCIsInN0cmluZyIsIndvcmtkaXIiLCJ3b3Jrc3BhY2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFQSxNQUFNQSxxQkFBcUIsR0FBRztBQUM1QkMsRUFBQUEsTUFBTSxFQUFFLFFBRG9CO0FBRTVCQyxFQUFBQSxLQUFLLEVBQUUsT0FGcUI7QUFHNUJDLEVBQUFBLFlBQVksRUFBRSxjQUhjO0FBSTVCQyxFQUFBQSxXQUFXLEVBQUUsYUFKZTtBQUs1QkMsRUFBQUEsc0JBQXNCLEVBQUUsd0JBTEk7QUFNNUJDLEVBQUFBLFdBQVcsRUFBRSxhQU5lO0FBTzVCQyxFQUFBQSxJQUFJLEVBQUU7QUFQc0IsQ0FBOUI7O0FBVWUsTUFBTUMsV0FBTixTQUEwQkMsa0JBQU1DLFNBQWhDLENBQTBDO0FBdUV2REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjs7QUFEaUIsaURBOEZHLE1BQU07QUFDMUIsbUNBQVMsaUJBQVQsRUFBNEI7QUFBQyxtQkFBUyxRQUFWO0FBQW9CQyxRQUFBQSxTQUFTLEVBQUUsS0FBS0YsV0FBTCxDQUFpQkc7QUFBaEQsT0FBNUI7QUFDRCxLQWhHa0I7O0FBQUEsaURBbUpHQyxNQUFNLElBQUk7QUFDOUIsWUFBTUMsV0FBVyxHQUFHQyxJQUFJLElBQUk7QUFDMUIsZUFBTztBQUNMQyxVQUFBQSxRQUFRLEVBQUU7QUFBQ0MsWUFBQUEsSUFBSSxFQUFFLFlBQVA7QUFBcUJDLFlBQUFBLElBQUksRUFBRTtBQUEzQixXQURMO0FBRUxDLFVBQUFBLFNBQVMsRUFBRTtBQUFDRixZQUFBQSxJQUFJLEVBQUUsY0FBUDtBQUF1QkMsWUFBQUEsSUFBSSxFQUFFO0FBQTdCLFdBRk47QUFHTEUsVUFBQUEsaUJBQWlCLEVBQUU7QUFBQ0gsWUFBQUEsSUFBSSxFQUFFLFlBQVA7QUFBcUJDLFlBQUFBLElBQUksRUFBRTtBQUEzQjtBQUhkLFVBSUxILElBSkssS0FJSTtBQUFDRSxVQUFBQSxJQUFJLEVBQUUsRUFBUDtBQUFXQyxVQUFBQSxJQUFJLEVBQUU7QUFBakIsU0FKWDtBQUtELE9BTkQ7O0FBUUEsWUFBTTtBQUFDRCxRQUFBQSxJQUFEO0FBQU9DLFFBQUFBO0FBQVAsVUFBZUosV0FBVyxDQUFDRCxNQUFNLENBQUNRLEtBQVIsQ0FBaEMsQ0FUOEIsQ0FXOUI7O0FBQ0EsVUFBSVIsTUFBTSxDQUFDUSxLQUFQLEtBQWlCLFNBQWpCLElBQStCUixNQUFNLENBQUNRLEtBQVAsS0FBaUIsV0FBakIsSUFBZ0NSLE1BQU0sQ0FBQ1MsUUFBUCxLQUFvQixFQUF2RixFQUE0RjtBQUMxRixlQUFPLElBQVA7QUFDRDs7QUFFRCxZQUFNQyxNQUFNLEdBQUdWLE1BQU0sQ0FBQ1UsTUFBUCxJQUFpQkMsbUJBQWhDO0FBRUEsYUFDRTtBQUFLLFFBQUEsU0FBUyxFQUFDLHNCQUFmO0FBQXNDLFFBQUEsR0FBRyxFQUFFWCxNQUFNLENBQUNZO0FBQWxELFNBQ0UsZ0NBQUMsZ0NBQUQ7QUFDRSxRQUFBLGVBQWUsRUFBRVosTUFEbkI7QUFFRSxRQUFBLE9BQU8sRUFBRSxLQUFLSCxLQUFMLENBQVdnQixPQUZ0QjtBQUdFLFFBQUEsUUFBUSxFQUFFLEtBQUtoQixLQUFMLENBQVdpQixRQUh2QjtBQUlFLFFBQUEsY0FBYyxFQUFFLEtBQUtqQixLQUFMLENBQVdrQixhQUo3QjtBQUtFLFFBQUEsTUFBTSxFQUFFQyxlQUFlLElBQUk7QUFDekIsaUJBQ0UsZ0NBQUMsZUFBRCxRQUNFO0FBQVEsWUFBQSxTQUFTLEVBQUM7QUFBbEIsYUFDRTtBQUFLLFlBQUEsU0FBUyxFQUFDO0FBQWYsYUFDRTtBQUFNLFlBQUEsU0FBUyxFQUFHLGtDQUFpQ1osSUFBSztBQUF4RCxZQURGLEVBRUU7QUFBSyxZQUFBLFNBQVMsRUFBQyw2QkFBZjtBQUNFLFlBQUEsR0FBRyxFQUFFTSxNQUFNLENBQUNPLFNBRGQ7QUFDeUIsWUFBQSxHQUFHLEVBQUVQLE1BQU0sQ0FBQ1E7QUFEckMsWUFGRixFQUtFO0FBQUcsWUFBQSxTQUFTLEVBQUMsK0JBQWI7QUFBNkMsWUFBQSxJQUFJLEVBQUVSLE1BQU0sQ0FBQ1M7QUFBMUQsYUFBZ0VULE1BQU0sQ0FBQ1EsS0FBdkUsQ0FMRixFQU1FO0FBQU0sWUFBQSxTQUFTLEVBQUM7QUFBaEIsYUFBNkNiLElBQTdDLENBTkYsRUFPRyxLQUFLZSxnQkFBTCxDQUFzQnBCLE1BQXRCLENBUEgsRUFRRyxLQUFLcUIsdUJBQUwsQ0FBNkJyQixNQUE3QixDQVJILENBREYsRUFXRSxnQ0FBQyxtQkFBRDtBQUFTLFlBQUEsU0FBUyxFQUFDLDhCQUFuQjtBQUFrRCxZQUFBLElBQUksRUFBRUEsTUFBTSxDQUFDc0IsV0FBL0Q7QUFBNEUsWUFBQSxZQUFZLEVBQUM7QUFBekYsWUFYRixFQVlFLGdDQUFDLG1CQUFEO0FBQ0UsWUFBQSxJQUFJLEVBQUMsVUFEUDtBQUVFLFlBQUEsU0FBUyxFQUFDLDJCQUZaO0FBR0UsWUFBQSxPQUFPLEVBQUVDLEtBQUssSUFBSVAsZUFBZSxDQUFDTyxLQUFELEVBQVF2QixNQUFSLEVBQWdCVSxNQUFoQjtBQUhuQyxZQVpGLENBREYsRUFtQkU7QUFBTSxZQUFBLFNBQVMsRUFBQztBQUFoQixhQUNFLGdDQUFDLGdDQUFEO0FBQ0UsWUFBQSxJQUFJLEVBQUVWLE1BQU0sQ0FBQ1MsUUFEZjtBQUVFLFlBQUEsZ0JBQWdCLEVBQUUsS0FBS1osS0FBTCxDQUFXMkIsWUFGL0I7QUFHRSxZQUFBLHdCQUF3QixFQUFFLEtBQUtDO0FBSGpDLFlBREYsRUFNRSxnQ0FBQyxvQ0FBRDtBQUNFLFlBQUEsU0FBUyxFQUFFekIsTUFEYjtBQUVFLFlBQUEsUUFBUSxFQUFFLEtBQUtILEtBQUwsQ0FBVzZCLFFBRnZCO0FBR0UsWUFBQSxnQkFBZ0IsRUFBRSxLQUFLN0IsS0FBTCxDQUFXOEI7QUFIL0IsWUFORixDQW5CRixDQURGO0FBa0NEO0FBeENILFFBREYsQ0FERjtBQThDRCxLQW5Oa0I7O0FBQUEsdURBNFFTQyxhQUFhLElBQUk7QUFDM0MsWUFBTTtBQUFDQyxRQUFBQSxRQUFEO0FBQVdDLFFBQUFBO0FBQVgsVUFBcUJGLGFBQTNCO0FBQ0EsWUFBTUcsV0FBVyxHQUFHRixRQUFRLENBQUMsQ0FBRCxDQUE1Qjs7QUFDQSxVQUFJLENBQUNFLFdBQUwsRUFBa0I7QUFDaEIsZUFBTyxJQUFQO0FBQ0Q7O0FBRUQsVUFBSUMsWUFBWSxHQUFHLEtBQUtDLGFBQUwsQ0FBbUJDLEdBQW5CLENBQXVCSixNQUFNLENBQUNsQixFQUE5QixDQUFuQjs7QUFDQSxVQUFJLENBQUNvQixZQUFMLEVBQW1CO0FBQ2pCQSxRQUFBQSxZQUFZLEdBQUcsSUFBSUcscUJBQUosRUFBZjtBQUNBLGFBQUtGLGFBQUwsQ0FBbUJHLEdBQW5CLENBQXVCTixNQUFNLENBQUNsQixFQUE5QixFQUFrQ29CLFlBQWxDO0FBQ0Q7O0FBRUQsWUFBTUssVUFBVSxHQUFHLDhCQUFnQk4sV0FBVyxDQUFDTyxJQUE1QixDQUFuQjs7QUFDQSxZQUFNO0FBQUNDLFFBQUFBLEdBQUQ7QUFBTUMsUUFBQUE7QUFBTixVQUFjRixpQkFBS0csS0FBTCxDQUFXSixVQUFYLENBQXBCOztBQUNBLFlBQU07QUFBQ0ssUUFBQUEsVUFBRDtBQUFhQyxRQUFBQTtBQUFiLFVBQTZCLEtBQUtDLHFCQUFMLENBQTJCYixXQUEzQixDQUFuQztBQUVBLFlBQU1jLG1CQUFtQixHQUFHLElBQUlWLHFCQUFKLEVBQTVCO0FBQ0EsWUFBTVcsdUJBQXVCLEdBQUcsb0RBQWhDO0FBRUEsWUFBTUMsU0FBUyxHQUFJLGlCQUFnQmpCLE1BQU0sQ0FBQ2xCLEVBQUcsRUFBN0M7QUFFQSxZQUFNb0MsZ0JBQWdCLEdBQUcsQ0FBQyx5QkFBRCxFQUE0QixNQUE1QixFQUFvQztBQUFDQyxRQUFBQSxRQUFRLEVBQUUsQ0FBQ1A7QUFBWixPQUFwQyxDQUF6QjtBQUNBLFlBQU1RLGVBQWUsR0FBRyw0QkFBRyxXQUFILEVBQWdCLEdBQUdGLGdCQUFuQixDQUF4QjtBQUNBLFlBQU1HLGVBQWUsR0FBRyw0QkFBRyxXQUFILEVBQWdCLEdBQUdILGdCQUFuQixDQUF4QjtBQUVBLFlBQU1JLE1BQU0sR0FBRyxLQUFLdkQsS0FBTCxDQUFXd0QsYUFBWCxDQUF5QkMsR0FBekIsQ0FBNkJ4QixNQUFNLENBQUNsQixFQUFwQyxDQUFmO0FBQ0EsWUFBTTJDLGFBQWEsR0FBRyxLQUFLMUQsS0FBTCxDQUFXMkQsb0JBQVgsQ0FBZ0NGLEdBQWhDLENBQW9DeEIsTUFBTSxDQUFDbEIsRUFBM0MsQ0FBdEI7O0FBQ0EsWUFBTTZDLE1BQU0sR0FBR0MsR0FBRyxJQUFJO0FBQ3BCQSxRQUFBQSxHQUFHLENBQUNDLGNBQUo7QUFDQUQsUUFBQUEsR0FBRyxDQUFDRSxlQUFKOztBQUVBLFlBQUlSLE1BQUosRUFBWTtBQUNWLGVBQUt2RCxLQUFMLENBQVdnRSxZQUFYLENBQXdCL0IsTUFBTSxDQUFDbEIsRUFBL0I7QUFDRCxTQUZELE1BRU87QUFDTCxlQUFLZixLQUFMLENBQVdpRSxZQUFYLENBQXdCaEMsTUFBTSxDQUFDbEIsRUFBL0I7QUFDRDtBQUNGLE9BVEQ7O0FBV0EsWUFBTUYsTUFBTSxHQUFHcUIsV0FBVyxDQUFDckIsTUFBWixJQUFzQkMsbUJBQXJDO0FBRUEsYUFDRTtBQUNFLFFBQUEsR0FBRyxFQUFFcUIsWUFBWSxDQUFDK0IsTUFEcEI7QUFFRSxRQUFBLFNBQVMsRUFBRSw0QkFBRyxlQUFILEVBQW9CO0FBQUMsc0JBQVlqQyxNQUFNLENBQUNrQyxVQUFwQjtBQUFnQyxzQ0FBNEJUO0FBQTVELFNBQXBCLENBRmI7QUFHRSxRQUFBLEdBQUcsRUFBRVIsU0FIUDtBQUlFLFFBQUEsRUFBRSxFQUFFQSxTQUpOO0FBS0UsUUFBQSxJQUFJLEVBQUVLO0FBTFIsU0FPRTtBQUFTLFFBQUEsU0FBUyxFQUFDLHlCQUFuQjtBQUE2QyxRQUFBLE9BQU8sRUFBRUs7QUFBdEQsU0FDR2xCLEdBQUcsSUFBSTtBQUFNLFFBQUEsU0FBUyxFQUFDO0FBQWhCLFNBQXNDQSxHQUF0QyxDQURWLEVBRUU7QUFBTSxRQUFBLFNBQVMsRUFBQztBQUFoQixTQUFzQ0EsR0FBRyxHQUFHRCxpQkFBSzJCLEdBQVIsR0FBYyxFQUF2RCxFQUEyRHpCLElBQTNELENBRkYsRUFHRTtBQUFNLFFBQUEsU0FBUyxFQUFDO0FBQWhCLFNBQXdDRyxZQUF4QyxDQUhGLEVBSUU7QUFBSyxRQUFBLFNBQVMsRUFBQywrQkFBZjtBQUNFLFFBQUEsR0FBRyxFQUFFakMsTUFBTSxDQUFDTyxTQURkO0FBQ3lCLFFBQUEsR0FBRyxFQUFFUCxNQUFNLENBQUNRO0FBRHJDLFFBSkYsRUFPRSxnQ0FBQyxtQkFBRDtBQUFTLFFBQUEsU0FBUyxFQUFDLGdDQUFuQjtBQUFvRCxRQUFBLElBQUksRUFBRWEsV0FBVyxDQUFDbUMsU0FBdEU7QUFBaUYsUUFBQSxZQUFZLEVBQUM7QUFBOUYsUUFQRixDQVBGLEVBZ0JFO0FBQUssUUFBQSxTQUFTLEVBQUM7QUFBZixTQUNFO0FBQVEsUUFBQSxTQUFTLEVBQUVoQixlQUFuQjtBQUNFLHFCQUFXYixVQURiO0FBQ3lCLHFCQUFXSyxVQURwQztBQUVFLFFBQUEsT0FBTyxFQUFFLEtBQUt5QixRQUZoQjtBQUUwQixRQUFBLFFBQVEsRUFBRSxLQUFLdEUsS0FBTCxDQUFXdUUsVUFBWCxDQUFzQkMsU0FBdEIsRUFGcEM7QUFHRSxRQUFBLEdBQUcsRUFBRXhCLG1CQUFtQixDQUFDa0I7QUFIM0Isd0JBREYsRUFPRTtBQUFRLFFBQUEsU0FBUyxFQUFFWixlQUFuQjtBQUNFLHFCQUFXZCxVQURiO0FBQ3lCLHFCQUFXTixXQUFXLENBQUN1QyxRQURoRDtBQUVFLFFBQUEsT0FBTyxFQUFFLEtBQUtDO0FBRmhCLHFCQVBGLEVBWUcsS0FBSzFFLEtBQUwsQ0FBV3VFLFVBQVgsQ0FBc0JDLFNBQXRCLE1BQ0MsZ0NBQUMsbUJBQUQ7QUFDRSxRQUFBLE9BQU8sRUFBRSxLQUFLeEUsS0FBTCxDQUFXNkIsUUFEdEI7QUFFRSxRQUFBLE1BQU0sRUFBRW1CLG1CQUZWO0FBR0UsUUFBQSxLQUFLLEVBQUVDLHVCQUhUO0FBSUUsUUFBQSxTQUFTLEVBQUU7QUFKYixRQWJKLENBaEJGLEVBc0NHZixXQUFXLENBQUN1QyxRQUFaLEtBQXlCLElBQXpCLElBQ0MsZ0NBQUMsNEJBQUQ7QUFDRSxRQUFBLGNBQWMsRUFBRSxLQUFLekUsS0FBTCxDQUFXMkUsY0FEN0I7QUFFRSxRQUFBLFFBQVEsRUFBRW5DLFVBRlo7QUFHRSxRQUFBLE9BQU8sRUFBRU4sV0FBVyxDQUFDdUMsUUFIdkI7QUFJRSxRQUFBLFdBQVcsRUFBRSxLQUFLekUsS0FBTCxDQUFXNEUsWUFKMUI7QUFLRSxRQUFBLE1BQU0sRUFBRSxLQUFLNUUsS0FBTCxDQUFXNkU7QUFMckIsUUF2Q0osRUFnREcsS0FBS0MsWUFBTCxDQUFrQjtBQUFDN0MsUUFBQUEsTUFBRDtBQUFTRCxRQUFBQTtBQUFULE9BQWxCLENBaERILENBREY7QUFxREQsS0ExV2tCOztBQUFBLDBDQTRXSixDQUFDO0FBQUNDLE1BQUFBLE1BQUQ7QUFBU0QsTUFBQUE7QUFBVCxLQUFELEtBQXdCO0FBQ3JDLFVBQUkrQyxXQUFXLEdBQUcsS0FBS0MsWUFBTCxDQUFrQjNDLEdBQWxCLENBQXNCSixNQUFNLENBQUNsQixFQUE3QixDQUFsQjs7QUFDQSxVQUFJLENBQUNnRSxXQUFMLEVBQWtCO0FBQ2hCQSxRQUFBQSxXQUFXLEdBQUcsSUFBSXpDLHFCQUFKLEVBQWQ7QUFDQSxhQUFLMEMsWUFBTCxDQUFrQnpDLEdBQWxCLENBQXNCTixNQUFNLENBQUNsQixFQUE3QixFQUFpQ2dFLFdBQWpDO0FBQ0Q7O0FBRUQsWUFBTUUsV0FBVyxHQUFHakQsUUFBUSxDQUFDQSxRQUFRLENBQUNrRCxNQUFULEdBQWtCLENBQW5CLENBQTVCO0FBQ0EsWUFBTUMsU0FBUyxHQUFHLEtBQUtuRixLQUFMLENBQVdvRixpQkFBWCxLQUFpQyxJQUFuRDtBQUVBLGFBQ0UsZ0NBQUMsZUFBRCxRQUNFO0FBQU0sUUFBQSxTQUFTLEVBQUM7QUFBaEIsU0FFR3BELFFBQVEsQ0FBQ3FELEdBQVQsQ0FBYUMsT0FBTyxJQUFJO0FBQ3ZCLGVBQ0UsZ0NBQUMsNkJBQUQ7QUFDRSxVQUFBLEdBQUcsRUFBRUEsT0FBTyxDQUFDdkUsRUFEZjtBQUVFLFVBQUEsT0FBTyxFQUFFdUUsT0FGWDtBQUdFLFVBQUEsWUFBWSxFQUFFLEtBQUt0RixLQUFMLENBQVcyQixZQUgzQjtBQUlFLFVBQUEsd0JBQXdCLEVBQUUsS0FBS0Msd0JBSmpDO0FBS0UsVUFBQSxRQUFRLEVBQUUsS0FBSzVCLEtBQUwsQ0FBVzZCLFFBTHZCO0FBTUUsVUFBQSxnQkFBZ0IsRUFBRSxLQUFLN0IsS0FBTCxDQUFXOEIsZ0JBTi9CO0FBT0UsVUFBQSxnQkFBZ0IsRUFBRSxLQUFLUCxnQkFQekI7QUFRRSxVQUFBLHVCQUF1QixFQUFFLEtBQUtDLHVCQVJoQztBQVNFLFVBQUEsU0FBUyxFQUFFMkQsU0FUYjtBQVVFLFVBQUEsT0FBTyxFQUFFLEtBQUtuRixLQUFMLENBQVdnQixPQVZ0QjtBQVdFLFVBQUEsUUFBUSxFQUFFLEtBQUtoQixLQUFMLENBQVdpQixRQVh2QjtBQVlFLFVBQUEsYUFBYSxFQUFFLEtBQUtqQixLQUFMLENBQVd1RjtBQVo1QixVQURGO0FBZ0JELE9BakJBLENBRkgsRUFxQkU7QUFDRSxRQUFBLFNBQVMsRUFBRSw0QkFBRyxxQkFBSCxFQUEwQjtBQUFDLDJDQUFpQ0o7QUFBbEMsU0FBMUIsQ0FEYjtBQUVFLDBCQUFnQmxELE1BQU0sQ0FBQ2xCO0FBRnpCLFNBSUUsZ0NBQUMsMEJBQUQ7QUFDRSxRQUFBLGVBQWUsRUFBQyxVQURsQjtBQUVFLFFBQUEsdUJBQXVCLEVBQUUsS0FGM0I7QUFHRSxRQUFBLFdBQVcsRUFBRSxJQUhmO0FBSUUsUUFBQSxVQUFVLEVBQUUsSUFKZDtBQUtFLFFBQUEsUUFBUSxFQUFFb0UsU0FMWjtBQU1FLFFBQUEsUUFBUSxFQUFFSjtBQU5aLFFBSkYsQ0FyQkYsQ0FERixFQXFDRzlDLE1BQU0sQ0FBQ2tDLFVBQVAsSUFBcUI7QUFBSyxRQUFBLFNBQVMsRUFBQztBQUFmLDBEQUMwQmxDLE1BQU0sQ0FBQ3VELFVBQVAsQ0FBa0JuRSxLQUQ1QyxDQXJDeEIsRUF3Q0U7QUFBUSxRQUFBLFNBQVMsRUFBQztBQUFsQixTQUNFO0FBQ0UsUUFBQSxTQUFTLEVBQUMsMkNBRFo7QUFFRSxRQUFBLEtBQUssRUFBQyxrQkFGUjtBQUdFLFFBQUEsUUFBUSxFQUFFOEQsU0FIWjtBQUlFLFFBQUEsT0FBTyxFQUFFLE1BQU0sS0FBS00sV0FBTCxDQUFpQlYsV0FBakIsRUFBOEI5QyxNQUE5QixFQUFzQ2dELFdBQXRDO0FBSmpCLG1CQURGLEVBUUcsS0FBS1MsbUJBQUwsQ0FBeUJ6RCxNQUF6QixDQVJILENBeENGLENBREY7QUFxREQsS0EzYWtCOztBQUFBLGlEQTZhR0EsTUFBTSxJQUFJO0FBQzlCLFVBQUlBLE1BQU0sQ0FBQ2tDLFVBQVgsRUFBdUI7QUFDckIsZUFDRTtBQUNFLFVBQUEsU0FBUyxFQUFDLGlEQURaO0FBRUUsVUFBQSxLQUFLLEVBQUMsd0JBRlI7QUFHRSxVQUFBLE9BQU8sRUFBRSxNQUFNLEtBQUt3QixzQkFBTCxDQUE0QjFELE1BQTVCO0FBSGpCLG9DQURGO0FBUUQsT0FURCxNQVNPO0FBQ0wsZUFDRTtBQUNFLFVBQUEsU0FBUyxFQUFDLGlEQURaO0FBRUUsVUFBQSxLQUFLLEVBQUMsc0JBRlI7QUFHRSxVQUFBLE9BQU8sRUFBRSxNQUFNLEtBQUswRCxzQkFBTCxDQUE0QjFELE1BQTVCO0FBSGpCLGtDQURGO0FBUUQ7QUFDRixLQWpja0I7O0FBQUEsc0NBd2RSNEIsR0FBRyxJQUFJO0FBQ2hCLFVBQUksQ0FBQyxLQUFLN0QsS0FBTCxDQUFXdUUsVUFBWCxDQUFzQkMsU0FBdEIsRUFBTCxFQUF3QztBQUN0QyxjQUFNb0IsTUFBTSxHQUFHL0IsR0FBRyxDQUFDZ0MsYUFBbkI7QUFDQSxhQUFLN0YsS0FBTCxDQUFXc0UsUUFBWCxDQUFvQnNCLE1BQU0sQ0FBQ0UsT0FBUCxDQUFlckQsSUFBbkMsRUFBeUNtRCxNQUFNLENBQUNFLE9BQVAsQ0FBZUMsSUFBeEQ7QUFDRDtBQUNGLEtBN2RrQjs7QUFBQSxzQ0ErZFJsQyxHQUFHLElBQUk7QUFDaEIsWUFBTStCLE1BQU0sR0FBRy9CLEdBQUcsQ0FBQ2dDLGFBQW5CO0FBQ0EsV0FBSzdGLEtBQUwsQ0FBVzBFLFFBQVgsQ0FBb0JrQixNQUFNLENBQUNFLE9BQVAsQ0FBZXJELElBQW5DLEVBQXlDdUQsUUFBUSxDQUFDSixNQUFNLENBQUNFLE9BQVAsQ0FBZUMsSUFBaEIsRUFBc0IsRUFBdEIsQ0FBakQ7QUFDRCxLQWxla0I7O0FBQUEsc0RBb2VRbEMsR0FBRyxJQUFJO0FBQ2hDLFlBQU07QUFBQ29DLFFBQUFBLFNBQUQ7QUFBWUMsUUFBQUEsUUFBWjtBQUFzQkMsUUFBQUE7QUFBdEIsVUFBd0Msd0NBQXFCdEMsR0FBRyxDQUFDK0IsTUFBSixDQUFXRSxPQUFYLENBQW1CeEUsR0FBeEMsQ0FBOUM7QUFDQSxhQUFPLEtBQUt0QixLQUFMLENBQVcyQixZQUFYLENBQXdCc0UsU0FBeEIsRUFBbUNDLFFBQW5DLEVBQTZDQyxjQUE3QyxDQUFQO0FBQ0QsS0F2ZWtCOztBQUFBLGtEQW1mSXRDLEdBQUcsSUFBSTtBQUM1QixZQUFNdUMsUUFBUSxHQUFHdkMsR0FBRyxDQUFDZ0MsYUFBSixDQUFrQkMsT0FBbEIsQ0FBMEJPLFFBQTNDO0FBQ0E7O0FBQ0EsVUFBSSxDQUFDRCxRQUFMLEVBQWU7QUFDYixlQUFPLElBQVA7QUFDRDs7QUFFRCxZQUFNO0FBQUNuRSxRQUFBQSxNQUFEO0FBQVNELFFBQUFBO0FBQVQsVUFBcUIsS0FBS2hDLEtBQUwsQ0FBV3NHLGNBQVgsQ0FBMEJDLElBQTFCLENBQStCQyxJQUFJLElBQUlBLElBQUksQ0FBQ3ZFLE1BQUwsQ0FBWWxCLEVBQVosS0FBbUJxRixRQUExRCxDQUEzQjtBQUNBLFlBQU1yQixXQUFXLEdBQUcsS0FBS0MsWUFBTCxDQUFrQjNDLEdBQWxCLENBQXNCK0QsUUFBdEIsQ0FBcEI7QUFFQSxhQUFPLEtBQUtYLFdBQUwsQ0FBaUJWLFdBQWpCLEVBQThCOUMsTUFBOUIsRUFBc0NELFFBQVEsQ0FBQ0EsUUFBUSxDQUFDa0QsTUFBVCxHQUFrQixDQUFuQixDQUE5QyxDQUFQO0FBQ0QsS0E5ZmtCOztBQUdqQixTQUFLdUIsVUFBTCxHQUFrQixJQUFJbkUscUJBQUosRUFBbEI7QUFDQSxTQUFLMEMsWUFBTCxHQUFvQixJQUFJMEIsR0FBSixFQUFwQjtBQUNBLFNBQUt0RSxhQUFMLEdBQXFCLElBQUlzRSxHQUFKLEVBQXJCO0FBQ0EsU0FBSy9GLEtBQUwsR0FBYTtBQUNYZ0csTUFBQUEsWUFBWSxFQUFFO0FBREgsS0FBYjtBQUdBLFNBQUtDLElBQUwsR0FBWSxJQUFJQyw2QkFBSixFQUFaO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFVBQU07QUFBQ0MsTUFBQUE7QUFBRCxRQUFxQixLQUFLL0csS0FBaEM7O0FBQ0EsUUFBSStHLGdCQUFKLEVBQXNCO0FBQ3BCLFdBQUtDLGNBQUwsQ0FBb0JELGdCQUFwQjtBQUNEO0FBQ0Y7O0FBRURFLEVBQUFBLGtCQUFrQixDQUFDQyxTQUFELEVBQVk7QUFDNUIsVUFBTTtBQUFDSCxNQUFBQTtBQUFELFFBQXFCLEtBQUsvRyxLQUFoQzs7QUFDQSxRQUFJK0csZ0JBQWdCLElBQUlBLGdCQUFnQixLQUFLRyxTQUFTLENBQUNILGdCQUF2RCxFQUF5RTtBQUN2RSxXQUFLQyxjQUFMLENBQW9CRCxnQkFBcEI7QUFDRDtBQUNGOztBQUVESSxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLUCxJQUFMLENBQVVRLE9BQVY7QUFDRDs7QUFFREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FDRTtBQUFLLE1BQUEsU0FBUyxFQUFDLGdCQUFmO0FBQWdDLE1BQUEsR0FBRyxFQUFFLEtBQUtaLFVBQUwsQ0FBZ0J2QztBQUFyRCxPQUNHLEtBQUtvRCxjQUFMLEVBREgsRUFFRyxLQUFLQyxZQUFMLEVBRkgsRUFHRTtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRyxLQUFLQyxxQkFBTCxFQURILEVBRUcsS0FBS0MsMEJBQUwsRUFGSCxDQUhGLENBREY7QUFVRDs7QUFFREgsRUFBQUEsY0FBYyxHQUFHO0FBQ2YsV0FDRSxnQ0FBQyxlQUFELFFBQ0UsZ0NBQUMsb0JBQUQ7QUFBVSxNQUFBLFFBQVEsRUFBRSxLQUFLdEgsS0FBTCxDQUFXaUIsUUFBL0I7QUFBeUMsTUFBQSxNQUFNLEVBQUUsS0FBS3dGO0FBQXRELE9BQ0UsZ0NBQUMsaUJBQUQ7QUFBUyxNQUFBLE9BQU8sRUFBQyxxQkFBakI7QUFBdUMsTUFBQSxRQUFRLEVBQUUsS0FBS3pHLEtBQUwsQ0FBVzBIO0FBQTVELE1BREYsRUFFRSxnQ0FBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHFCQUFqQjtBQUF1QyxNQUFBLFFBQVEsRUFBRSxLQUFLMUgsS0FBTCxDQUFXMkg7QUFBNUQsTUFGRixDQURGLEVBS0UsZ0NBQUMsb0JBQUQ7QUFBVSxNQUFBLFFBQVEsRUFBRSxLQUFLM0gsS0FBTCxDQUFXaUIsUUFBL0I7QUFBeUMsTUFBQSxNQUFNLEVBQUM7QUFBaEQsT0FDRSxnQ0FBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHVCQUFqQjtBQUF5QyxNQUFBLFFBQVEsRUFBRSxLQUFLMkc7QUFBeEQsTUFERixDQUxGLENBREY7QUFXRDs7QUFFREwsRUFBQUEsWUFBWSxHQUFHO0FBQ2IsVUFBTU0sT0FBTyxHQUFHLE1BQU07QUFDcEIsVUFBSSxLQUFLbEgsS0FBTCxDQUFXZ0csWUFBZixFQUE2QjtBQUMzQjtBQUNEOztBQUNELFdBQUttQixRQUFMLENBQWM7QUFBQ25CLFFBQUFBLFlBQVksRUFBRTtBQUFmLE9BQWQ7QUFDQSxZQUFNb0IsR0FBRyxHQUFHLEtBQUsvSCxLQUFMLENBQVdnSSxPQUFYLENBQW1CLE1BQU07QUFDbkMsYUFBS3BCLElBQUwsQ0FBVXFCLE1BQVYsQ0FBaUJGLEdBQWpCO0FBQ0EsYUFBS0QsUUFBTCxDQUFjO0FBQUNuQixVQUFBQSxZQUFZLEVBQUU7QUFBZixTQUFkO0FBQ0QsT0FIVyxDQUFaO0FBSUEsV0FBS0MsSUFBTCxDQUFVc0IsR0FBVixDQUFjSCxHQUFkO0FBQ0QsS0FWRDs7QUFXQSxXQUNFO0FBQVEsTUFBQSxTQUFTLEVBQUM7QUFBbEIsT0FDRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE1BREYsRUFFRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLDBCQUVFO0FBQU0sTUFBQSxTQUFTLEVBQUMsMEJBQWhCO0FBQTJDLE1BQUEsT0FBTyxFQUFFLEtBQUsvSCxLQUFMLENBQVdtSTtBQUEvRCxPQUNHLEtBQUtuSSxLQUFMLENBQVdvSSxLQURkLE9BQ3NCLEtBQUtwSSxLQUFMLENBQVdxSSxJQURqQyxPQUN3QyxLQUFLckksS0FBTCxDQUFXc0ksTUFEbkQsQ0FGRixDQUZGLEVBUUU7QUFDRSxNQUFBLFNBQVMsRUFBRSw0QkFDVCwwRUFEUyxFQUVUO0FBQUNDLFFBQUFBLFVBQVUsRUFBRSxLQUFLNUgsS0FBTCxDQUFXZ0c7QUFBeEIsT0FGUyxDQURiO0FBS0UsTUFBQSxPQUFPLEVBQUVrQjtBQUxYLE1BUkYsRUFlRSxnQ0FBQywwQkFBRDtBQUNFLE1BQUEsVUFBVSxFQUFFLEtBQUs3SCxLQUFMLENBQVd1RSxVQUR6QjtBQUVFLE1BQUEsZUFBZSxFQUFDLGlDQUZsQjtBQUdFLE1BQUEsVUFBVSxFQUFFLENBQUMsNkJBQUQ7QUFIZCxNQWZGLENBREY7QUF1QkQ7O0FBTURpRSxFQUFBQSxnQkFBZ0IsR0FBRztBQUNqQixVQUFNO0FBQUNGLE1BQUFBLE1BQUQ7QUFBU0QsTUFBQUEsSUFBVDtBQUFlRCxNQUFBQTtBQUFmLFFBQXdCLEtBQUtwSSxLQUFuQyxDQURpQixDQUVqQjs7QUFDQSxVQUFNeUksY0FBYyxHQUFJLDBCQUF5QkwsS0FBTSxJQUFHQyxJQUFLLFNBQVFDLE1BQU8sU0FBOUU7QUFDQSxXQUNFO0FBQUssTUFBQSxTQUFTLEVBQUM7QUFBZixPQUNFO0FBQUssTUFBQSxHQUFHLEVBQUMsNEJBQVQ7QUFBc0MsTUFBQSxHQUFHLEVBQUMsK0JBQTFDO0FBQTBFLE1BQUEsU0FBUyxFQUFDO0FBQXBGLE1BREYsRUFFRTtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsMENBRkYsRUFLRTtBQUFRLE1BQUEsU0FBUyxFQUFDO0FBQWxCLE9BQ0U7QUFBRyxNQUFBLElBQUksRUFBRUcsY0FBVDtBQUF5QixNQUFBLE9BQU8sRUFBRSxLQUFLQztBQUF2Qyw0QkFERixDQUxGLENBREY7QUFhRDs7QUFFRGxCLEVBQUFBLHFCQUFxQixHQUFHO0FBQ3RCLFFBQUksS0FBS3hILEtBQUwsQ0FBVzJJLFNBQVgsQ0FBcUJ6RCxNQUFyQixLQUFnQyxDQUFwQyxFQUF1QztBQUNyQyxhQUFPLEtBQUtzRCxnQkFBTCxFQUFQO0FBQ0Q7O0FBRUQsVUFBTTVFLE1BQU0sR0FBR0MsR0FBRyxJQUFJO0FBQ3BCQSxNQUFBQSxHQUFHLENBQUNDLGNBQUo7O0FBQ0EsVUFBSSxLQUFLOUQsS0FBTCxDQUFXNEksa0JBQWYsRUFBbUM7QUFDakMsYUFBSzVJLEtBQUwsQ0FBVzZJLGFBQVg7QUFDRCxPQUZELE1BRU87QUFDTCxhQUFLN0ksS0FBTCxDQUFXOEksYUFBWDtBQUNEO0FBQ0YsS0FQRDs7QUFTQSxXQUNFO0FBQ0UsTUFBQSxTQUFTLEVBQUMsa0NBRFo7QUFFRSxNQUFBLElBQUksRUFBRSxLQUFLOUksS0FBTCxDQUFXNEk7QUFGbkIsT0FJRTtBQUFTLE1BQUEsU0FBUyxFQUFDLHVCQUFuQjtBQUEyQyxNQUFBLE9BQU8sRUFBRWhGO0FBQXBELE9BQ0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixtQkFERixDQUpGLEVBT0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUNHLEtBQUs1RCxLQUFMLENBQVcySSxTQUFYLENBQXFCdEQsR0FBckIsQ0FBeUIsS0FBSzBELG1CQUE5QixDQURILENBUEYsQ0FERjtBQWNEOztBQW9FRHRCLEVBQUFBLDBCQUEwQixHQUFHO0FBQzNCLFVBQU1uQixjQUFjLEdBQUcsS0FBS3RHLEtBQUwsQ0FBV3NHLGNBQWxDOztBQUNBLFFBQUlBLGNBQWMsQ0FBQ3BCLE1BQWYsS0FBMEIsQ0FBOUIsRUFBaUM7QUFDL0IsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQsVUFBTThELGVBQWUsR0FBRzFDLGNBQWMsQ0FBQzJDLE1BQWYsQ0FBc0JDLElBQUksSUFBSUEsSUFBSSxDQUFDakgsTUFBTCxDQUFZa0MsVUFBMUMsQ0FBeEI7QUFDQSxVQUFNZ0YsaUJBQWlCLEdBQUc3QyxjQUFjLENBQUMyQyxNQUFmLENBQXNCQyxJQUFJLElBQUksQ0FBQ0EsSUFBSSxDQUFDakgsTUFBTCxDQUFZa0MsVUFBM0MsQ0FBMUI7O0FBRUEsVUFBTWlGLGNBQWMsR0FBR3ZGLEdBQUcsSUFBSTtBQUM1QkEsTUFBQUEsR0FBRyxDQUFDQyxjQUFKOztBQUNBLFVBQUksS0FBSzlELEtBQUwsQ0FBV3FKLGtCQUFmLEVBQW1DO0FBQ2pDLGFBQUtySixLQUFMLENBQVdzSixZQUFYO0FBQ0QsT0FGRCxNQUVPO0FBQ0wsYUFBS3RKLEtBQUwsQ0FBV3VKLFlBQVg7QUFDRDtBQUNGLEtBUEQ7O0FBU0EsV0FDRTtBQUNFLE1BQUEsU0FBUyxFQUFDLGlDQURaO0FBRUUsTUFBQSxJQUFJLEVBQUUsS0FBS3ZKLEtBQUwsQ0FBV3FKO0FBRm5CLE9BSUU7QUFBUyxNQUFBLFNBQVMsRUFBQyx1QkFBbkI7QUFBMkMsTUFBQSxPQUFPLEVBQUVEO0FBQXBELE9BQ0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixrQkFERixFQUVFO0FBQU0sTUFBQSxTQUFTLEVBQUM7QUFBaEIsT0FDRTtBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLG1CQUVHLEdBRkgsRUFFTztBQUFNLE1BQUEsU0FBUyxFQUFDO0FBQWhCLE9BQTBDSixlQUFlLENBQUM5RCxNQUExRCxDQUZQLEVBRWdGLEdBRmhGLFFBSUcsR0FKSCxFQUlPO0FBQU0sTUFBQSxTQUFTLEVBQUM7QUFBaEIsT0FBMEM4RCxlQUFlLENBQUM5RCxNQUFoQixHQUF5QmlFLGlCQUFpQixDQUFDakUsTUFBckYsQ0FKUCxDQURGLEVBT0U7QUFDRSxNQUFBLFNBQVMsRUFBQywyQkFEWjtBQUN3QyxNQUFBLEtBQUssRUFBRThELGVBQWUsQ0FBQzlELE1BRC9EO0FBRUUsTUFBQSxHQUFHLEVBQUU4RCxlQUFlLENBQUM5RCxNQUFoQixHQUF5QmlFLGlCQUFpQixDQUFDakU7QUFGbEQsTUFQRixDQUZGLENBSkYsRUFvQkdpRSxpQkFBaUIsQ0FBQ2pFLE1BQWxCLEdBQTJCLENBQTNCLElBQWdDO0FBQU0sTUFBQSxTQUFTLEVBQUM7QUFBaEIsT0FDOUJpRSxpQkFBaUIsQ0FBQzlELEdBQWxCLENBQXNCLEtBQUttRSx5QkFBM0IsQ0FEOEIsQ0FwQm5DLEVBdUJHUixlQUFlLENBQUM5RCxNQUFoQixHQUF5QixDQUF6QixJQUE4QjtBQUFTLE1BQUEsU0FBUyxFQUFDLDBDQUFuQjtBQUE4RCxNQUFBLElBQUk7QUFBbEUsT0FDN0I7QUFBUyxNQUFBLFNBQVMsRUFBQztBQUFuQixPQUNFO0FBQU0sTUFBQSxTQUFTLEVBQUM7QUFBaEIsa0JBREYsQ0FENkIsRUFJN0I7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUNHOEQsZUFBZSxDQUFDM0QsR0FBaEIsQ0FBb0IsS0FBS21FLHlCQUF6QixDQURILENBSjZCLENBdkJqQyxDQURGO0FBbUNEOztBQXlMRGpJLEVBQUFBLGdCQUFnQixDQUFDa0ksTUFBRCxFQUFTO0FBQ3ZCLFFBQUksQ0FBQ0EsTUFBTSxDQUFDQyxZQUFaLEVBQTBCO0FBQ3hCLGFBQU8sSUFBUDtBQUNELEtBRkQsTUFFTztBQUNMLGFBQ0U7QUFBTSxRQUFBLFNBQVMsRUFBQztBQUFoQiwyQkFFRTtBQUFHLFFBQUEsU0FBUyxFQUFDLHNCQUFiO0FBQW9DLFFBQUEsSUFBSSxFQUFFRCxNQUFNLENBQUNuSTtBQUFqRCxrQkFGRixDQURGO0FBTUQ7QUFDRjs7QUFFREUsRUFBQUEsdUJBQXVCLENBQUNpSSxNQUFELEVBQVM7QUFDOUIsVUFBTUUsSUFBSSxHQUFHdksscUJBQXFCLENBQUNxSyxNQUFNLENBQUNHLGlCQUFSLENBQWxDOztBQUNBLFFBQUksQ0FBQ0QsSUFBTCxFQUFXO0FBQUUsYUFBTyxJQUFQO0FBQWM7O0FBQzNCLFdBQ0U7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUE4REEsSUFBOUQsQ0FERjtBQUdEOztBQW1CRGxFLEVBQUFBLFdBQVcsQ0FBQ1YsV0FBRCxFQUFjOUMsTUFBZCxFQUFzQmdELFdBQXRCLEVBQW1DO0FBQzVDLFVBQU00RSxJQUFJLEdBQUc5RSxXQUFXLENBQUNNLEdBQVosQ0FBZ0J5RSxNQUFNLElBQUlBLE1BQU0sQ0FBQ0MsT0FBUCxFQUExQixFQUE0Q0MsS0FBNUMsQ0FBa0QsRUFBbEQsQ0FBYjs7QUFDQSxVQUFNQyxnQkFBZ0IsR0FBRyxNQUFNbEYsV0FBVyxDQUFDTSxHQUFaLENBQWdCeUUsTUFBTSxJQUFJQSxNQUFNLENBQUNJLE9BQVAsQ0FBZSxFQUFmLEVBQW1CO0FBQUNDLE1BQUFBLGNBQWMsRUFBRTtBQUFqQixLQUFuQixDQUExQixDQUEvQjs7QUFDQSxVQUFNQyxjQUFjLEdBQUcsTUFBTXJGLFdBQVcsQ0FBQ00sR0FBWixDQUFnQnlFLE1BQU0sSUFBSUEsTUFBTSxDQUFDSSxPQUFQLENBQWVMLElBQWYsRUFBcUI7QUFBQ00sTUFBQUEsY0FBYyxFQUFFO0FBQWpCLEtBQXJCLENBQTFCLENBQTdCOztBQUVBLFdBQU8sS0FBS25LLEtBQUwsQ0FBV3FLLGdCQUFYLENBQ0xSLElBREssRUFDQzVILE1BQU0sQ0FBQ2xCLEVBRFIsRUFDWWtFLFdBQVcsQ0FBQ2xFLEVBRHhCLEVBQzRCa0UsV0FBVyxDQUFDeEMsSUFEeEMsRUFDOEN3QyxXQUFXLENBQUNSLFFBRDFELEVBQ29FO0FBQUN3RixNQUFBQSxnQkFBRDtBQUFtQkcsTUFBQUE7QUFBbkIsS0FEcEUsQ0FBUDtBQUdEOztBQWVEckgsRUFBQUEscUJBQXFCLENBQUNiLFdBQUQsRUFBYztBQUNqQyxRQUFJVyxVQUFKLEVBQWdCQyxZQUFoQjtBQUNBLFVBQU13SCxZQUFZLEdBQUcsS0FBS3RLLEtBQUwsQ0FBV3VLLG1CQUFoQzs7QUFFQSxVQUFNQyx1QkFBdUIsR0FBRyxLQUFLeEssS0FBTCxDQUFXdUUsVUFBWCxDQUFzQmtHLEdBQXRCLE9BQWdDQyxxQ0FBZUMsT0FBL0U7O0FBQ0EsUUFBSUwsWUFBWSxLQUFLLElBQXJCLEVBQTJCO0FBQ3pCekgsTUFBQUEsVUFBVSxHQUFHLElBQWI7QUFDQUMsTUFBQUEsWUFBWSxHQUFHLEVBQWY7QUFDRCxLQUhELE1BR08sSUFBSVosV0FBVyxDQUFDdUMsUUFBWixLQUF5QixJQUE3QixFQUFtQztBQUN4QzVCLE1BQUFBLFVBQVUsR0FBRyxJQUFiO0FBQ0FDLE1BQUFBLFlBQVksR0FBRyxVQUFmO0FBQ0QsS0FITSxNQUdBO0FBQ0wsWUFBTThILG1CQUFtQixHQUFHTixZQUFZLENBQUNqSSxHQUFiLENBQWlCSCxXQUFXLENBQUNPLElBQTdCLENBQTVCO0FBQ0FJLE1BQUFBLFVBQVUsR0FBRytILG1CQUFtQixDQUFDQyxrQkFBcEIsQ0FBdUN4SSxHQUF2QyxDQUEyQzJELFFBQVEsQ0FBQzlELFdBQVcsQ0FBQ3VDLFFBQWIsRUFBdUIsRUFBdkIsQ0FBbkQsQ0FBYjs7QUFDQSxVQUFJbUcsbUJBQW1CLENBQUNFLGdCQUFwQixJQUF3Q04sdUJBQTVDLEVBQXFFO0FBQ25FM0gsUUFBQUEsVUFBVSxHQUFHK0gsbUJBQW1CLENBQUNFLGdCQUFwQixDQUFxQ3pJLEdBQXJDLENBQXlDUSxVQUF6QyxFQUFxRGtJLFdBQWxFO0FBQ0Q7O0FBQ0RqSSxNQUFBQSxZQUFZLEdBQUdELFVBQWY7QUFDRDs7QUFFRCxXQUFPO0FBQUNBLE1BQUFBLFVBQUQ7QUFBYUMsTUFBQUE7QUFBYixLQUFQO0FBQ0Q7QUFFRDs7O0FBQ0FrRSxFQUFBQSxjQUFjLENBQUNaLFFBQUQsRUFBVztBQUN2QixVQUFNakUsWUFBWSxHQUFHLEtBQUtDLGFBQUwsQ0FBbUJDLEdBQW5CLENBQXVCK0QsUUFBdkIsQ0FBckI7O0FBQ0EsUUFBSWpFLFlBQUosRUFBa0I7QUFDaEJBLE1BQUFBLFlBQVksQ0FBQ2tELEdBQWIsQ0FBaUIyRixPQUFPLElBQUk7QUFDMUJBLFFBQUFBLE9BQU8sQ0FBQ0Msc0JBQVI7QUFDQSxlQUFPLElBQVAsQ0FGMEIsQ0FFYjtBQUNkLE9BSEQ7QUFJRDtBQUNGOztBQUVELFFBQU10RixzQkFBTixDQUE2QjFELE1BQTdCLEVBQXFDO0FBQ25DLFFBQUlBLE1BQU0sQ0FBQ2tDLFVBQVgsRUFBdUI7QUFDckIsWUFBTSxLQUFLbkUsS0FBTCxDQUFXa0wsZUFBWCxDQUEyQmpKLE1BQTNCLENBQU47QUFDRCxLQUZELE1BRU87QUFDTCxZQUFNLEtBQUtqQyxLQUFMLENBQVdtTCxhQUFYLENBQXlCbEosTUFBekIsQ0FBTjtBQUNEO0FBQ0Y7O0FBL21Cc0Q7Ozs7Z0JBQXBDckMsVyxlQUNBO0FBQ2pCO0FBQ0F3TCxFQUFBQSxLQUFLLEVBQUVDLHNCQUFVQyxLQUFWLENBQWdCO0FBQ3JCQyxJQUFBQSxXQUFXLEVBQUVGLHNCQUFVRyxNQUFWLENBQWlCQztBQURULEdBQWhCLEVBRUpBLFVBSmM7QUFLakJDLEVBQUFBLFVBQVUsRUFBRUwsc0JBQVVHLE1BQVYsQ0FBaUJDLFVBTFo7QUFNakJFLEVBQUFBLFdBQVcsRUFBRU4sc0JBQVVHLE1BQVYsQ0FBaUJDLFVBTmI7QUFPakI5QyxFQUFBQSxTQUFTLEVBQUUwQyxzQkFBVU8sS0FBVixDQUFnQkgsVUFQVjtBQVFqQm5GLEVBQUFBLGNBQWMsRUFBRStFLHNCQUFVUSxPQUFWLENBQWtCUixzQkFBVUMsS0FBVixDQUFnQjtBQUNoRHJKLElBQUFBLE1BQU0sRUFBRW9KLHNCQUFVRyxNQUFWLENBQWlCQyxVQUR1QjtBQUVoRHpKLElBQUFBLFFBQVEsRUFBRXFKLHNCQUFVUSxPQUFWLENBQWtCUixzQkFBVUcsTUFBNUIsRUFBb0NDO0FBRkUsR0FBaEIsQ0FBbEIsQ0FSQztBQVlqQnpELEVBQUFBLE9BQU8sRUFBRXFELHNCQUFVUyxJQUFWLENBQWVMLFVBWlA7QUFjakI7QUFDQTlHLEVBQUFBLGNBQWMsRUFBRTBHLHNCQUFVRyxNQUFWLENBQWlCQyxVQWZoQjtBQWdCakI3RyxFQUFBQSxZQUFZLEVBQUV5RyxzQkFBVS9DLE1BQVYsQ0FBaUJtRCxVQWhCZDtBQWlCakJsSCxFQUFBQSxVQUFVLEVBQUV3SCx3Q0FBNEJOLFVBakJ2QjtBQWtCakI3QyxFQUFBQSxrQkFBa0IsRUFBRXlDLHNCQUFVVyxJQUFWLENBQWVQLFVBbEJsQjtBQW1CakJwQyxFQUFBQSxrQkFBa0IsRUFBRWdDLHNCQUFVVyxJQUFWLENBQWVQLFVBbkJsQjtBQW9CakJqSSxFQUFBQSxhQUFhLEVBQUU2SCxzQkFBVUMsS0FBVixDQUFnQjtBQUM3QjdILElBQUFBLEdBQUcsRUFBRTRILHNCQUFVUyxJQUFWLENBQWVMO0FBRFMsR0FBaEIsQ0FwQkU7QUF1QmpCOUgsRUFBQUEsb0JBQW9CLEVBQUUwSCxzQkFBVUMsS0FBVixDQUFnQjtBQUNwQzdILElBQUFBLEdBQUcsRUFBRTRILHNCQUFVUyxJQUFWLENBQWVMO0FBRGdCLEdBQWhCLENBdkJMO0FBMEJqQnJHLEVBQUFBLGlCQUFpQixFQUFFaUcsc0JBQVVZLE1BMUJaO0FBMkJqQmxGLEVBQUFBLGdCQUFnQixFQUFFc0Usc0JBQVVZLE1BM0JYO0FBNEJqQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTFCLEVBQUFBLG1CQUFtQixFQUFFYyxzQkFBVUcsTUFsQ2Q7QUFvQ2pCO0FBQ0FsRCxFQUFBQSxNQUFNLEVBQUUrQyxzQkFBVS9DLE1BQVYsQ0FBaUJtRCxVQXJDUjtBQXNDakJwRCxFQUFBQSxJQUFJLEVBQUVnRCxzQkFBVVksTUFBVixDQUFpQlIsVUF0Q047QUF1Q2pCckQsRUFBQUEsS0FBSyxFQUFFaUQsc0JBQVVZLE1BQVYsQ0FBaUJSLFVBdkNQO0FBd0NqQlMsRUFBQUEsT0FBTyxFQUFFYixzQkFBVVksTUFBVixDQUFpQlIsVUF4Q1Q7QUEwQ2pCO0FBQ0FVLEVBQUFBLFNBQVMsRUFBRWQsc0JBQVVHLE1BQVYsQ0FBaUJDLFVBM0NYO0FBNENqQjVHLEVBQUFBLE1BQU0sRUFBRXdHLHNCQUFVRyxNQUFWLENBQWlCQyxVQTVDUjtBQTZDakJ4SyxFQUFBQSxRQUFRLEVBQUVvSyxzQkFBVUcsTUFBVixDQUFpQkMsVUE3Q1Y7QUE4Q2pCNUosRUFBQUEsUUFBUSxFQUFFd0osc0JBQVVHLE1BQVYsQ0FBaUJDLFVBOUNWO0FBK0NqQnpLLEVBQUFBLE9BQU8sRUFBRXFLLHNCQUFVUyxJQUFWLENBQWVMLFVBL0NQO0FBaURqQjtBQUNBbkgsRUFBQUEsUUFBUSxFQUFFK0csc0JBQVVTLElBQVYsQ0FBZUwsVUFsRFI7QUFtRGpCL0csRUFBQUEsUUFBUSxFQUFFMkcsc0JBQVVTLElBQVYsQ0FBZUwsVUFuRFI7QUFvRGpCdEQsRUFBQUEsTUFBTSxFQUFFa0Qsc0JBQVVTLElBQVYsQ0FBZUwsVUFwRE47QUFxRGpCL0QsRUFBQUEsV0FBVyxFQUFFMkQsc0JBQVVTLElBQVYsQ0FBZUwsVUFyRFg7QUFzRGpCOUQsRUFBQUEsV0FBVyxFQUFFMEQsc0JBQVVTLElBQVYsQ0FBZUwsVUF0RFg7QUF1RGpCOUosRUFBQUEsWUFBWSxFQUFFMEosc0JBQVVTLElBQVYsQ0FBZUwsVUF2RFo7QUF3RGpCM0MsRUFBQUEsYUFBYSxFQUFFdUMsc0JBQVVTLElBQVYsQ0FBZUwsVUF4RGI7QUF5RGpCNUMsRUFBQUEsYUFBYSxFQUFFd0Msc0JBQVVTLElBQVYsQ0FBZUwsVUF6RGI7QUEwRGpCbEMsRUFBQUEsWUFBWSxFQUFFOEIsc0JBQVVTLElBQVYsQ0FBZUwsVUExRFo7QUEyRGpCbkMsRUFBQUEsWUFBWSxFQUFFK0Isc0JBQVVTLElBQVYsQ0FBZUwsVUEzRFo7QUE0RGpCeEgsRUFBQUEsWUFBWSxFQUFFb0gsc0JBQVVTLElBQVYsQ0FBZUwsVUE1RFo7QUE2RGpCekgsRUFBQUEsWUFBWSxFQUFFcUgsc0JBQVVTLElBQVYsQ0FBZUwsVUE3RFo7QUE4RGpCTixFQUFBQSxhQUFhLEVBQUVFLHNCQUFVUyxJQUFWLENBQWVMLFVBOURiO0FBK0RqQlAsRUFBQUEsZUFBZSxFQUFFRyxzQkFBVVMsSUFBVixDQUFlTCxVQS9EZjtBQWdFakJwQixFQUFBQSxnQkFBZ0IsRUFBRWdCLHNCQUFVUyxJQUFWLENBQWVMLFVBaEVoQjtBQWlFakJsRyxFQUFBQSxhQUFhLEVBQUU4RixzQkFBVVMsSUFBVixDQUFlTCxVQWpFYjtBQWtFakJ2SyxFQUFBQSxhQUFhLEVBQUVtSyxzQkFBVVMsSUFBVixDQUFlTCxVQWxFYjtBQW1FakIzSixFQUFBQSxnQkFBZ0IsRUFBRXVKLHNCQUFVUyxJQUFWLENBQWVMO0FBbkVoQixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuNDEuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCBSZWFjdCwge0ZyYWdtZW50fSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IGN4IGZyb20gJ2NsYXNzbmFtZXMnO1xuaW1wb3J0IHtDb21wb3NpdGVEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuXG5pbXBvcnQge0VuYWJsZWFibGVPcGVyYXRpb25Qcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgVG9vbHRpcCBmcm9tICcuLi9hdG9tL3Rvb2x0aXAnO1xuaW1wb3J0IENvbW1hbmRzLCB7Q29tbWFuZH0gZnJvbSAnLi4vYXRvbS9jb21tYW5kcyc7XG5pbXBvcnQgQXRvbVRleHRFZGl0b3IgZnJvbSAnLi4vYXRvbS9hdG9tLXRleHQtZWRpdG9yJztcbmltcG9ydCB7Z2V0RGF0YUZyb21HaXRodWJVcmx9IGZyb20gJy4vaXNzdWVpc2gtbGluayc7XG5pbXBvcnQgRW1vamlSZWFjdGlvbnNDb250cm9sbGVyIGZyb20gJy4uL2NvbnRyb2xsZXJzL2Vtb2ppLXJlYWN0aW9ucy1jb250cm9sbGVyJztcbmltcG9ydCB7Y2hlY2tvdXRTdGF0ZXN9IGZyb20gJy4uL2NvbnRyb2xsZXJzL3ByLWNoZWNrb3V0LWNvbnRyb2xsZXInO1xuaW1wb3J0IEdpdGh1YkRvdGNvbU1hcmtkb3duIGZyb20gJy4vZ2l0aHViLWRvdGNvbS1tYXJrZG93bic7XG5pbXBvcnQgUGF0Y2hQcmV2aWV3VmlldyBmcm9tICcuL3BhdGNoLXByZXZpZXctdmlldyc7XG5pbXBvcnQgUmV2aWV3Q29tbWVudFZpZXcgZnJvbSAnLi9yZXZpZXctY29tbWVudC12aWV3JztcbmltcG9ydCBBY3Rpb25hYmxlUmV2aWV3VmlldyBmcm9tICcuL2FjdGlvbmFibGUtcmV2aWV3LXZpZXcnO1xuaW1wb3J0IENoZWNrb3V0QnV0dG9uIGZyb20gJy4vY2hlY2tvdXQtYnV0dG9uJztcbmltcG9ydCBPY3RpY29uIGZyb20gJy4uL2F0b20vb2N0aWNvbic7XG5pbXBvcnQgVGltZWFnbyBmcm9tICcuL3RpbWVhZ28nO1xuaW1wb3J0IFJlZkhvbGRlciBmcm9tICcuLi9tb2RlbHMvcmVmLWhvbGRlcic7XG5pbXBvcnQge3RvTmF0aXZlUGF0aFNlcCwgR0hPU1RfVVNFUn0gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQge2FkZEV2ZW50fSBmcm9tICcuLi9yZXBvcnRlci1wcm94eSc7XG5cbmNvbnN0IGF1dGhvckFzc29jaWF0aW9uVGV4dCA9IHtcbiAgTUVNQkVSOiAnTWVtYmVyJyxcbiAgT1dORVI6ICdPd25lcicsXG4gIENPTExBQk9SQVRPUjogJ0NvbGxhYm9yYXRvcicsXG4gIENPTlRSSUJVVE9SOiAnQ29udHJpYnV0b3InLFxuICBGSVJTVF9USU1FX0NPTlRSSUJVVE9SOiAnRmlyc3QtdGltZSBjb250cmlidXRvcicsXG4gIEZJUlNUX1RJTUVSOiAnRmlyc3QtdGltZXInLFxuICBOT05FOiBudWxsLFxufTtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUmV2aWV3c1ZpZXcgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIC8vIFJlbGF5IHJlc3VsdHNcbiAgICByZWxheTogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIGVudmlyb25tZW50OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgfSkuaXNSZXF1aXJlZCxcbiAgICByZXBvc2l0b3J5OiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgcHVsbFJlcXVlc3Q6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBzdW1tYXJpZXM6IFByb3BUeXBlcy5hcnJheS5pc1JlcXVpcmVkLFxuICAgIGNvbW1lbnRUaHJlYWRzOiBQcm9wVHlwZXMuYXJyYXlPZihQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgdGhyZWFkOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgICBjb21tZW50czogUHJvcFR5cGVzLmFycmF5T2YoUHJvcFR5cGVzLm9iamVjdCkuaXNSZXF1aXJlZCxcbiAgICB9KSksXG4gICAgcmVmZXRjaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIC8vIFBhY2thZ2UgbW9kZWxzXG4gICAgbXVsdGlGaWxlUGF0Y2g6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb250ZXh0TGluZXM6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICBjaGVja291dE9wOiBFbmFibGVhYmxlT3BlcmF0aW9uUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBzdW1tYXJ5U2VjdGlvbk9wZW46IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG4gICAgY29tbWVudFNlY3Rpb25PcGVuOiBQcm9wVHlwZXMuYm9vbC5pc1JlcXVpcmVkLFxuICAgIHRocmVhZElEc09wZW46IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBoYXM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgfSksXG4gICAgaGlnaGxpZ2h0ZWRUaHJlYWRJRHM6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBoYXM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgfSksXG4gICAgcG9zdGluZ1RvVGhyZWFkSUQ6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgc2Nyb2xsVG9UaHJlYWRJRDogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAvLyBTdHJ1Y3R1cmU6IE1hcDwgcmVsYXRpdmVQYXRoOiBTdHJpbmcsIHtcbiAgICAvLyAgIHJhd1Bvc2l0aW9uczogU2V0PGxpbmVOdW1iZXJzOiBOdW1iZXI+LFxuICAgIC8vICAgZGlmZlRvRmlsZVBvc2l0aW9uOiBNYXA8cmF3UG9zaXRpb246IE51bWJlciwgYWRqdXN0ZWRQb3NpdGlvbjogTnVtYmVyPixcbiAgICAvLyAgIGZpbGVUcmFuc2xhdGlvbnM6IG51bGwgfCBNYXA8YWRqdXN0ZWRQb3NpdGlvbjogTnVtYmVyLCB7bmV3UG9zaXRpb246IE51bWJlcn0+LFxuICAgIC8vICAgZGlnZXN0OiBTdHJpbmcsXG4gICAgLy8gfT5cbiAgICBjb21tZW50VHJhbnNsYXRpb25zOiBQcm9wVHlwZXMub2JqZWN0LFxuXG4gICAgLy8gZm9yIHRoZSBkb3Rjb20gbGluayBpbiB0aGUgZW1wdHkgc3RhdGVcbiAgICBudW1iZXI6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICByZXBvOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgb3duZXI6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICB3b3JrZGlyOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBdG9tIGVudmlyb25tZW50XG4gICAgd29ya3NwYWNlOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29uZmlnOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29tbWFuZHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB0b29sdGlwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbmZpcm06IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBY3Rpb24gbWV0aG9kc1xuICAgIG9wZW5GaWxlOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9wZW5EaWZmOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9wZW5QUjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBtb3JlQ29udGV4dDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBsZXNzQ29udGV4dDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBvcGVuSXNzdWVpc2g6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgc2hvd1N1bW1hcmllczogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBoaWRlU3VtbWFyaWVzOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHNob3dDb21tZW50czogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBoaWRlQ29tbWVudHM6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgc2hvd1RocmVhZElEOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGhpZGVUaHJlYWRJRDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICByZXNvbHZlVGhyZWFkOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHVucmVzb2x2ZVRocmVhZDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBhZGRTaW5nbGVDb21tZW50OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIHVwZGF0ZUNvbW1lbnQ6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgdXBkYXRlU3VtbWFyeTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICByZXBvcnRSZWxheUVycm9yOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLnJvb3RIb2xkZXIgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgdGhpcy5yZXBseUhvbGRlcnMgPSBuZXcgTWFwKCk7XG4gICAgdGhpcy50aHJlYWRIb2xkZXJzID0gbmV3IE1hcCgpO1xuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICBpc1JlZnJlc2hpbmc6IGZhbHNlLFxuICAgIH07XG4gICAgdGhpcy5zdWJzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIGNvbnN0IHtzY3JvbGxUb1RocmVhZElEfSA9IHRoaXMucHJvcHM7XG4gICAgaWYgKHNjcm9sbFRvVGhyZWFkSUQpIHtcbiAgICAgIHRoaXMuc2Nyb2xsVG9UaHJlYWQoc2Nyb2xsVG9UaHJlYWRJRCk7XG4gICAgfVxuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKHByZXZQcm9wcykge1xuICAgIGNvbnN0IHtzY3JvbGxUb1RocmVhZElEfSA9IHRoaXMucHJvcHM7XG4gICAgaWYgKHNjcm9sbFRvVGhyZWFkSUQgJiYgc2Nyb2xsVG9UaHJlYWRJRCAhPT0gcHJldlByb3BzLnNjcm9sbFRvVGhyZWFkSUQpIHtcbiAgICAgIHRoaXMuc2Nyb2xsVG9UaHJlYWQoc2Nyb2xsVG9UaHJlYWRJRCk7XG4gICAgfVxuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5zdWJzLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3c1wiIHJlZj17dGhpcy5yb290SG9sZGVyLnNldHRlcn0+XG4gICAgICAgIHt0aGlzLnJlbmRlckNvbW1hbmRzKCl9XG4gICAgICAgIHt0aGlzLnJlbmRlckhlYWRlcigpfVxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWxpc3RcIj5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJSZXZpZXdTdW1tYXJpZXMoKX1cbiAgICAgICAgICB7dGhpcy5yZW5kZXJSZXZpZXdDb21tZW50VGhyZWFkcygpfVxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJDb21tYW5kcygpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPEZyYWdtZW50PlxuICAgICAgICA8Q29tbWFuZHMgcmVnaXN0cnk9e3RoaXMucHJvcHMuY29tbWFuZHN9IHRhcmdldD17dGhpcy5yb290SG9sZGVyfT5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOm1vcmUtY29udGV4dFwiIGNhbGxiYWNrPXt0aGlzLnByb3BzLm1vcmVDb250ZXh0fSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJnaXRodWI6bGVzcy1jb250ZXh0XCIgY2FsbGJhY2s9e3RoaXMucHJvcHMubGVzc0NvbnRleHR9IC8+XG4gICAgICAgIDwvQ29tbWFuZHM+XG4gICAgICAgIDxDb21tYW5kcyByZWdpc3RyeT17dGhpcy5wcm9wcy5jb21tYW5kc30gdGFyZ2V0PVwiLmdpdGh1Yi1SZXZpZXctcmVwbHlcIj5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOnN1Ym1pdC1jb21tZW50XCIgY2FsbGJhY2s9e3RoaXMuc3VibWl0Q3VycmVudENvbW1lbnR9IC8+XG4gICAgICAgIDwvQ29tbWFuZHM+XG4gICAgICA8L0ZyYWdtZW50PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJIZWFkZXIoKSB7XG4gICAgY29uc3QgcmVmcmVzaCA9ICgpID0+IHtcbiAgICAgIGlmICh0aGlzLnN0YXRlLmlzUmVmcmVzaGluZykge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG4gICAgICB0aGlzLnNldFN0YXRlKHtpc1JlZnJlc2hpbmc6IHRydWV9KTtcbiAgICAgIGNvbnN0IHN1YiA9IHRoaXMucHJvcHMucmVmZXRjaCgoKSA9PiB7XG4gICAgICAgIHRoaXMuc3Vicy5yZW1vdmUoc3ViKTtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZSh7aXNSZWZyZXNoaW5nOiBmYWxzZX0pO1xuICAgICAgfSk7XG4gICAgICB0aGlzLnN1YnMuYWRkKHN1Yik7XG4gICAgfTtcbiAgICByZXR1cm4gKFxuICAgICAgPGhlYWRlciBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3cy10b3BIZWFkZXJcIj5cbiAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiaWNvbiBpY29uLWNvbW1lbnQtZGlzY3Vzc2lvblwiIC8+XG4gICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWhlYWRlclRpdGxlXCI+XG4gICAgICAgICAgUmV2aWV3cyBmb3ImbmJzcDtcbiAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3cy1jbGlja2FibGVcIiBvbkNsaWNrPXt0aGlzLnByb3BzLm9wZW5QUn0+XG4gICAgICAgICAgICB7dGhpcy5wcm9wcy5vd25lcn0ve3RoaXMucHJvcHMucmVwb30je3RoaXMucHJvcHMubnVtYmVyfVxuICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgPC9zcGFuPlxuICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgY2xhc3NOYW1lPXtjeChcbiAgICAgICAgICAgICdnaXRodWItUmV2aWV3cy1oZWFkZXJCdXR0b24gZ2l0aHViLVJldmlld3MtY2xpY2thYmxlIGljb24gaWNvbi1yZXBvLXN5bmMnLFxuICAgICAgICAgICAge3JlZnJlc2hpbmc6IHRoaXMuc3RhdGUuaXNSZWZyZXNoaW5nfSxcbiAgICAgICAgICApfVxuICAgICAgICAgIG9uQ2xpY2s9e3JlZnJlc2h9XG4gICAgICAgIC8+XG4gICAgICAgIDxDaGVja291dEJ1dHRvblxuICAgICAgICAgIGNoZWNrb3V0T3A9e3RoaXMucHJvcHMuY2hlY2tvdXRPcH1cbiAgICAgICAgICBjbGFzc05hbWVQcmVmaXg9XCJnaXRodWItUmV2aWV3cy1jaGVja291dEJ1dHRvbi0tXCJcbiAgICAgICAgICBjbGFzc05hbWVzPXtbJ2dpdGh1Yi1SZXZpZXdzLWhlYWRlckJ1dHRvbiddfVxuICAgICAgICAvPlxuICAgICAgPC9oZWFkZXI+XG4gICAgKTtcbiAgfVxuXG4gIGxvZ1N0YXJ0UmV2aWV3Q2xpY2sgPSAoKSA9PiB7XG4gICAgYWRkRXZlbnQoJ3N0YXJ0LXByLXJldmlldycsIHtwYWNrYWdlOiAnZ2l0aHViJywgY29tcG9uZW50OiB0aGlzLmNvbnN0cnVjdG9yLm5hbWV9KTtcbiAgfVxuXG4gIHJlbmRlckVtcHR5U3RhdGUoKSB7XG4gICAgY29uc3Qge251bWJlciwgcmVwbywgb3duZXJ9ID0gdGhpcy5wcm9wcztcbiAgICAvLyB0b2RvOiBtYWtlIHRoaXMgb3BlbiB0aGUgcmV2aWV3IGZsb3cgaW4gQXRvbSBpbnN0ZWFkIG9mIGRvdGNvbVxuICAgIGNvbnN0IHB1bGxSZXF1ZXN0VVJMID0gYGh0dHBzOi8vd3d3LmdpdGh1Yi5jb20vJHtvd25lcn0vJHtyZXBvfS9wdWxsLyR7bnVtYmVyfS9maWxlcy9gO1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWVtcHR5U3RhdGVcIj5cbiAgICAgICAgPGltZyBzcmM9XCJhdG9tOi8vZ2l0aHViL2ltZy9tb25hLnN2Z1wiIGFsdD1cIk1vbmEgdGhlIG9jdG9jYXQgaW4gc3BhYWFjY2VlXCIgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtZW1wdHlJbWdcIiAvPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWVtcHR5VGV4dFwiPlxuICAgICAgICAgIFRoaXMgcHVsbCByZXF1ZXN0IGhhcyBubyByZXZpZXdzXG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8YnV0dG9uIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWVtcHR5Q2FsbFRvQWN0aW9uQnV0dG9uIGJ0blwiPlxuICAgICAgICAgIDxhIGhyZWY9e3B1bGxSZXF1ZXN0VVJMfSBvbkNsaWNrPXt0aGlzLmxvZ1N0YXJ0UmV2aWV3Q2xpY2t9PlxuICAgICAgICAgICAgU3RhcnQgYSBuZXcgcmV2aWV3XG4gICAgICAgICAgPC9hPlxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJSZXZpZXdTdW1tYXJpZXMoKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuc3VtbWFyaWVzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgcmV0dXJuIHRoaXMucmVuZGVyRW1wdHlTdGF0ZSgpO1xuICAgIH1cblxuICAgIGNvbnN0IHRvZ2dsZSA9IGV2dCA9PiB7XG4gICAgICBldnQucHJldmVudERlZmF1bHQoKTtcbiAgICAgIGlmICh0aGlzLnByb3BzLnN1bW1hcnlTZWN0aW9uT3Blbikge1xuICAgICAgICB0aGlzLnByb3BzLmhpZGVTdW1tYXJpZXMoKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMucHJvcHMuc2hvd1N1bW1hcmllcygpO1xuICAgICAgfVxuICAgIH07XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRldGFpbHNcbiAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3Mtc2VjdGlvbiBzdW1tYXJpZXNcIlxuICAgICAgICBvcGVuPXt0aGlzLnByb3BzLnN1bW1hcnlTZWN0aW9uT3Blbn0+XG5cbiAgICAgICAgPHN1bW1hcnkgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtaGVhZGVyXCIgb25DbGljaz17dG9nZ2xlfT5cbiAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3cy10aXRsZVwiPlN1bW1hcmllczwvc3Bhbj5cbiAgICAgICAgPC9zdW1tYXJ5PlxuICAgICAgICA8bWFpbiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3cy1jb250YWluZXJcIj5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5zdW1tYXJpZXMubWFwKHRoaXMucmVuZGVyUmV2aWV3U3VtbWFyeSl9XG4gICAgICAgIDwvbWFpbj5cblxuICAgICAgPC9kZXRhaWxzPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJSZXZpZXdTdW1tYXJ5ID0gcmV2aWV3ID0+IHtcbiAgICBjb25zdCByZXZpZXdUeXBlcyA9IHR5cGUgPT4ge1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgQVBQUk9WRUQ6IHtpY29uOiAnaWNvbi1jaGVjaycsIGNvcHk6ICdhcHByb3ZlZCB0aGVzZSBjaGFuZ2VzJ30sXG4gICAgICAgIENPTU1FTlRFRDoge2ljb246ICdpY29uLWNvbW1lbnQnLCBjb3B5OiAnY29tbWVudGVkJ30sXG4gICAgICAgIENIQU5HRVNfUkVRVUVTVEVEOiB7aWNvbjogJ2ljb24tYWxlcnQnLCBjb3B5OiAncmVxdWVzdGVkIGNoYW5nZXMnfSxcbiAgICAgIH1bdHlwZV0gfHwge2ljb246ICcnLCBjb3B5OiAnJ307XG4gICAgfTtcblxuICAgIGNvbnN0IHtpY29uLCBjb3B5fSA9IHJldmlld1R5cGVzKHJldmlldy5zdGF0ZSk7XG5cbiAgICAvLyBmaWx0ZXIgbm9uIGFjdGlvbmFibGUgZW1wdHkgc3VtbWFyeSBjb21tZW50cyBmcm9tIHRoaXMgdmlld1xuICAgIGlmIChyZXZpZXcuc3RhdGUgPT09ICdQRU5ESU5HJyB8fCAocmV2aWV3LnN0YXRlID09PSAnQ09NTUVOVEVEJyAmJiByZXZpZXcuYm9keUhUTUwgPT09ICcnKSkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgY29uc3QgYXV0aG9yID0gcmV2aWV3LmF1dGhvciB8fCBHSE9TVF9VU0VSO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld1N1bW1hcnlcIiBrZXk9e3Jldmlldy5pZH0+XG4gICAgICAgIDxBY3Rpb25hYmxlUmV2aWV3Vmlld1xuICAgICAgICAgIG9yaWdpbmFsQ29udGVudD17cmV2aWV3fVxuICAgICAgICAgIGNvbmZpcm09e3RoaXMucHJvcHMuY29uZmlybX1cbiAgICAgICAgICBjb21tYW5kcz17dGhpcy5wcm9wcy5jb21tYW5kc31cbiAgICAgICAgICBjb250ZW50VXBkYXRlcj17dGhpcy5wcm9wcy51cGRhdGVTdW1tYXJ5fVxuICAgICAgICAgIHJlbmRlcj17c2hvd0FjdGlvbnNNZW51ID0+IHtcbiAgICAgICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICAgIDxGcmFnbWVudD5cbiAgICAgICAgICAgICAgICA8aGVhZGVyIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctaGVhZGVyXCI+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctaGVhZGVyLWF1dGhvckRhdGFcIj5cbiAgICAgICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPXtgZ2l0aHViLVJldmlld1N1bW1hcnktaWNvbiBpY29uICR7aWNvbn1gfSAvPlxuICAgICAgICAgICAgICAgICAgICA8aW1nIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdTdW1tYXJ5LWF2YXRhclwiXG4gICAgICAgICAgICAgICAgICAgICAgc3JjPXthdXRob3IuYXZhdGFyVXJsfSBhbHQ9e2F1dGhvci5sb2dpbn1cbiAgICAgICAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgICAgICAgPGEgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld1N1bW1hcnktdXNlcm5hbWVcIiBocmVmPXthdXRob3IudXJsfT57YXV0aG9yLmxvZ2lufTwvYT5cbiAgICAgICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld1N1bW1hcnktdHlwZVwiPntjb3B5fTwvc3Bhbj5cbiAgICAgICAgICAgICAgICAgICAge3RoaXMucmVuZGVyRWRpdGVkTGluayhyZXZpZXcpfVxuICAgICAgICAgICAgICAgICAgICB7dGhpcy5yZW5kZXJBdXRob3JBc3NvY2lhdGlvbihyZXZpZXcpfVxuICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICA8VGltZWFnbyBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3U3VtbWFyeS10aW1lQWdvXCIgdGltZT17cmV2aWV3LnN1Ym1pdHRlZEF0fSBkaXNwbGF5U3R5bGU9XCJzaG9ydFwiIC8+XG4gICAgICAgICAgICAgICAgICA8T2N0aWNvblxuICAgICAgICAgICAgICAgICAgICBpY29uPVwiZWxsaXBzZXNcIlxuICAgICAgICAgICAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LWFjdGlvbnNNZW51XCJcbiAgICAgICAgICAgICAgICAgICAgb25DbGljaz17ZXZlbnQgPT4gc2hvd0FjdGlvbnNNZW51KGV2ZW50LCByZXZpZXcsIGF1dGhvcil9XG4gICAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICAgIDwvaGVhZGVyPlxuICAgICAgICAgICAgICAgIDxtYWluIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdTdW1tYXJ5LWNvbW1lbnRcIj5cbiAgICAgICAgICAgICAgICAgIDxHaXRodWJEb3Rjb21NYXJrZG93blxuICAgICAgICAgICAgICAgICAgICBodG1sPXtyZXZpZXcuYm9keUhUTUx9XG4gICAgICAgICAgICAgICAgICAgIHN3aXRjaFRvSXNzdWVpc2g9e3RoaXMucHJvcHMub3Blbklzc3VlaXNofVxuICAgICAgICAgICAgICAgICAgICBvcGVuSXNzdWVpc2hMaW5rSW5OZXdUYWI9e3RoaXMub3Blbklzc3VlaXNoTGlua0luTmV3VGFifVxuICAgICAgICAgICAgICAgICAgLz5cbiAgICAgICAgICAgICAgICAgIDxFbW9qaVJlYWN0aW9uc0NvbnRyb2xsZXJcbiAgICAgICAgICAgICAgICAgICAgcmVhY3RhYmxlPXtyZXZpZXd9XG4gICAgICAgICAgICAgICAgICAgIHRvb2x0aXBzPXt0aGlzLnByb3BzLnRvb2x0aXBzfVxuICAgICAgICAgICAgICAgICAgICByZXBvcnRSZWxheUVycm9yPXt0aGlzLnByb3BzLnJlcG9ydFJlbGF5RXJyb3J9XG4gICAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICAgIDwvbWFpbj5cbiAgICAgICAgICAgICAgPC9GcmFnbWVudD5cbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfX1cbiAgICAgICAgLz5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJSZXZpZXdDb21tZW50VGhyZWFkcygpIHtcbiAgICBjb25zdCBjb21tZW50VGhyZWFkcyA9IHRoaXMucHJvcHMuY29tbWVudFRocmVhZHM7XG4gICAgaWYgKGNvbW1lbnRUaHJlYWRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgY29uc3QgcmVzb2x2ZWRUaHJlYWRzID0gY29tbWVudFRocmVhZHMuZmlsdGVyKHBhaXIgPT4gcGFpci50aHJlYWQuaXNSZXNvbHZlZCk7XG4gICAgY29uc3QgdW5yZXNvbHZlZFRocmVhZHMgPSBjb21tZW50VGhyZWFkcy5maWx0ZXIocGFpciA9PiAhcGFpci50aHJlYWQuaXNSZXNvbHZlZCk7XG5cbiAgICBjb25zdCB0b2dnbGVDb21tZW50cyA9IGV2dCA9PiB7XG4gICAgICBldnQucHJldmVudERlZmF1bHQoKTtcbiAgICAgIGlmICh0aGlzLnByb3BzLmNvbW1lbnRTZWN0aW9uT3Blbikge1xuICAgICAgICB0aGlzLnByb3BzLmhpZGVDb21tZW50cygpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5wcm9wcy5zaG93Q29tbWVudHMoKTtcbiAgICAgIH1cbiAgICB9O1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkZXRhaWxzXG4gICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLXNlY3Rpb24gY29tbWVudHNcIlxuICAgICAgICBvcGVuPXt0aGlzLnByb3BzLmNvbW1lbnRTZWN0aW9uT3Blbn0+XG5cbiAgICAgICAgPHN1bW1hcnkgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtaGVhZGVyXCIgb25DbGljaz17dG9nZ2xlQ29tbWVudHN9PlxuICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLXRpdGxlXCI+Q29tbWVudHM8L3NwYW4+XG4gICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtcHJvZ3Jlc3NcIj5cbiAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWNvdW50XCI+XG4gICAgICAgICAgICAgIFJlc29sdmVkXG4gICAgICAgICAgICAgIHsnICd9PHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtY291bnROclwiPntyZXNvbHZlZFRocmVhZHMubGVuZ3RofTwvc3Bhbj57JyAnfVxuICAgICAgICAgICAgICBvZlxuICAgICAgICAgICAgICB7JyAnfTxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWNvdW50TnJcIj57cmVzb2x2ZWRUaHJlYWRzLmxlbmd0aCArIHVucmVzb2x2ZWRUaHJlYWRzLmxlbmd0aH08L3NwYW4+XG4gICAgICAgICAgICA8L3NwYW4+XG4gICAgICAgICAgICA8cHJvZ3Jlc3NcbiAgICAgICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtcHJvZ2Vzc0JhclwiIHZhbHVlPXtyZXNvbHZlZFRocmVhZHMubGVuZ3RofVxuICAgICAgICAgICAgICBtYXg9e3Jlc29sdmVkVGhyZWFkcy5sZW5ndGggKyB1bnJlc29sdmVkVGhyZWFkcy5sZW5ndGh9XG4gICAgICAgICAgICAvPlxuICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgPC9zdW1tYXJ5PlxuXG4gICAgICAgIHt1bnJlc29sdmVkVGhyZWFkcy5sZW5ndGggPiAwICYmIDxtYWluIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWNvbnRhaW5lclwiPlxuICAgICAgICAgIHt1bnJlc29sdmVkVGhyZWFkcy5tYXAodGhpcy5yZW5kZXJSZXZpZXdDb21tZW50VGhyZWFkKX1cbiAgICAgICAgPC9tYWluPn1cbiAgICAgICAge3Jlc29sdmVkVGhyZWFkcy5sZW5ndGggPiAwICYmIDxkZXRhaWxzIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLXNlY3Rpb24gcmVzb2x2ZWQtY29tbWVudHNcIiBvcGVuPlxuICAgICAgICAgIDxzdW1tYXJ5IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXdzLWhlYWRlclwiPlxuICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtdGl0bGVcIj5SZXNvbHZlZDwvc3Bhbj5cbiAgICAgICAgICA8L3N1bW1hcnk+XG4gICAgICAgICAgPG1haW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlld3MtY29udGFpbmVyXCI+XG4gICAgICAgICAgICB7cmVzb2x2ZWRUaHJlYWRzLm1hcCh0aGlzLnJlbmRlclJldmlld0NvbW1lbnRUaHJlYWQpfVxuICAgICAgICAgIDwvbWFpbj5cbiAgICAgICAgPC9kZXRhaWxzPn1cblxuICAgICAgPC9kZXRhaWxzPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJSZXZpZXdDb21tZW50VGhyZWFkID0gY29tbWVudFRocmVhZCA9PiB7XG4gICAgY29uc3Qge2NvbW1lbnRzLCB0aHJlYWR9ID0gY29tbWVudFRocmVhZDtcbiAgICBjb25zdCByb290Q29tbWVudCA9IGNvbW1lbnRzWzBdO1xuICAgIGlmICghcm9vdENvbW1lbnQpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGxldCB0aHJlYWRIb2xkZXIgPSB0aGlzLnRocmVhZEhvbGRlcnMuZ2V0KHRocmVhZC5pZCk7XG4gICAgaWYgKCF0aHJlYWRIb2xkZXIpIHtcbiAgICAgIHRocmVhZEhvbGRlciA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICAgIHRoaXMudGhyZWFkSG9sZGVycy5zZXQodGhyZWFkLmlkLCB0aHJlYWRIb2xkZXIpO1xuICAgIH1cblxuICAgIGNvbnN0IG5hdGl2ZVBhdGggPSB0b05hdGl2ZVBhdGhTZXAocm9vdENvbW1lbnQucGF0aCk7XG4gICAgY29uc3Qge2RpciwgYmFzZX0gPSBwYXRoLnBhcnNlKG5hdGl2ZVBhdGgpO1xuICAgIGNvbnN0IHtsaW5lTnVtYmVyLCBwb3NpdGlvblRleHR9ID0gdGhpcy5nZXRUcmFuc2xhdGVkUG9zaXRpb24ocm9vdENvbW1lbnQpO1xuXG4gICAgY29uc3QgcmVmSnVtcFRvRmlsZUJ1dHRvbiA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICBjb25zdCBqdW1wVG9GaWxlRGlzYWJsZWRMYWJlbCA9ICdDaGVja291dCB0aGlzIHB1bGwgcmVxdWVzdCB0byBlbmFibGUgSnVtcCBUbyBGaWxlLic7XG5cbiAgICBjb25zdCBlbGVtZW50SWQgPSBgcmV2aWV3LXRocmVhZC0ke3RocmVhZC5pZH1gO1xuXG4gICAgY29uc3QgbmF2QnV0dG9uQ2xhc3NlcyA9IFsnZ2l0aHViLVJldmlldy1uYXZCdXR0b24nLCAnaWNvbicsIHtvdXRkYXRlZDogIWxpbmVOdW1iZXJ9XTtcbiAgICBjb25zdCBvcGVuRmlsZUNsYXNzZXMgPSBjeCgnaWNvbi1jb2RlJywgLi4ubmF2QnV0dG9uQ2xhc3Nlcyk7XG4gICAgY29uc3Qgb3BlbkRpZmZDbGFzc2VzID0gY3goJ2ljb24tZGlmZicsIC4uLm5hdkJ1dHRvbkNsYXNzZXMpO1xuXG4gICAgY29uc3QgaXNPcGVuID0gdGhpcy5wcm9wcy50aHJlYWRJRHNPcGVuLmhhcyh0aHJlYWQuaWQpO1xuICAgIGNvbnN0IGlzSGlnaGxpZ2h0ZWQgPSB0aGlzLnByb3BzLmhpZ2hsaWdodGVkVGhyZWFkSURzLmhhcyh0aHJlYWQuaWQpO1xuICAgIGNvbnN0IHRvZ2dsZSA9IGV2dCA9PiB7XG4gICAgICBldnQucHJldmVudERlZmF1bHQoKTtcbiAgICAgIGV2dC5zdG9wUHJvcGFnYXRpb24oKTtcblxuICAgICAgaWYgKGlzT3Blbikge1xuICAgICAgICB0aGlzLnByb3BzLmhpZGVUaHJlYWRJRCh0aHJlYWQuaWQpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5wcm9wcy5zaG93VGhyZWFkSUQodGhyZWFkLmlkKTtcbiAgICAgIH1cbiAgICB9O1xuXG4gICAgY29uc3QgYXV0aG9yID0gcm9vdENvbW1lbnQuYXV0aG9yIHx8IEdIT1NUX1VTRVI7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRldGFpbHNcbiAgICAgICAgcmVmPXt0aHJlYWRIb2xkZXIuc2V0dGVyfVxuICAgICAgICBjbGFzc05hbWU9e2N4KCdnaXRodWItUmV2aWV3JywgeydyZXNvbHZlZCc6IHRocmVhZC5pc1Jlc29sdmVkLCAnZ2l0aHViLVJldmlldy0taGlnaGxpZ2h0JzogaXNIaWdobGlnaHRlZH0pfVxuICAgICAgICBrZXk9e2VsZW1lbnRJZH1cbiAgICAgICAgaWQ9e2VsZW1lbnRJZH1cbiAgICAgICAgb3Blbj17aXNPcGVufT5cblxuICAgICAgICA8c3VtbWFyeSBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LXJlZmVyZW5jZVwiIG9uQ2xpY2s9e3RvZ2dsZX0+XG4gICAgICAgICAge2RpciAmJiA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LXBhdGhcIj57ZGlyfTwvc3Bhbj59XG4gICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1maWxlXCI+e2RpciA/IHBhdGguc2VwIDogJyd9e2Jhc2V9PC9zcGFuPlxuICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctbGluZU5yXCI+e3Bvc2l0aW9uVGV4dH08L3NwYW4+XG4gICAgICAgICAgPGltZyBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LXJlZmVyZW5jZUF2YXRhclwiXG4gICAgICAgICAgICBzcmM9e2F1dGhvci5hdmF0YXJVcmx9IGFsdD17YXV0aG9yLmxvZ2lufVxuICAgICAgICAgIC8+XG4gICAgICAgICAgPFRpbWVhZ28gY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1yZWZlcmVuY2VUaW1lQWdvXCIgdGltZT17cm9vdENvbW1lbnQuY3JlYXRlZEF0fSBkaXNwbGF5U3R5bGU9XCJzaG9ydFwiIC8+XG4gICAgICAgIDwvc3VtbWFyeT5cbiAgICAgICAgPG5hdiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LW5hdlwiPlxuICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPXtvcGVuRmlsZUNsYXNzZXN9XG4gICAgICAgICAgICBkYXRhLXBhdGg9e25hdGl2ZVBhdGh9IGRhdGEtbGluZT17bGluZU51bWJlcn1cbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMub3BlbkZpbGV9IGRpc2FibGVkPXt0aGlzLnByb3BzLmNoZWNrb3V0T3AuaXNFbmFibGVkKCl9XG4gICAgICAgICAgICByZWY9e3JlZkp1bXBUb0ZpbGVCdXR0b24uc2V0dGVyfT5cbiAgICAgICAgICAgIEp1bXAgVG8gRmlsZVxuICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgIDxidXR0b24gY2xhc3NOYW1lPXtvcGVuRGlmZkNsYXNzZXN9XG4gICAgICAgICAgICBkYXRhLXBhdGg9e25hdGl2ZVBhdGh9IGRhdGEtbGluZT17cm9vdENvbW1lbnQucG9zaXRpb259XG4gICAgICAgICAgICBvbkNsaWNrPXt0aGlzLm9wZW5EaWZmfT5cbiAgICAgICAgICAgIE9wZW4gRGlmZlxuICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICAgIHt0aGlzLnByb3BzLmNoZWNrb3V0T3AuaXNFbmFibGVkKCkgJiZcbiAgICAgICAgICAgIDxUb29sdGlwXG4gICAgICAgICAgICAgIG1hbmFnZXI9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgICAgICAgIHRhcmdldD17cmVmSnVtcFRvRmlsZUJ1dHRvbn1cbiAgICAgICAgICAgICAgdGl0bGU9e2p1bXBUb0ZpbGVEaXNhYmxlZExhYmVsfVxuICAgICAgICAgICAgICBzaG93RGVsYXk9ezIwMH1cbiAgICAgICAgICAgIC8+XG4gICAgICAgICAgfVxuICAgICAgICA8L25hdj5cblxuICAgICAgICB7cm9vdENvbW1lbnQucG9zaXRpb24gIT09IG51bGwgJiYgKFxuICAgICAgICAgIDxQYXRjaFByZXZpZXdWaWV3XG4gICAgICAgICAgICBtdWx0aUZpbGVQYXRjaD17dGhpcy5wcm9wcy5tdWx0aUZpbGVQYXRjaH1cbiAgICAgICAgICAgIGZpbGVOYW1lPXtuYXRpdmVQYXRofVxuICAgICAgICAgICAgZGlmZlJvdz17cm9vdENvbW1lbnQucG9zaXRpb259XG4gICAgICAgICAgICBtYXhSb3dDb3VudD17dGhpcy5wcm9wcy5jb250ZXh0TGluZXN9XG4gICAgICAgICAgICBjb25maWc9e3RoaXMucHJvcHMuY29uZmlnfVxuICAgICAgICAgIC8+XG4gICAgICAgICl9XG5cbiAgICAgICAge3RoaXMucmVuZGVyVGhyZWFkKHt0aHJlYWQsIGNvbW1lbnRzfSl9XG5cbiAgICAgIDwvZGV0YWlscz5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyVGhyZWFkID0gKHt0aHJlYWQsIGNvbW1lbnRzfSkgPT4ge1xuICAgIGxldCByZXBseUhvbGRlciA9IHRoaXMucmVwbHlIb2xkZXJzLmdldCh0aHJlYWQuaWQpO1xuICAgIGlmICghcmVwbHlIb2xkZXIpIHtcbiAgICAgIHJlcGx5SG9sZGVyID0gbmV3IFJlZkhvbGRlcigpO1xuICAgICAgdGhpcy5yZXBseUhvbGRlcnMuc2V0KHRocmVhZC5pZCwgcmVwbHlIb2xkZXIpO1xuICAgIH1cblxuICAgIGNvbnN0IGxhc3RDb21tZW50ID0gY29tbWVudHNbY29tbWVudHMubGVuZ3RoIC0gMV07XG4gICAgY29uc3QgaXNQb3N0aW5nID0gdGhpcy5wcm9wcy5wb3N0aW5nVG9UaHJlYWRJRCAhPT0gbnVsbDtcblxuICAgIHJldHVybiAoXG4gICAgICA8RnJhZ21lbnQ+XG4gICAgICAgIDxtYWluIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctY29tbWVudHNcIj5cblxuICAgICAgICAgIHtjb21tZW50cy5tYXAoY29tbWVudCA9PiB7XG4gICAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgICA8UmV2aWV3Q29tbWVudFZpZXdcbiAgICAgICAgICAgICAgICBrZXk9e2NvbW1lbnQuaWR9XG4gICAgICAgICAgICAgICAgY29tbWVudD17Y29tbWVudH1cbiAgICAgICAgICAgICAgICBvcGVuSXNzdWVpc2g9e3RoaXMucHJvcHMub3Blbklzc3VlaXNofVxuICAgICAgICAgICAgICAgIG9wZW5Jc3N1ZWlzaExpbmtJbk5ld1RhYj17dGhpcy5vcGVuSXNzdWVpc2hMaW5rSW5OZXdUYWJ9XG4gICAgICAgICAgICAgICAgdG9vbHRpcHM9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgICAgICAgICAgcmVwb3J0UmVsYXlFcnJvcj17dGhpcy5wcm9wcy5yZXBvcnRSZWxheUVycm9yfVxuICAgICAgICAgICAgICAgIHJlbmRlckVkaXRlZExpbms9e3RoaXMucmVuZGVyRWRpdGVkTGlua31cbiAgICAgICAgICAgICAgICByZW5kZXJBdXRob3JBc3NvY2lhdGlvbj17dGhpcy5yZW5kZXJBdXRob3JBc3NvY2lhdGlvbn1cbiAgICAgICAgICAgICAgICBpc1Bvc3Rpbmc9e2lzUG9zdGluZ31cbiAgICAgICAgICAgICAgICBjb25maXJtPXt0aGlzLnByb3BzLmNvbmZpcm19XG4gICAgICAgICAgICAgICAgY29tbWFuZHM9e3RoaXMucHJvcHMuY29tbWFuZHN9XG4gICAgICAgICAgICAgICAgdXBkYXRlQ29tbWVudD17dGhpcy5wcm9wcy51cGRhdGVDb21tZW50fVxuICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgKTtcbiAgICAgICAgICB9KX1cblxuICAgICAgICAgIDxkaXZcbiAgICAgICAgICAgIGNsYXNzTmFtZT17Y3goJ2dpdGh1Yi1SZXZpZXctcmVwbHknLCB7J2dpdGh1Yi1SZXZpZXctcmVwbHktLWRpc2FibGVkJzogaXNQb3N0aW5nfSl9XG4gICAgICAgICAgICBkYXRhLXRocmVhZC1pZD17dGhyZWFkLmlkfT5cblxuICAgICAgICAgICAgPEF0b21UZXh0RWRpdG9yXG4gICAgICAgICAgICAgIHBsYWNlaG9sZGVyVGV4dD1cIlJlcGx5Li4uXCJcbiAgICAgICAgICAgICAgbGluZU51bWJlckd1dHRlclZpc2libGU9e2ZhbHNlfVxuICAgICAgICAgICAgICBzb2Z0V3JhcHBlZD17dHJ1ZX1cbiAgICAgICAgICAgICAgYXV0b0hlaWdodD17dHJ1ZX1cbiAgICAgICAgICAgICAgcmVhZE9ubHk9e2lzUG9zdGluZ31cbiAgICAgICAgICAgICAgcmVmTW9kZWw9e3JlcGx5SG9sZGVyfVxuICAgICAgICAgICAgLz5cblxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L21haW4+XG4gICAgICAgIHt0aHJlYWQuaXNSZXNvbHZlZCAmJiA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctcmVzb2x2ZWRUZXh0XCI+XG4gICAgICAgICAgVGhpcyBjb252ZXJzYXRpb24gd2FzIG1hcmtlZCBhcyByZXNvbHZlZCBieSBAe3RocmVhZC5yZXNvbHZlZEJ5LmxvZ2lufVxuICAgICAgICA8L2Rpdj59XG4gICAgICAgIDxmb290ZXIgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1mb290ZXJcIj5cbiAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LXJlcGx5QnV0dG9uIGJ0biBidG4tcHJpbWFyeVwiXG4gICAgICAgICAgICB0aXRsZT1cIkFkZCB5b3VyIGNvbW1lbnRcIlxuICAgICAgICAgICAgZGlzYWJsZWQ9e2lzUG9zdGluZ31cbiAgICAgICAgICAgIG9uQ2xpY2s9eygpID0+IHRoaXMuc3VibWl0UmVwbHkocmVwbHlIb2xkZXIsIHRocmVhZCwgbGFzdENvbW1lbnQpfT5cbiAgICAgICAgICAgIENvbW1lbnRcbiAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJSZXNvbHZlQnV0dG9uKHRocmVhZCl9XG4gICAgICAgIDwvZm9vdGVyPlxuICAgICAgPC9GcmFnbWVudD5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyUmVzb2x2ZUJ1dHRvbiA9IHRocmVhZCA9PiB7XG4gICAgaWYgKHRocmVhZC5pc1Jlc29sdmVkKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1yZXNvbHZlQnV0dG9uIGJ0biBpY29uIGljb24tY2hlY2tcIlxuICAgICAgICAgIHRpdGxlPVwiVW5yZXNvbHZlIGNvbnZlcnNhdGlvblwiXG4gICAgICAgICAgb25DbGljaz17KCkgPT4gdGhpcy5yZXNvbHZlVW5yZXNvbHZlVGhyZWFkKHRocmVhZCl9PlxuICAgICAgICAgIFVucmVzb2x2ZSBjb252ZXJzYXRpb25cbiAgICAgICAgPC9idXR0b24+XG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVJldmlldy1yZXNvbHZlQnV0dG9uIGJ0biBpY29uIGljb24tY2hlY2tcIlxuICAgICAgICAgIHRpdGxlPVwiUmVzb2x2ZSBjb252ZXJzYXRpb25cIlxuICAgICAgICAgIG9uQ2xpY2s9eygpID0+IHRoaXMucmVzb2x2ZVVucmVzb2x2ZVRocmVhZCh0aHJlYWQpfT5cbiAgICAgICAgICBSZXNvbHZlIGNvbnZlcnNhdGlvblxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgICk7XG4gICAgfVxuICB9XG5cbiAgcmVuZGVyRWRpdGVkTGluayhlbnRpdHkpIHtcbiAgICBpZiAoIWVudGl0eS5sYXN0RWRpdGVkQXQpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LWVkaXRlZFwiPlxuICAgICAgICAmbmJzcDvigKImbmJzcDtcbiAgICAgICAgICA8YSBjbGFzc05hbWU9XCJnaXRodWItUmV2aWV3LWVkaXRlZFwiIGhyZWY9e2VudGl0eS51cmx9PmVkaXRlZDwvYT5cbiAgICAgICAgPC9zcGFuPlxuICAgICAgKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXJBdXRob3JBc3NvY2lhdGlvbihlbnRpdHkpIHtcbiAgICBjb25zdCB0ZXh0ID0gYXV0aG9yQXNzb2NpYXRpb25UZXh0W2VudGl0eS5hdXRob3JBc3NvY2lhdGlvbl07XG4gICAgaWYgKCF0ZXh0KSB7IHJldHVybiBudWxsOyB9XG4gICAgcmV0dXJuIChcbiAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1SZXZpZXctYXV0aG9yQXNzb2NpYXRpb25CYWRnZSBiYWRnZVwiPnt0ZXh0fTwvc3Bhbj5cbiAgICApO1xuICB9XG5cbiAgb3BlbkZpbGUgPSBldnQgPT4ge1xuICAgIGlmICghdGhpcy5wcm9wcy5jaGVja291dE9wLmlzRW5hYmxlZCgpKSB7XG4gICAgICBjb25zdCB0YXJnZXQgPSBldnQuY3VycmVudFRhcmdldDtcbiAgICAgIHRoaXMucHJvcHMub3BlbkZpbGUodGFyZ2V0LmRhdGFzZXQucGF0aCwgdGFyZ2V0LmRhdGFzZXQubGluZSk7XG4gICAgfVxuICB9XG5cbiAgb3BlbkRpZmYgPSBldnQgPT4ge1xuICAgIGNvbnN0IHRhcmdldCA9IGV2dC5jdXJyZW50VGFyZ2V0O1xuICAgIHRoaXMucHJvcHMub3BlbkRpZmYodGFyZ2V0LmRhdGFzZXQucGF0aCwgcGFyc2VJbnQodGFyZ2V0LmRhdGFzZXQubGluZSwgMTApKTtcbiAgfVxuXG4gIG9wZW5Jc3N1ZWlzaExpbmtJbk5ld1RhYiA9IGV2dCA9PiB7XG4gICAgY29uc3Qge3JlcG9Pd25lciwgcmVwb05hbWUsIGlzc3VlaXNoTnVtYmVyfSA9IGdldERhdGFGcm9tR2l0aHViVXJsKGV2dC50YXJnZXQuZGF0YXNldC51cmwpO1xuICAgIHJldHVybiB0aGlzLnByb3BzLm9wZW5Jc3N1ZWlzaChyZXBvT3duZXIsIHJlcG9OYW1lLCBpc3N1ZWlzaE51bWJlcik7XG4gIH1cblxuICBzdWJtaXRSZXBseShyZXBseUhvbGRlciwgdGhyZWFkLCBsYXN0Q29tbWVudCkge1xuICAgIGNvbnN0IGJvZHkgPSByZXBseUhvbGRlci5tYXAoZWRpdG9yID0+IGVkaXRvci5nZXRUZXh0KCkpLmdldE9yKCcnKTtcbiAgICBjb25zdCBkaWRTdWJtaXRDb21tZW50ID0gKCkgPT4gcmVwbHlIb2xkZXIubWFwKGVkaXRvciA9PiBlZGl0b3Iuc2V0VGV4dCgnJywge2J5cGFzc1JlYWRPbmx5OiB0cnVlfSkpO1xuICAgIGNvbnN0IGRpZEZhaWxDb21tZW50ID0gKCkgPT4gcmVwbHlIb2xkZXIubWFwKGVkaXRvciA9PiBlZGl0b3Iuc2V0VGV4dChib2R5LCB7YnlwYXNzUmVhZE9ubHk6IHRydWV9KSk7XG5cbiAgICByZXR1cm4gdGhpcy5wcm9wcy5hZGRTaW5nbGVDb21tZW50KFxuICAgICAgYm9keSwgdGhyZWFkLmlkLCBsYXN0Q29tbWVudC5pZCwgbGFzdENvbW1lbnQucGF0aCwgbGFzdENvbW1lbnQucG9zaXRpb24sIHtkaWRTdWJtaXRDb21tZW50LCBkaWRGYWlsQ29tbWVudH0sXG4gICAgKTtcbiAgfVxuXG4gIHN1Ym1pdEN1cnJlbnRDb21tZW50ID0gZXZ0ID0+IHtcbiAgICBjb25zdCB0aHJlYWRJRCA9IGV2dC5jdXJyZW50VGFyZ2V0LmRhdGFzZXQudGhyZWFkSWQ7XG4gICAgLyogaXN0YW5idWwgaWdub3JlIGlmICovXG4gICAgaWYgKCF0aHJlYWRJRCkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgY29uc3Qge3RocmVhZCwgY29tbWVudHN9ID0gdGhpcy5wcm9wcy5jb21tZW50VGhyZWFkcy5maW5kKGVhY2ggPT4gZWFjaC50aHJlYWQuaWQgPT09IHRocmVhZElEKTtcbiAgICBjb25zdCByZXBseUhvbGRlciA9IHRoaXMucmVwbHlIb2xkZXJzLmdldCh0aHJlYWRJRCk7XG5cbiAgICByZXR1cm4gdGhpcy5zdWJtaXRSZXBseShyZXBseUhvbGRlciwgdGhyZWFkLCBjb21tZW50c1tjb21tZW50cy5sZW5ndGggLSAxXSk7XG4gIH1cblxuICBnZXRUcmFuc2xhdGVkUG9zaXRpb24ocm9vdENvbW1lbnQpIHtcbiAgICBsZXQgbGluZU51bWJlciwgcG9zaXRpb25UZXh0O1xuICAgIGNvbnN0IHRyYW5zbGF0aW9ucyA9IHRoaXMucHJvcHMuY29tbWVudFRyYW5zbGF0aW9ucztcblxuICAgIGNvbnN0IGlzQ2hlY2tlZE91dFB1bGxSZXF1ZXN0ID0gdGhpcy5wcm9wcy5jaGVja291dE9wLndoeSgpID09PSBjaGVja291dFN0YXRlcy5DVVJSRU5UO1xuICAgIGlmICh0cmFuc2xhdGlvbnMgPT09IG51bGwpIHtcbiAgICAgIGxpbmVOdW1iZXIgPSBudWxsO1xuICAgICAgcG9zaXRpb25UZXh0ID0gJyc7XG4gICAgfSBlbHNlIGlmIChyb290Q29tbWVudC5wb3NpdGlvbiA9PT0gbnVsbCkge1xuICAgICAgbGluZU51bWJlciA9IG51bGw7XG4gICAgICBwb3NpdGlvblRleHQgPSAnb3V0ZGF0ZWQnO1xuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCB0cmFuc2xhdGlvbnNGb3JGaWxlID0gdHJhbnNsYXRpb25zLmdldChyb290Q29tbWVudC5wYXRoKTtcbiAgICAgIGxpbmVOdW1iZXIgPSB0cmFuc2xhdGlvbnNGb3JGaWxlLmRpZmZUb0ZpbGVQb3NpdGlvbi5nZXQocGFyc2VJbnQocm9vdENvbW1lbnQucG9zaXRpb24sIDEwKSk7XG4gICAgICBpZiAodHJhbnNsYXRpb25zRm9yRmlsZS5maWxlVHJhbnNsYXRpb25zICYmIGlzQ2hlY2tlZE91dFB1bGxSZXF1ZXN0KSB7XG4gICAgICAgIGxpbmVOdW1iZXIgPSB0cmFuc2xhdGlvbnNGb3JGaWxlLmZpbGVUcmFuc2xhdGlvbnMuZ2V0KGxpbmVOdW1iZXIpLm5ld1Bvc2l0aW9uO1xuICAgICAgfVxuICAgICAgcG9zaXRpb25UZXh0ID0gbGluZU51bWJlcjtcbiAgICB9XG5cbiAgICByZXR1cm4ge2xpbmVOdW1iZXIsIHBvc2l0aW9uVGV4dH07XG4gIH1cblxuICAvKiBpc3RhbmJ1bCBpZ25vcmUgbmV4dCAqL1xuICBzY3JvbGxUb1RocmVhZCh0aHJlYWRJRCkge1xuICAgIGNvbnN0IHRocmVhZEhvbGRlciA9IHRoaXMudGhyZWFkSG9sZGVycy5nZXQodGhyZWFkSUQpO1xuICAgIGlmICh0aHJlYWRIb2xkZXIpIHtcbiAgICAgIHRocmVhZEhvbGRlci5tYXAoZWxlbWVudCA9PiB7XG4gICAgICAgIGVsZW1lbnQuc2Nyb2xsSW50b1ZpZXdJZk5lZWRlZCgpO1xuICAgICAgICByZXR1cm4gbnVsbDsgLy8gc2hoLCBlc2xpbnRcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIGFzeW5jIHJlc29sdmVVbnJlc29sdmVUaHJlYWQodGhyZWFkKSB7XG4gICAgaWYgKHRocmVhZC5pc1Jlc29sdmVkKSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLnVucmVzb2x2ZVRocmVhZCh0aHJlYWQpO1xuICAgIH0gZWxzZSB7XG4gICAgICBhd2FpdCB0aGlzLnByb3BzLnJlc29sdmVUaHJlYWQodGhyZWFkKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==