Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @babel */

var _atom = require('atom');

var Bookmarks = (function () {
  _createClass(Bookmarks, null, [{
    key: "deserialize",
    value: function deserialize(editor, state) {
      return new Bookmarks(editor, editor.getMarkerLayer(state.markerLayerId));
    }
  }]);

  function Bookmarks(editor, markerLayer) {
    _classCallCheck(this, Bookmarks);

    this.editor = editor;
    this.markerLayer = markerLayer || this.editor.addMarkerLayer({ persistent: true });
    this.decorationLayer = this.editor.decorateMarkerLayer(this.markerLayer, { type: "line-number", "class": "bookmarked" });
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(atom.views.getView(this.editor), {
      "bookmarks:toggle-bookmark": this.toggleBookmark.bind(this),
      "bookmarks:jump-to-next-bookmark": this.jumpToNextBookmark.bind(this),
      "bookmarks:jump-to-previous-bookmark": this.jumpToPreviousBookmark.bind(this),
      "bookmarks:select-to-next-bookmark": this.selectToNextBookmark.bind(this),
      "bookmarks:select-to-previous-bookmark": this.selectToPreviousBookmark.bind(this),
      "bookmarks:clear-bookmarks": this.clearBookmarks.bind(this)
    }));
    this.disposables.add(this.editor.onDidDestroy(this.destroy.bind(this)));
  }

  _createClass(Bookmarks, [{
    key: "destroy",
    value: function destroy() {
      this.deactivate();
      this.markerLayer.destroy();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      this.decorationLayer.destroy();
      this.disposables.dispose();
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return { markerLayerId: this.markerLayer.id };
    }
  }, {
    key: "toggleBookmark",
    value: function toggleBookmark() {
      var _this = this;

      for (var range of this.editor.getSelectedBufferRanges()) {
        var bookmarks = this.markerLayer.findMarkers({ intersectsRowRange: [range.start.row, range.end.row] });
        if (bookmarks && bookmarks.length > 0) {
          for (var bookmark of bookmarks) {
            bookmark.destroy();
          }
        } else {
          (function () {
            var bookmark = _this.markerLayer.markBufferRange(range, { invalidate: "surround", exclusive: true });
            _this.disposables.add(bookmark.onDidChange(function (_ref) {
              var isValid = _ref.isValid;

              if (!isValid) {
                bookmark.destroy();
              }
            }));
          })();
        }
      }
    }
  }, {
    key: "clearBookmarks",
    value: function clearBookmarks() {
      for (var bookmark of this.markerLayer.getMarkers()) {
        bookmark.destroy();
      }
    }
  }, {
    key: "jumpToNextBookmark",
    value: function jumpToNextBookmark() {
      var _this2 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this2.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this2.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          _this2.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this2.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "jumpToPreviousBookmark",
    value: function jumpToPreviousBookmark() {
      var _this3 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this3.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this3.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          _this3.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this3.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToNextBookmark",
    value: function selectToNextBookmark() {
      var _this4 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this4.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this4.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this4.editor.setSelectedBufferRange([bookmarkMarker.getHeadBufferPosition(), _this4.editor.getCursorBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToPreviousBookmark",
    value: function selectToPreviousBookmark() {
      var _this5 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this5.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this5.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this5.editor.setSelectedBufferRange([_this5.editor.getCursorBufferPosition(), bookmarkMarker.getHeadBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }]);

  return Bookmarks;
})();

exports["default"] = Bookmarks;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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