(function() {
  var PropertiesURL, fetch, filterExcerpt, fs, mdnCSSURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnCSSURL = 'https://developer.mozilla.org/en-US/docs/Web/CSS';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=css&highlight=false';

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  fetch = function() {
    var propertiesPromise;
    propertiesPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: PropertiesURL
      }, function(error, response, properties) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for CSSProperties.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(properties);
      });
    });
    return propertiesPromise.then(function(properties) {
      var MAX, docs, queue, running;
      if (properties == null) {
        return;
      }
      MAX = 10;
      queue = Object.keys(properties);
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(propertyName) {
          var index;
          index = running.indexOf(propertyName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var propertyName;
          checkEnd();
          if (queue.length !== 0) {
            propertyName = queue.pop();
            running.push(propertyName);
            return run(propertyName);
          }
        };
        run = function(propertyName) {
          var url;
          url = mdnJSONAPI + "&q=" + propertyName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(propertyName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(propertyName);
            checkEnd();
            return runNext();
          });
        };
        handleRequest = function(propertyName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnCSSURL + "/" + propertyName)) {
                docs[propertyName] = filterExcerpt(propertyName, doc.excerpt);
                break;
              }
            }
          }
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(propertyName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the (css )?[a-z-]+ (css )?property (is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[4];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'property-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
