/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.preferences;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.I18n;

public class AdditionalBoardsManagerURLTextArea
extends JDialog {
    private ActionListener onOkListener;
    private final JTextArea additionalBoardsManagerURLs = new JTextArea();
    private JLabel unofficialListURLLabel;

    public AdditionalBoardsManagerURLTextArea(Window parent) {
        super(parent);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        Base.registerWindowCloseKeys(this.getRootPane(), this::cancelActionPerformed);
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        JButton cancel = new JButton();
        JButton ok = new JButton();
        JLabel jLabel1 = new JLabel();
        this.unofficialListURLLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n.tr((String)"Additional Boards Manager URLs"));
        this.setModal(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.additionalBoardsManagerURLs.setColumns(20);
        this.additionalBoardsManagerURLs.setRows(5);
        this.additionalBoardsManagerURLs.setName("");
        jScrollPane1.setViewportView(this.additionalBoardsManagerURLs);
        cancel.setText(I18n.tr((String)"Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.cancelActionPerformed(evt);
            }
        });
        ok.setText(I18n.tr((String)"OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.okActionPerformed(evt);
            }
        });
        jLabel1.setText(I18n.tr((String)"Enter additional URLs, one for each row"));
        this.unofficialListURLLabel.setText(I18n.tr((String)"Click for a list of unofficial boards support URLs"));
        this.unofficialListURLLabel.setCursor(new Cursor(12));
        this.unofficialListURLLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.unofficialListURLLabelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.unofficialListURLLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.unofficialListURLLabelMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 538, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(ok).addGap(7, 7, 7).addComponent(cancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unofficialListURLLabel).addComponent(jLabel1)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unofficialListURLLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ok).addComponent(cancel)).addContainerGap()));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okActionPerformed(ActionEvent evt) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
        this.onOkListener.actionPerformed(actionEvent);
        this.cancelActionPerformed(evt);
    }

    private void unofficialListURLLabelMouseEntered(MouseEvent evt) {
        this.unofficialListURLLabel.setForeground(new Color(0, 0, 140));
    }

    private void unofficialListURLLabelMouseExited(MouseEvent evt) {
        this.unofficialListURLLabel.setForeground(new Color(76, 76, 76));
    }

    private void unofficialListURLLabelMouseClicked(MouseEvent evt) {
        Base.openURL("https://github.com/arduino/Arduino/wiki/Unofficial-list-of-3rd-party-boards-support-urls");
    }

    public void setText(String text) {
        Collection<String> urls = this.splitAndTrim(text, ",");
        this.additionalBoardsManagerURLs.setText(urls.stream().filter(s -> s != null).collect(Collectors.joining("\n")));
    }

    private Collection<String> splitAndTrim(String text, String separator) {
        List<String> urls = Arrays.asList(text.split(separator));
        return urls.stream().map(String::trim).filter(url -> !url.isEmpty()).collect(Collectors.toList());
    }

    public String getText() {
        Collection<String> urls = this.splitAndTrim(this.additionalBoardsManagerURLs.getText(), "\n");
        return urls.stream().filter(s -> s != null).collect(Collectors.joining(","));
    }

    public void onOk(ActionListener listener) {
        this.onOkListener = listener;
    }
}

