/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.LiveCPUView;
import org.netbeans.lib.profiler.ui.cpu.LiveCPUViewUpdater;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;
import org.openide.util.Lookup;

abstract class MethodsFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private LiveCPUView cpuView;
    private LiveCPUViewUpdater updater;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;
    private JToggleButton[] toggles;

    MethodsFeatureUI() {
    }

    abstract Set<ClientUtils.SourceCodeSelection> getClassesSelection();

    abstract Set<ClientUtils.SourceCodeSelection> getMethodsSelection();

    abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    abstract Lookup.Provider getProject();

    abstract ProfilerClient getProfilerClient();

    abstract void refreshResults();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.cpuView == null) {
            this.initUI();
        }
        return this.cpuView;
    }

    boolean hasResultsUI() {
        return this.cpuView != null;
    }

    @Override
    void sessionStateChanged(int n) {
        this.refreshToolbar(n);
    }

    void resetPause() {
        if (this.lrPauseButton != null) {
            this.lrPauseButton.setSelected(false);
        }
    }

    void setForceRefresh() {
        if (this.updater != null) {
            this.updater.setForceRefresh(true);
        }
    }

    void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.updater != null) {
            this.updater.update();
        }
    }

    void resetData() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        }
        if (this.cpuView != null) {
            this.cpuView.resetData();
            this.cpuView.setDiffView(false);
        }
    }

    void cleanup() {
        if (this.updater != null) {
            this.updater.cleanup();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cpuView = new LiveCPUView(this.getMethodsSelection()){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected void showSource(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                Lookup.Provider provider = MethodsFeatureUI.this.getProject();
                String string = sourceCodeSelection.getClassName();
                String string2 = sourceCodeSelection.getMethodName();
                String string3 = sourceCodeSelection.getMethodSignature();
                GoToSource.openSource((Lookup.Provider)provider, (String)string, (String)string2, (String)string3);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                MethodsFeatureUI.this.selectForProfiling(sourceCodeSelection);
            }

            protected void popupShowing() {
                if (MethodsFeatureUI.this.lrPauseButton.isEnabled() && !MethodsFeatureUI.this.lrRefreshButton.isEnabled()) {
                    MethodsFeatureUI.this.popupPause = true;
                    MethodsFeatureUI.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (MethodsFeatureUI.this.lrPauseButton.isEnabled() && MethodsFeatureUI.this.popupPause) {
                    MethodsFeatureUI.this.popupPause = false;
                    MethodsFeatureUI.this.lrPauseButton.setSelected(false);
                }
            }

            protected void foundInForwardCalls() {
                super.foundInForwardCalls();
                MethodsFeatureUI.this.toggles[0].setSelected(true);
            }

            protected void foundInHotSpots() {
                super.foundInHotSpots();
                MethodsFeatureUI.this.toggles[1].setSelected(true);
            }

            protected void foundInReverseCalls() {
                super.foundInReverseCalls();
                MethodsFeatureUI.this.toggles[2].setSelected(true);
            }
        };
        this.cpuView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileMethods.HelpCtx");
        this.updater = new LiveCPUViewUpdater(this.cpuView, this.getProfilerClient());
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent itemEvent) {
                boolean bl = this.isSelected();
                MethodsFeatureUI.this.updater.setPaused(bl);
                if (!bl) {
                    MethodsFeatureUI.this.refreshResults();
                }
                MethodsFeatureUI.this.refreshToolbar(MethodsFeatureUI.this.getSessionState());
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                MethodsFeatureUI.this.refreshResults();
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                if (!MethodsFeatureUI.this.cpuView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        MultiButtonGroup multiButtonGroup = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        JToggleButton jToggleButton = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MethodsFeatureUI.this.cpuView.setView(this.isSelected(), MethodsFeatureUI.this.toggles[1].isSelected(), MethodsFeatureUI.this.toggles[2].isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        jToggleButton.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton.putClientProperty("JButton.segmentPosition", "first");
        jToggleButton.setToolTipText(Bundle.MethodsFeatureUI_viewForward());
        multiButtonGroup.add((AbstractButton)jToggleButton);
        this.toggles[0] = jToggleButton;
        jToggleButton.setSelected(true);
        JToggleButton jToggleButton2 = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MethodsFeatureUI.this.cpuView.setView(MethodsFeatureUI.this.toggles[0].isSelected(), this.isSelected(), MethodsFeatureUI.this.toggles[2].isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        jToggleButton2.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton2.putClientProperty("JButton.segmentPosition", "middle");
        jToggleButton2.setToolTipText(Bundle.MethodsFeatureUI_viewHotSpots());
        multiButtonGroup.add((AbstractButton)jToggleButton2);
        this.toggles[1] = jToggleButton2;
        jToggleButton2.setSelected(false);
        JToggleButton jToggleButton3 = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                MethodsFeatureUI.this.cpuView.setView(MethodsFeatureUI.this.toggles[0].isSelected(), MethodsFeatureUI.this.toggles[1].isSelected(), this.isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        jToggleButton3.putClientProperty("JButton.buttonType", "segmented");
        jToggleButton3.putClientProperty("JButton.segmentPosition", "last");
        jToggleButton3.setToolTipText(Bundle.MethodsFeatureUI_viewReverse());
        multiButtonGroup.add((AbstractButton)jToggleButton3);
        this.toggles[2] = jToggleButton3;
        jToggleButton3.setSelected(false);
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)((Object)TakeSnapshotAction.getInstance()));
        this.pdSnapshotButton.setHideActionText(true);
        this.pdResetResultsButton = new JButton((Action)((Object)ResetResultsAction.getInstance()));
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.MethodsFeatureUI_view()));
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)jToggleButton);
        this.toolbar.add((Component)jToggleButton2);
        this.toolbar.add((Component)jToggleButton3);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.cpuView.createThreadSelector());
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
        this.cpuView.setView(true, false, false);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(final int n) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean bl = n == 4;
                    MethodsFeatureUI.this.lrPauseButton.setEnabled(bl);
                    MethodsFeatureUI.this.lrRefreshButton.setEnabled(!MethodsFeatureUI.this.popupPause && bl && MethodsFeatureUI.this.lrPauseButton.isSelected());
                    MethodsFeatureUI.this.lrDeltasButton.setEnabled(bl);
                }
            });
        }
    }
}

