/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ToolErrorReporter
implements ErrorReporter {
    private final String messagePrefix = "js: ";
    private boolean hasReportedErrorFlag;
    private boolean reportWarnings;
    private PrintStream err;

    public ToolErrorReporter(boolean reportWarnings) {
        this(reportWarnings, System.err);
    }

    public ToolErrorReporter(boolean reportWarnings, PrintStream err) {
        this.reportWarnings = reportWarnings;
        this.err = err;
    }

    public static String getMessage(String messageId) {
        return ToolErrorReporter.getMessage(messageId, (Object[])null);
    }

    public static String getMessage(String messageId, String argument) {
        Object[] args = new Object[]{argument};
        return ToolErrorReporter.getMessage(messageId, args);
    }

    public static String getMessage(String messageId, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return ToolErrorReporter.getMessage(messageId, args);
    }

    public static String getMessage(String messageId, Object[] args) {
        String formatString;
        Context cx = Context.getCurrentContext();
        Locale locale = cx == null ? Locale.getDefault() : cx.getLocale();
        ResourceBundle rb = ResourceBundle.getBundle("org.mozilla.javascript.tools.resources.Messages", locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        if (args == null) {
            return formatString;
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(args);
    }

    @Override
    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (!this.reportWarnings) {
            return;
        }
        Object[] errArgs = new Object[]{this.formatMessage(message, sourceName, line)};
        message = ToolErrorReporter.getMessage("msg.warning", errArgs);
        this.err.println("js: " + message);
        if (null != lineSource) {
            this.err.println("js: " + lineSource);
            this.err.println("js: " + this.buildIndicator(lineOffset));
        }
    }

    @Override
    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.hasReportedErrorFlag = true;
        message = this.formatMessage(message, sourceName, line);
        this.err.println("js: " + message);
        if (null != lineSource) {
            this.err.println("js: " + lineSource);
            this.err.println("js: " + this.buildIndicator(lineOffset));
        }
    }

    @Override
    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }

    public boolean hasReportedError() {
        return this.hasReportedErrorFlag;
    }

    public boolean isReportingWarnings() {
        return this.reportWarnings;
    }

    public void setIsReportingWarnings(boolean reportWarnings) {
        this.reportWarnings = reportWarnings;
    }

    private String formatMessage(String message, String sourceName, int line) {
        if (line > 0) {
            if (sourceName != null) {
                Object[] errArgs = new Object[]{sourceName, new Integer(line), message};
                return ToolErrorReporter.getMessage("msg.format3", errArgs);
            }
            Object[] errArgs = new Object[]{new Integer(line), message};
            return ToolErrorReporter.getMessage("msg.format2", errArgs);
        }
        Object[] errArgs = new Object[]{message};
        return ToolErrorReporter.getMessage("msg.format1", errArgs);
    }

    private String buildIndicator(int offset) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < offset - 1; ++i) {
            sb.append(".");
        }
        sb.append("^");
        return sb.toString();
    }
}

