/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformProjectOpenProcessor
extends ProjectOpenProcessor
implements CommandLineProjectOpenProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.platform.PlatformProjectOpenProcessor");

    public static PlatformProjectOpenProcessor getInstance() {
        PlatformProjectOpenProcessor projectOpenProcessor = PlatformProjectOpenProcessor.getInstanceIfItExists();
        assert (projectOpenProcessor != null);
        return projectOpenProcessor;
    }

    @Nullable
    public static PlatformProjectOpenProcessor getInstanceIfItExists() {
        for (ProjectOpenProcessor processor2 : EXTENSION_POINT_NAME.getExtensionList()) {
            if (!(processor2 instanceof PlatformProjectOpenProcessor)) continue;
            return (PlatformProjectOpenProcessor)processor2;
        }
        return null;
    }

    public boolean canOpenProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return file2.isDirectory();
    }

    public boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        return false;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        EnumSet<Option> options = EnumSet.noneOf(Option.class);
        if (forceOpenInNewFrame) {
            options.add(Option.FORCE_NEW_FRAME);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            options.add(Option.DO_NOT_USE_DEFAULT_PROJECT);
        }
        return PlatformProjectOpenProcessor.doOpenProject(virtualFile, projectToClose, -1, null, options);
    }

    @Override
    @Nullable
    public Project openProjectAndFile(@NotNull VirtualFile file2, int line2, boolean tempProject) {
        if (file2 == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        EnumSet<Option> options = EnumSet.noneOf(Option.class);
        if (tempProject) {
            options.add(Option.TEMP_PROJECT);
            options.add(Option.FORCE_NEW_FRAME);
        }
        return PlatformProjectOpenProcessor.doOpenProject(file2, null, line2, null, options);
    }

    @Deprecated
    public static Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame, int line2, @Nullable ProjectOpenedCallback callback2, boolean isReopen) {
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        EnumSet<Option> options = EnumSet.noneOf(Option.class);
        if (forceOpenInNewFrame) {
            options.add(Option.FORCE_NEW_FRAME);
        }
        if (isReopen) {
            options.add(Option.REOPEN);
        }
        return PlatformProjectOpenProcessor.doOpenProject(virtualFile, projectToClose, line2, callback2, options);
    }

    @Nullable
    public static Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, int line2, @Nullable ProjectOpenedCallback callback2, @NotNull EnumSet<Option> options) {
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        if (options == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        VirtualFile baseDir = virtualFile;
        boolean dummyProject = false;
        String dummyProjectName = null;
        boolean forceOpenInNewFrame = options.contains((Object)Option.FORCE_NEW_FRAME);
        boolean tempProject = options.contains((Object)Option.TEMP_PROJECT);
        if (!baseDir.isDirectory()) {
            if (tempProject) {
                baseDir = null;
            } else {
                for (baseDir = virtualFile.getParent(); baseDir != null && !com.intellij.openapi.project.ProjectUtil.isProjectDirectoryExistsUsingIo((VirtualFile)baseDir); baseDir = baseDir.getParent()) {
                }
            }
            if (baseDir == null) {
                if (tempProject || Registry.is((String)"ide.open.file.in.temp.project.dir")) {
                    try {
                        dummyProjectName = virtualFile.getName();
                        File directory = FileUtil.createTempDirectory((String)dummyProjectName, null, (boolean)true);
                        baseDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
                        dummyProject = true;
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
                if (baseDir == null) {
                    baseDir = virtualFile.getParent();
                }
            }
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            if (projectToClose == null) {
                IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
                Project project = projectToClose = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
                if (projectToClose == null) {
                    projectToClose = openProjects[openProjects.length - 1];
                }
            }
            if (PlatformProjectOpenProcessor.checkExistingProjectOnOpen(projectToClose, callback2, baseDir)) {
                return null;
            }
        }
        Pair result2 = null;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            result2 = PlatformProjectOpenProcessor.prepareAndOpenProject(virtualFile, options, baseDir, dummyProject, dummyProjectName);
        } else {
            IdeFrameImpl frame = PlatformProjectOpenProcessor.showFrame();
            Ref refResult = Ref.create();
            VirtualFile finalBaseDir = baseDir;
            boolean finalDummyProject = dummyProject;
            String finalDummyProjectName = dummyProjectName;
            Runnable process2 = () -> refResult.set(PlatformProjectOpenProcessor.prepareAndOpenProject(virtualFile, options, finalBaseDir, finalDummyProject, finalDummyProjectName));
            boolean progressCompleted = ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, "Loading Project...", true, null, frame.getComponent());
            if (progressCompleted) {
                result2 = (Pair)refResult.get();
            }
        }
        if (result2 == null || result2.first == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!virtualFile.isDirectory()) {
            PlatformProjectOpenProcessor.openFileFromCommandLine((Project)result2.first, virtualFile, line2);
        }
        if (callback2 != null) {
            callback2.projectOpened((Project)result2.first, (Module)result2.second);
        }
        return (Project)result2.first;
    }

    @NotNull
    private static IdeFrameImpl showFrame() {
        WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
        IdeFrameImpl freeRootFrame = windowManager.getRootFrame();
        if (freeRootFrame != null) {
            IdeFrameImpl ideFrameImpl = freeRootFrame;
            if (ideFrameImpl == null) {
                PlatformProjectOpenProcessor.$$$reportNull$$$0(7);
            }
            return ideFrameImpl;
        }
        Activity showFrameActivity = StartUpMeasurer.start((String)"show frame");
        IdeFrameImpl frame = windowManager.showFrame();
        showFrameActivity.end();
        ApplicationManager.getApplication().invokeLater(() -> {
            Activity activity = StartUpMeasurer.start((String)"init frame");
            if (frame.isDisplayable()) {
                frame.init();
            }
            activity.end();
        }, ModalityState.any());
        IdeFrameImpl ideFrameImpl = frame;
        if (ideFrameImpl == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(8);
        }
        return ideFrameImpl;
    }

    @Nullable
    private static Pair<Project, Module> prepareAndOpenProject(@NotNull VirtualFile virtualFile, @NotNull EnumSet<Option> options, VirtualFile baseDir, boolean dummyProject, String dummyProjectName) {
        Project project;
        if (virtualFile == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(9);
        }
        if (options == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(10);
        }
        boolean newProject = false;
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        VirtualFile dotIdeaDir = baseDir.findChild(".idea");
        if (dotIdeaDir != null && dotIdeaDir.isDirectory()) {
            project = PlatformProjectOpenProcessor.tryLoadProject(baseDir);
        } else {
            project = projectManager.newProject(dummyProject ? dummyProjectName : baseDir.getName(), baseDir.getPath(), !options.contains((Object)Option.DO_NOT_USE_DEFAULT_PROJECT), dummyProject);
            newProject = true;
        }
        if (project == null) {
            return null;
        }
        ProjectBaseDirectory.getInstance(project).setBaseDir(baseDir);
        Module module = PlatformProjectOpenProcessor.configureNewProject(project, baseDir, virtualFile, dummyProject, newProject);
        if (newProject) {
            project.save();
        }
        return projectManager.openProject(project) ? new Pair((Object)project, (Object)module) : null;
    }

    private static Project tryLoadProject(VirtualFile baseDir) {
        try {
            for (ProjectOpenProcessor processor2 : ProjectOpenProcessor.EXTENSION_POINT_NAME.getExtensionList()) {
                processor2.refreshProjectFiles(baseDir);
            }
            return ProjectManagerEx.getInstanceEx().convertAndLoadProject(baseDir);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static Module configureNewProject(Project project, VirtualFile baseDir, @NotNull VirtualFile dummyFileContentRoot, boolean dummyProject, boolean newProject) {
        if (dummyFileContentRoot == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(11);
        }
        boolean runConfigurators = newProject || ModuleManager.getInstance((Project)project).getModules().length == 0;
        Ref module = new Ref();
        if (runConfigurators) {
            ApplicationManager.getApplication().invokeAndWait(() -> module.set((Object)PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, project)));
        } else {
            module.set((Object)ModuleManager.getInstance((Project)project).getModules()[0]);
        }
        if (runConfigurators && dummyProject) {
            ModuleRootModificationUtil.updateModel((Module)((Module)module.get()), model2 -> {
                ContentEntry[] entries = model2.getContentEntries();
                if (entries.length == 1) {
                    model2.removeContentEntry(entries[0]);
                }
                model2.addContentEntry(dummyFileContentRoot);
            });
        }
        return (Module)module.get();
    }

    private static boolean checkExistingProjectOnOpen(@NotNull Project projectToClose, @Nullable ProjectOpenedCallback callback2, VirtualFile baseDir) {
        if (projectToClose == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(12);
        }
        if (ProjectAttachProcessor.canAttachToProject() && GeneralSettings.getInstance().getConfirmOpenNewProject() == -1) {
            int exitCode = ProjectUtil.confirmOpenOrAttachProject();
            if (exitCode == -1) {
                return true;
            }
            if (exitCode == 1 ? !ProjectManagerEx.getInstanceEx().closeAndDispose(projectToClose) : exitCode == 2 && PlatformProjectOpenProcessor.attachToProject(projectToClose, Paths.get(FileUtil.toSystemDependentName((String)baseDir.getPath()), new String[0]), callback2)) {
                return true;
            }
            IdeEventQueue.getInstance().flushQueue();
        } else {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1 ? !ProjectManagerEx.getInstanceEx().closeAndDispose(projectToClose) : exitCode != 0) {
                return true;
            }
        }
        return false;
    }

    public static Module runDirectoryProjectConfigurators(@NotNull VirtualFile baseDir, @NotNull Project project) {
        if (baseDir == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(14);
        }
        Ref moduleRef = new Ref();
        for (DirectoryProjectConfigurator configurator : DirectoryProjectConfigurator.EP_NAME.getIterable()) {
            try {
                configurator.configureProject(project, baseDir, (Ref<Module>)moduleRef);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return (Module)moduleRef.get();
    }

    public static boolean attachToProject(Project project, @NotNull Path projectDir, ProjectOpenedCallback callback2) {
        if (projectDir == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(15);
        }
        for (ProjectAttachProcessor processor2 : ProjectAttachProcessor.EP_NAME.getExtensionList()) {
            if (!processor2.attachToProject(project, projectDir, callback2)) continue;
            return true;
        }
        return false;
    }

    private static void openFileFromCommandLine(Project project, VirtualFile file2, int line2) {
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed() && file2.isValid()) {
                (line2 > 0 ? new OpenFileDescriptor(project, file2, line2 - 1, 0) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1)).navigate(true);
            }
        }, ModalityState.NON_MODAL)));
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("text editor" == null) {
            PlatformProjectOpenProcessor.$$$reportNull$$$0(16);
        }
        return "text editor";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/PlatformProjectOpenProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dummyFileContentRoot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectToClose";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/PlatformProjectOpenProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "showFrame";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canOpenProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openProjectAndFile";
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndOpenProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureNewProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingProjectOnOpen";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runDirectoryProjectConfigurators";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "attachToProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Option {
        FORCE_NEW_FRAME,
        REOPEN,
        TEMP_PROJECT,
        DO_NOT_USE_DEFAULT_PROJECT;

    }
}

